/*
 * Decompiled with CFR 0.152.
 */
package activity.util;

import activity.Activity;
import activity.Event;
import activity.RaiseEvent;
import activity.RequireEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.lsat.common.graph.directed.editable.EdgQueries;

public class EventSequenceValidator {
    private EventSequenceValidator() {
    }

    public static void validate(List<Activity> activitySequence, ErrorRaiser errorRaiser) {
        LinkedHashMap<String, List<Event>> eventMaps = new LinkedHashMap<String, List<Event>>();
        LinkedHashSet<String> alreadyRaised = new LinkedHashSet<String>();
        int i = 0;
        while (i < activitySequence.size()) {
            Activity a = activitySequence.get(i);
            Iterable stream = EdgQueries.topologicalOrdering((Iterable)a.getNodes()).stream().filter(Event.class::isInstance).map(Event.class::cast)::iterator;
            for (Event event : stream) {
                int numEventPending = EventSequenceValidator.updateEvents(eventMaps, event);
                if (numEventPending < 0 && alreadyRaised.add(event.getEventName())) {
                    errorRaiser.raise(i, "Event '" + event.getEventName() + "' required for activity '" + a.getName() + "' but not raised before");
                    continue;
                }
                if (numEventPending <= 1 || !alreadyRaised.add(event.getEventName())) continue;
                errorRaiser.raise(i, "Event '" + event.getEventName() + "' in activity '" + a.getName() + "' raised more than once before consumed");
            }
            ++i;
        }
        for (Map.Entry e : eventMaps.entrySet()) {
            List eventList;
            if (alreadyRaised.contains(e.getKey()) || (eventList = (List)e.getValue()) == null || eventList.size() <= 0) continue;
            if (eventList.get(eventList.size() - 1) instanceof RaiseEvent) {
                eventList.remove(eventList.size() - 1);
            }
            if (EventSequenceValidator.countEvents(eventList) <= 0) continue;
            errorRaiser.raise(-1, "The total number 'raise' and 'requires' for event '" + (String)e.getKey() + "' should be equal in a dispatching sequence");
        }
    }

    private static int updateEvents(Map<String, List<Event>> eventsMap, Event event) {
        List<Event> events = eventsMap.get(event.getEventName());
        if (events == null) {
            events = new ArrayList<Event>();
            eventsMap.put(event.getEventName(), events);
            if (event instanceof RequireEvent) {
                return 0;
            }
        }
        events.add(event);
        return EventSequenceValidator.countEvents(events);
    }

    private static int countEvents(List<Event> events) {
        return events.stream().mapToInt(e -> e instanceof RequireEvent ? -1 : 1).sum();
    }

    public static interface ErrorRaiser {
        public void raise(int var1, String var2);
    }
}

