/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.layout;

import activity.Activity;
import activity.ActivityPackage;
import activity.Claim;
import activity.Event;
import activity.PeripheralAction;
import activity.RequireEvent;
import activity.SchedulingType;
import activity.SyncBar;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import machine.IResource;
import machine.Peripheral;
import org.eclipse.elk.conn.gmf.GmfDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ZOrderRequest;
import org.eclipse.lsat.activity.diagram.layout.ActivityDiagramLayoutOptions;
import org.eclipse.lsat.common.graph.directed.editable.EdgQueries;
import org.eclipse.lsat.common.graph.directed.editable.Edge;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.util.IterableUtil;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IWorkbenchPart;

@Singleton
public class ActivityDiagramLayoutConnector
extends GmfDiagramLayoutConnector {
    public void applyLayout(LayoutMapping mapping, IPropertyHolder settings) {
        HashMap<EditPart, List> toFrontRequests = new HashMap<EditPart, List>();
        for (Map.Entry entry : mapping.getGraphMap().entrySet()) {
            if (!ActivityPackage.Literals.SYNC_BAR.equals(((ElkGraphElement)entry.getKey()).getProperty(ActivityDiagramLayoutOptions.E_CLASS))) continue;
            IGraphicalEditPart editPart = (IGraphicalEditPart)entry.getValue();
            List partsToOrder = toFrontRequests.computeIfAbsent(editPart.getParent(), e -> new ArrayList());
            partsToOrder.add(editPart);
        }
        for (Map.Entry entry : toFrontRequests.entrySet()) {
            ZOrderRequest request = new ZOrderRequest("bringToFrontAction");
            request.setPartsToOrder((List)entry.getValue());
            ((EditPart)entry.getKey()).performRequest((Request)request);
        }
        super.applyLayout(mapping, settings);
    }

    protected LayoutMapping buildLayoutGraph(IGraphicalEditPart layoutRootPart, List<ShapeNodeEditPart> selection, IWorkbenchPart workbenchPart) {
        LayoutMapping layoutMapping = super.buildLayoutGraph(layoutRootPart, selection, workbenchPart);
        EObject modelElement = ActivityDiagramLayoutConnector.getModelElement(layoutRootPart);
        if (modelElement instanceof Activity) {
            this.addNodeProperties((Activity)modelElement, layoutMapping);
        }
        return layoutMapping;
    }

    private void addNodeProperties(Activity activity, LayoutMapping layoutMapping) {
        HashMap<Node, Integer> layoutRows = this.determineNodeLayoutRows(activity);
        for (Map.Entry entry : layoutMapping.getGraphMap().entrySet()) {
            EObject modelElement = ActivityDiagramLayoutConnector.getModelElement((IGraphicalEditPart)entry.getValue());
            ElkGraphElement elkGraphElement = (ElkGraphElement)entry.getKey();
            if (modelElement == null) continue;
            elkGraphElement.setProperty(ActivityDiagramLayoutOptions.E_CLASS, (Object)modelElement.eClass());
            if (modelElement instanceof Node) {
                elkGraphElement.setProperty(ActivityDiagramLayoutOptions.NAME, (Object)((Node)modelElement).getName());
            } else if (modelElement instanceof IResource) {
                elkGraphElement.setProperty(ActivityDiagramLayoutOptions.NAME, (Object)((IResource)modelElement).getName());
            } else if (modelElement instanceof Peripheral) {
                elkGraphElement.setProperty(ActivityDiagramLayoutOptions.NAME, (Object)((Peripheral)modelElement).getName());
            }
            if (modelElement instanceof Event) {
                elkGraphElement.setProperty(ActivityDiagramLayoutOptions.EVENT_NAME, (Object)((Event)modelElement).getEventName());
            }
            if (modelElement instanceof Node && layoutRows.containsKey(modelElement)) {
                int layoutRow = layoutRows.get(modelElement);
                elkGraphElement.setProperty(ActivityDiagramLayoutOptions.LAYOUT_ROW, (Object)layoutRow);
                continue;
            }
            elkGraphElement.setProperty(ActivityDiagramLayoutOptions.LAYOUT_ROW, (Object)-1);
        }
    }

    private HashMap<Node, Integer> determineNodeLayoutRows(Activity activity) {
        int row;
        EList topologicalSortedNodes = EdgQueries.topologicalOrdering((Iterable)activity.getNodes(), Comparator.comparing(ActivityDiagramLayoutConnector::isALAP).thenComparing(Node::getName));
        int maxRow = 0;
        HashMap<Node, Integer> layoutRows = new HashMap<Node, Integer>();
        for (Node node : topologicalSortedNodes) {
            if (node instanceof SyncBar) {
                row = maxRow + 1;
            } else {
                row = ActivityDiagramLayoutConnector.getMaxParentRow(node, layoutRows) + 1;
                if (ActivityDiagramLayoutConnector.isALAP(node)) {
                    row = Math.max(row, maxRow);
                }
                while (ActivityDiagramLayoutConnector.rowContainsSyncbar(row, layoutRows)) {
                    ++row;
                }
            }
            layoutRows.put(node, row);
            maxRow = Math.max(maxRow, row);
        }
        Lists.reverse((List)topologicalSortedNodes);
        for (Node node : topologicalSortedNodes) {
            if (!ActivityDiagramLayoutConnector.isALAP(node) || node instanceof SyncBar) continue;
            row = ActivityDiagramLayoutConnector.getMinLeafRow(node, layoutRows) - 1;
            while (ActivityDiagramLayoutConnector.rowContainsSyncbar(row, layoutRows)) {
                --row;
            }
            layoutRows.put(node, row);
        }
        return layoutRows;
    }

    private static boolean isALAP(Node node) {
        if (node instanceof PeripheralAction) {
            return ((PeripheralAction)node).getSchedulingType() == SchedulingType.ALAP;
        }
        if (node instanceof SyncBar) {
            return node.getIncomingEdges().size() > 1;
        }
        return node instanceof Claim || node instanceof RequireEvent;
    }

    private static EObject getModelElement(IGraphicalEditPart editPart) {
        EObject semanticDecorator = editPart.resolveSemanticElement();
        return semanticDecorator instanceof DSemanticDecorator ? ((DSemanticDecorator)semanticDecorator).getTarget() : null;
    }

    private static int getMaxParentRow(Node node, HashMap<Node, Integer> layoutRows) {
        return (Integer)IterableUtil.max((Iterable)QueryableIterable.from((Iterable)node.getIncomingEdges()).xcollectOne(Edge::getSourceNode).xcollectOne(layoutRows::get), (Comparable)Integer.valueOf(-1));
    }

    private static int getMinLeafRow(Node node, HashMap<Node, Integer> layoutRows) {
        int maxRow = (Integer)IterableUtil.max(layoutRows.values(), (Comparable)Integer.valueOf(-1));
        return (Integer)IterableUtil.min((Iterable)QueryableIterable.from((Iterable)node.getOutgoingEdges()).xcollectOne(Edge::getTargetNode).xcollectOne(layoutRows::get), (Comparable)Integer.valueOf(maxRow));
    }

    private static boolean rowContainsSyncbar(int row, HashMap<Node, Integer> layoutRows) {
        return QueryableIterable.from(layoutRows.entrySet()).select(e -> (Integer)e.getValue() == row).exists(e -> e.getKey() instanceof SyncBar);
    }
}

