/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.design;

import activity.ActivityFactory;
import activity.Event;
import activity.RaiseEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddEventActionPage
extends WizardPage {
    private final String initialActionName;
    private Text textName;
    private Text textEventName;
    private ComboViewer comboEventType;

    public AddEventActionPage(String initialActionName) {
        super(AddEventActionPage.class.getSimpleName());
        this.setTitle("Event details");
        this.setDescription("Provide the details for the event to add");
        this.initialActionName = initialActionName;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblName = new Label(container, 0);
        lblName.setAlignment(131072);
        lblName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblName.setText("Action Name:");
        this.textName = new Text(container, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textName.setText(this.initialActionName);
        Label evtName = new Label(container, 0);
        evtName.setAlignment(131072);
        evtName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        evtName.setText("Event Name:");
        this.textEventName = new Text(container, 2048);
        this.textEventName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblType = new Label(container, 0);
        lblType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblType.setText("Event type:");
        this.comboEventType = new ComboViewer(container, 0);
        this.comboEventType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboEventType.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboEventType.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboEventType.getCombo().setEnabled(true);
        this.comboEventType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddEventActionPage.this.updatePageComplete();
            }
        });
        this.comboEventType.setInput((Object)EventType.values());
    }

    public Event createEventAction() {
        String actionName = this.textName.getText();
        String eventName = this.textEventName.getText();
        EventType type = (EventType)((Object)((StructuredSelection)this.comboEventType.getSelection()).getFirstElement());
        RaiseEvent event = type == EventType.Raise ? ActivityFactory.eINSTANCE.createRaiseEvent() : ActivityFactory.eINSTANCE.createRequireEvent();
        event.setName(actionName);
        event.setEventName(eventName);
        return event;
    }

    private void updatePageComplete() {
        boolean pageComplete = true;
        pageComplete &= !this.textName.getText().isEmpty();
        pageComplete &= !this.textEventName.getText().isEmpty();
        this.setPageComplete(pageComplete &= !this.comboEventType.getSelection().isEmpty());
    }

    private static enum EventType {
        Require("Require event"),
        Raise("Raise event");

        private final String description;

        private EventType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

