/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.GlobalJob;
import org.mandas.docker.client.messages.swarm.GlobalService;
import org.mandas.docker.client.messages.swarm.ImmutableServiceMode;
import org.mandas.docker.client.messages.swarm.ReplicatedJob;
import org.mandas.docker.client.messages.swarm.ReplicatedService;

@JsonDeserialize(builder=ImmutableServiceMode.Builder.class)
@Value.Immutable
public interface ServiceMode {
    @JsonProperty(value="Replicated")
    @Nullable
    public ReplicatedService replicated();

    @JsonProperty(value="ReplicatedJob")
    @Nullable
    public ReplicatedJob replicatedJob();

    @JsonProperty(value="Global")
    @Nullable
    public GlobalService global();

    @JsonProperty(value="GlobalJob")
    @Nullable
    public GlobalJob globalJob();

    public static ServiceMode withReplicas(long replicas) {
        return ImmutableServiceMode.builder().replicated(ReplicatedService.builder().replicas(replicas).build()).build();
    }

    public static ServiceMode withReplicas(long replicas, long maxConcurrent) {
        return ImmutableServiceMode.builder().replicated(ReplicatedService.builder().replicas(replicas).maxConcurrent(maxConcurrent).build()).build();
    }

    public static ServiceMode withJobReplicas(long totalCompletions) {
        return ImmutableServiceMode.builder().replicatedJob(ReplicatedJob.builder().totalCompletions(totalCompletions).build()).build();
    }

    public static ServiceMode withJobReplicas(long totalCompletions, long maxConcurrent) {
        return ImmutableServiceMode.builder().replicatedJob(ReplicatedJob.builder().totalCompletions(totalCompletions).maxConcurrent(maxConcurrent).build()).build();
    }

    public static ServiceMode withGlobal() {
        return ImmutableServiceMode.builder().global(GlobalService.builder().build()).build();
    }

    public static ServiceMode withGlobalJob() {
        return ImmutableServiceMode.builder().globalJob(GlobalJob.builder().build()).build();
    }

    public static Builder builder() {
        return ImmutableServiceMode.builder();
    }

    public static interface Builder {
        public Builder replicated(ReplicatedService var1);

        public Builder replicatedJob(ReplicatedJob var1);

        public Builder global(GlobalService var1);

        public Builder globalJob(GlobalJob var1);

        public ServiceMode build();
    }
}

