/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.color;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.color.ColorInformationMining;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;

public class DocumentColorProvider
extends AbstractCodeMiningProvider {
    private final Map<RGBA, Color> colorTable = new HashMap<RGBA, Color>();

    private @Nullable CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(IDocument document) {
        URI docURI = LSPEclipseUtils.toUri(document);
        if (docURI != null) {
            TextDocumentIdentifier textDocumentIdentifier = LSPEclipseUtils.toTextDocumentIdentifier(docURI);
            DocumentColorParams param = new DocumentColorParams(textDocumentIdentifier);
            return ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getColorProvider)).collectAll((wrapper, ls) -> ls.getTextDocumentService().documentColor(param).thenApply(colors -> LanguageServers.streamSafely(colors).map(color -> this.toMining((ColorInformation)color, document, textDocumentIdentifier, (LanguageServerWrapper)wrapper)))).thenApply(res -> res.stream().flatMap(Function.identity()).filter(Objects::nonNull).toList());
        }
        return null;
    }

    private @Nullable ColorInformationMining toMining(ColorInformation color, IDocument document, TextDocumentIdentifier textDocumentIdentifier, LanguageServerWrapper wrapper) {
        try {
            return new ColorInformationMining(color, document, textDocumentIdentifier, wrapper, this);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
    }

    public @Nullable CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        IDocument document = viewer.getDocument();
        return document != null ? this.provideCodeMinings(document) : null;
    }

    public Color getColor(RGBA rgba, Display display) {
        return this.colorTable.computeIfAbsent(rgba, key -> new Color((Device)display, rgba));
    }
}

