/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.NetProtocol;
import org.eclipse.kura.net.NetworkPair;
import org.eclipse.kura.net.firewall.FirewallAutoNatConfig;
import org.eclipse.kura.net.firewall.FirewallNatConfig;
import org.eclipse.kura.net.firewall.FirewallOpenPortConfigIP;
import org.eclipse.kura.net.firewall.FirewallOpenPortConfigIP4;
import org.eclipse.kura.net.firewall.FirewallOpenPortConfigIP6;
import org.eclipse.kura.net.firewall.FirewallPortForwardConfigIP;
import org.eclipse.kura.net.firewall.FirewallPortForwardConfigIP4;
import org.eclipse.kura.net.firewall.FirewallPortForwardConfigIP6;
import org.eclipse.kura.net.firewall.RuleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirewallConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FirewallConfiguration.class);
    public static final String OPEN_PORTS_PROP_NAME = "firewall.open.ports";
    public static final String PORT_FORWARDING_PROP_NAME = "firewall.port.forwarding";
    public static final String NAT_PROP_NAME = "firewall.nat";
    public static final String DFLT_OPEN_PORTS_VALUE = "";
    public static final String DFLT_PORT_FORWARDING_VALUE = "";
    public static final String DFLT_NAT_VALUE = "";
    private List<FirewallOpenPortConfigIP<? extends IPAddress>> openPortConfigs = new ArrayList<FirewallOpenPortConfigIP<? extends IPAddress>>();
    private List<FirewallPortForwardConfigIP<? extends IPAddress>> portForwardConfigs = new ArrayList<FirewallPortForwardConfigIP<? extends IPAddress>>();
    private List<FirewallNatConfig> natConfigs = new ArrayList<FirewallNatConfig>();
    private List<FirewallAutoNatConfig> autoNatConfigs = new ArrayList<FirewallAutoNatConfig>();

    public FirewallConfiguration() {
    }

    public FirewallConfiguration(Map<String, Object> properties) {
        this();
        this.parseOpenPortRules(properties);
        this.parsePortForwardingRules(properties);
        this.parseNatRules(properties);
    }

    private void parseNatRules(Map<String, Object> properties) {
        String propertyValue;
        if (properties.containsKey(this.getNatPropertyName()) && !(propertyValue = (String)properties.get(this.getNatPropertyName())).isEmpty()) {
            String[] natRules = propertyValue.split(";");
            Arrays.asList(natRules).forEach(this::parseNatRule);
        }
    }

    private void parseNatRule(String rule) {
        String[] rulesItems = rule.split(",");
        if (rulesItems.length == 7 && "#".equals(rulesItems[6])) {
            String srcIface = null;
            if (!rulesItems[0].isEmpty()) {
                srcIface = rulesItems[0];
            }
            String dstIface = null;
            if (!rulesItems[1].isEmpty()) {
                dstIface = rulesItems[1];
            }
            String protocol = null;
            if (!rulesItems[2].isEmpty()) {
                protocol = rulesItems[2];
            }
            String src = null;
            if (!rulesItems[3].isEmpty()) {
                src = rulesItems[3];
            }
            String dst = null;
            if (!rulesItems[4].isEmpty()) {
                dst = rulesItems[4];
            }
            boolean masquerade = Boolean.parseBoolean(rulesItems[5]);
            FirewallNatConfig natEntry = new FirewallNatConfig(srcIface, dstIface, protocol, src, dst, masquerade, RuleType.IP_FORWARDING);
            this.natConfigs.add(natEntry);
        }
    }

    private void parsePortForwardingRules(Map<String, Object> properties) {
        String propertyValue;
        if (properties.containsKey(this.getPortForwardingPropertyName()) && !(propertyValue = (String)properties.get(this.getPortForwardingPropertyName())).isEmpty()) {
            String[] portForwardingRules = propertyValue.split(";");
            Arrays.asList(portForwardingRules).forEach(this::parsePortForwardingRule);
        }
    }

    private void parsePortForwardingRule(String rule) {
        try {
            String[] rulesItems = rule.split(",");
            if (rulesItems.length == 11 && "#".equals(rulesItems[10])) {
                this.portForwardConfigs.add(this.buildPortForwardConfigIP(rulesItems));
            }
        }
        catch (Exception e) {
            logger.error("Failed to parse Port Forward Entry", (Throwable)e);
        }
    }

    protected FirewallPortForwardConfigIP<? extends IPAddress> buildPortForwardConfigIP(String[] rulesItems) throws UnknownHostException {
        String inboundIface = null;
        if (!rulesItems[0].isEmpty()) {
            inboundIface = rulesItems[0];
        }
        String outboundIface = null;
        if (!rulesItems[1].isEmpty()) {
            outboundIface = rulesItems[1];
        }
        IPAddress address = IPAddress.parseHostAddress((String)rulesItems[2]);
        NetProtocol protocol = NetProtocol.valueOf((String)rulesItems[3]);
        int inPort = Integer.parseInt(rulesItems[4]);
        int outPort = Integer.parseInt(rulesItems[5]);
        boolean masquerade = Boolean.parseBoolean(rulesItems[6]);
        String permittedNetwork = null;
        short permittedNetworkMask = 0;
        if (!rulesItems[7].isEmpty()) {
            permittedNetwork = rulesItems[7].split("/")[0];
            permittedNetworkMask = Short.parseShort(rulesItems[7].split("/")[1]);
        } else {
            permittedNetwork = IP4Address.getDefaultAddress().getHostAddress();
        }
        String permittedMAC = null;
        if (!rulesItems[8].isEmpty()) {
            permittedMAC = rulesItems[8];
        }
        String sourcePortRange = null;
        if (!rulesItems[9].isEmpty()) {
            sourcePortRange = rulesItems[9];
        }
        FirewallPortForwardConfigIP4.FirewallPortForwardConfigIP4Builder builder = FirewallPortForwardConfigIP4.builder();
        ((FirewallPortForwardConfigIP4.FirewallPortForwardConfigIP4Builder)((FirewallPortForwardConfigIP4.FirewallPortForwardConfigIP4Builder)((FirewallPortForwardConfigIP4.FirewallPortForwardConfigIP4Builder)((FirewallPortForwardConfigIP4.FirewallPortForwardConfigIP4Builder)((FirewallPortForwardConfigIP4.FirewallPortForwardConfigIP4Builder)((FirewallPortForwardConfigIP4.FirewallPortForwardConfigIP4Builder)((FirewallPortForwardConfigIP4.FirewallPortForwardConfigIP4Builder)((FirewallPortForwardConfigIP4.FirewallPortForwardConfigIP4Builder)((FirewallPortForwardConfigIP4.FirewallPortForwardConfigIP4Builder)builder.withInboundIface(inboundIface)).withOutboundIface(outboundIface)).withAddress((IPAddress)((IP4Address)address))).withProtocol(protocol)).withInPort(inPort)).withOutPort(outPort)).withMasquerade(masquerade)).withPermittedNetwork(this.convertNetworkPairIPv4(String.valueOf(permittedNetwork) + "/" + permittedNetworkMask))).withPermittedMac(permittedMAC)).withSourcePortRange(sourcePortRange);
        return builder.build();
    }

    private void parseOpenPortRules(Map<String, Object> properties) {
        String propertyValue;
        if (properties.containsKey(this.getOpenPortsPropertyName()) && !(propertyValue = (String)properties.get(this.getOpenPortsPropertyName())).isEmpty()) {
            String[] openPortRules = propertyValue.split(";");
            Arrays.asList(openPortRules).forEach(this::parseOpenPortRule);
        }
    }

    private void parseOpenPortRule(String rule) {
        try {
            String[] ruleItems = rule.split(",");
            if (ruleItems.length == 8 && "#".equals(ruleItems[7])) {
                this.openPortConfigs.add(this.buildOpenPortConfigIP(ruleItems));
            }
        }
        catch (Exception e) {
            logger.error("Failed to parse Open Port Entry", (Throwable)e);
        }
    }

    protected FirewallOpenPortConfigIP<? extends IPAddress> buildOpenPortConfigIP(String[] openPortRuleItems) throws UnknownHostException {
        FirewallOpenPortConfigIP4 openPortEntry = null;
        FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder builder = FirewallOpenPortConfigIP4.builder();
        NetProtocol protocol = NetProtocol.valueOf((String)openPortRuleItems[1]);
        String permittedNetwork = null;
        short permittedNetworkMask = 0;
        if (!openPortRuleItems[2].isEmpty()) {
            permittedNetwork = openPortRuleItems[2].split("/")[0];
            permittedNetworkMask = Short.parseShort(openPortRuleItems[2].split("/")[1]);
        } else {
            permittedNetwork = IP4Address.getDefaultAddress().getHostAddress();
        }
        String permittedIface = null;
        if (!openPortRuleItems[3].isEmpty()) {
            permittedIface = openPortRuleItems[3];
        }
        String unpermittedIface = null;
        if (!openPortRuleItems[4].isEmpty()) {
            unpermittedIface = openPortRuleItems[4];
        }
        String permittedMAC = null;
        if (!openPortRuleItems[5].isEmpty()) {
            permittedMAC = openPortRuleItems[5];
        }
        String sourcePortRange = null;
        if (!openPortRuleItems[6].isEmpty()) {
            sourcePortRange = openPortRuleItems[6];
        }
        int port = 0;
        String portRange = null;
        if (openPortRuleItems[0].contains(":")) {
            portRange = openPortRuleItems[0];
            ((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)builder.withPortRange(portRange)).withProtocol(protocol)).withPermittedNetwork(this.convertNetworkPairIPv4(String.valueOf(permittedNetwork) + "/" + permittedNetworkMask))).withPermittedInterfaceName(permittedIface)).withUnpermittedInterfaceName(unpermittedIface)).withPermittedMac(permittedMAC)).withSourcePortRange(sourcePortRange);
            openPortEntry = builder.build();
        } else {
            port = Integer.parseInt(openPortRuleItems[0]);
            ((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)((FirewallOpenPortConfigIP4.FirewallOpenPortConfigIP4Builder)builder.withPort(port)).withProtocol(protocol)).withPermittedNetwork(this.convertNetworkPairIPv4(String.valueOf(permittedNetwork) + "/" + permittedNetworkMask))).withPermittedInterfaceName(permittedIface)).withUnpermittedInterfaceName(unpermittedIface)).withPermittedMac(permittedMAC)).withSourcePortRange(sourcePortRange);
            openPortEntry = builder.build();
        }
        return openPortEntry;
    }

    public String getOpenPortsPropertyName() {
        return OPEN_PORTS_PROP_NAME;
    }

    public String getPortForwardingPropertyName() {
        return PORT_FORWARDING_PROP_NAME;
    }

    public String getNatPropertyName() {
        return NAT_PROP_NAME;
    }

    private NetworkPair<IP4Address> convertNetworkPairIPv4(String permittedNetwork) throws UnknownHostException {
        if (permittedNetwork == null || permittedNetwork.isEmpty()) {
            return new NetworkPair((IPAddress)IP4Address.getDefaultAddress(), 0);
        }
        String[] split = permittedNetwork.split("/");
        return new NetworkPair((IPAddress)((IP4Address)IPAddress.parseHostAddress((String)split[0])), Short.parseShort(split[1]));
    }

    public void addConfig(NetConfig netConfig) {
        if (netConfig instanceof FirewallOpenPortConfigIP4) {
            this.openPortConfigs.add((FirewallOpenPortConfigIP<? extends IPAddress>)((FirewallOpenPortConfigIP4)netConfig));
        } else if (netConfig instanceof FirewallPortForwardConfigIP4) {
            this.portForwardConfigs.add((FirewallPortForwardConfigIP<? extends IPAddress>)((FirewallPortForwardConfigIP4)netConfig));
        } else if (netConfig instanceof FirewallOpenPortConfigIP6) {
            this.openPortConfigs.add((FirewallOpenPortConfigIP<? extends IPAddress>)((FirewallOpenPortConfigIP6)netConfig));
        } else if (netConfig instanceof FirewallPortForwardConfigIP6) {
            this.portForwardConfigs.add((FirewallPortForwardConfigIP<? extends IPAddress>)((FirewallPortForwardConfigIP6)netConfig));
        } else if (netConfig instanceof FirewallNatConfig) {
            this.natConfigs.add((FirewallNatConfig)netConfig);
        } else if (netConfig instanceof FirewallAutoNatConfig) {
            this.autoNatConfigs.add((FirewallAutoNatConfig)netConfig);
        }
    }

    public List<NetConfig> getConfigs() {
        ArrayList<NetConfig> netConfigs = new ArrayList<NetConfig>();
        for (FirewallOpenPortConfigIP<? extends IPAddress> firewallOpenPortConfigIP : this.openPortConfigs) {
            netConfigs.add((NetConfig)firewallOpenPortConfigIP);
        }
        for (FirewallPortForwardConfigIP firewallPortForwardConfigIP : this.portForwardConfigs) {
            netConfigs.add((NetConfig)firewallPortForwardConfigIP);
        }
        for (FirewallNatConfig firewallNatConfig : this.natConfigs) {
            netConfigs.add((NetConfig)firewallNatConfig);
        }
        for (FirewallAutoNatConfig firewallAutoNatConfig : this.autoNatConfigs) {
            netConfigs.add((NetConfig)firewallAutoNatConfig);
        }
        return netConfigs;
    }

    public List<FirewallOpenPortConfigIP<? extends IPAddress>> getOpenPortConfigs() {
        return this.openPortConfigs;
    }

    public List<FirewallPortForwardConfigIP<? extends IPAddress>> getPortForwardConfigs() {
        return this.portForwardConfigs;
    }

    public List<FirewallNatConfig> getNatConfigs() {
        return this.natConfigs;
    }

    public List<FirewallAutoNatConfig> getAutoNatConfigs() {
        return this.autoNatConfigs;
    }

    public Map<String, Object> getConfigurationProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(this.getOpenPortsPropertyName(), this.formOpenPortConfigPropValue());
        props.put(this.getPortForwardingPropertyName(), this.formPortForwardConfigPropValue());
        props.put(this.getNatPropertyName(), this.formNatConfigPropValue());
        return props;
    }

    private String formOpenPortConfigPropValue() {
        StringBuilder sb = new StringBuilder();
        this.openPortConfigs.forEach(openPortConfig -> {
            String port = openPortConfig.getPortRange();
            if (port == null) {
                port = Integer.toString(openPortConfig.getPort());
            }
            sb.append(port).append(',');
            if (openPortConfig.getProtocol() != null) {
                sb.append(openPortConfig.getProtocol());
            }
            sb.append(',');
            if (openPortConfig.getPermittedNetwork() != null) {
                sb.append(openPortConfig.getPermittedNetwork());
            }
            sb.append(',');
            if (openPortConfig.getPermittedInterfaceName() != null) {
                sb.append(openPortConfig.getPermittedInterfaceName());
            }
            sb.append(',');
            if (openPortConfig.getUnpermittedInterfaceName() != null) {
                sb.append(openPortConfig.getUnpermittedInterfaceName());
            }
            sb.append(',');
            if (openPortConfig.getPermittedMac() != null) {
                sb.append(openPortConfig.getPermittedMac());
            }
            sb.append(',');
            if (openPortConfig.getSourcePortRange() != null) {
                sb.append(openPortConfig.getSourcePortRange());
            }
            sb.append(",#;");
        });
        int ind = sb.lastIndexOf(";");
        if (ind > 0) {
            sb.deleteCharAt(ind);
        }
        return sb.toString();
    }

    private String formPortForwardConfigPropValue() {
        StringBuilder sb = new StringBuilder();
        this.portForwardConfigs.forEach(portForwardConfig -> {
            if (portForwardConfig.getInboundInterface() != null) {
                sb.append(portForwardConfig.getInboundInterface());
            }
            sb.append(',');
            if (portForwardConfig.getOutboundInterface() != null) {
                sb.append(portForwardConfig.getOutboundInterface());
            }
            sb.append(',');
            if (portForwardConfig.getIPAddress() != null) {
                sb.append(portForwardConfig.getIPAddress().getHostAddress());
            }
            sb.append(',');
            if (portForwardConfig.getProtocol() != null) {
                sb.append(portForwardConfig.getProtocol());
            }
            sb.append(',');
            sb.append(portForwardConfig.getInPort()).append(',');
            sb.append(portForwardConfig.getOutPort()).append(',');
            sb.append(portForwardConfig.isMasquerade()).append(',');
            if (portForwardConfig.getPermittedNetwork() != null) {
                sb.append(portForwardConfig.getPermittedNetwork());
            }
            sb.append(',');
            if (portForwardConfig.getPermittedMac() != null) {
                sb.append(portForwardConfig.getPermittedMac());
            }
            sb.append(',');
            if (portForwardConfig.getSourcePortRange() != null) {
                sb.append(portForwardConfig.getSourcePortRange());
            }
            sb.append(",#;");
        });
        int ind = sb.lastIndexOf(";");
        if (ind > 0) {
            sb.deleteCharAt(ind);
        }
        return sb.toString();
    }

    private String formNatConfigPropValue() {
        StringBuilder sb = new StringBuilder();
        for (FirewallNatConfig natConfig : this.natConfigs) {
            if (natConfig.getSourceInterface() != null) {
                sb.append(natConfig.getSourceInterface());
            }
            sb.append(',');
            if (natConfig.getDestinationInterface() != null) {
                sb.append(natConfig.getDestinationInterface());
            }
            sb.append(',');
            if (natConfig.getProtocol() != null) {
                sb.append(natConfig.getProtocol());
            }
            sb.append(',');
            if (natConfig.getSource() != null) {
                sb.append(natConfig.getSource());
            }
            sb.append(',');
            if (natConfig.getDestination() != null) {
                sb.append(natConfig.getDestination());
            }
            sb.append(',');
            sb.append(natConfig.isMasquerade()).append(",#;");
        }
        int ind = sb.lastIndexOf(";");
        if (ind > 0) {
            sb.deleteCharAt(ind);
        }
        return sb.toString();
    }
}

