/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.metrics;

import io.moquette.broker.NettyUtils;
import io.moquette.broker.Utils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@ChannelHandler.Sharable
public class MQTTMessageLogger
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTMessageLogger.class);

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object message) throws Exception {
        this.updateFishtags(ctx);
        this.logMQTTMessageRead(ctx, message);
        ctx.fireChannelRead(message);
        MDC.clear();
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.updateFishtags(ctx);
        ctx.fireChannelReadComplete();
        MDC.clear();
    }

    private void updateFishtags(ChannelHandlerContext ctx) {
        MDC.put("channel", ctx.channel().toString());
        String clientId = NettyUtils.clientID(ctx.channel());
        if (clientId != null && !clientId.isEmpty()) {
            MDC.put("client.id", "[" + clientId + "]");
        }
    }

    private void logMQTTMessageRead(ChannelHandlerContext ctx, Object message) throws Exception {
        this.logMQTTMessage(ctx, message, "C->B");
    }

    private void logMQTTMessageWrite(ChannelHandlerContext ctx, Object message) throws Exception {
        this.logMQTTMessage(ctx, message, "C<-B");
    }

    private void logMQTTMessage(ChannelHandlerContext ctx, Object message, String direction) throws Exception {
        if (!(message instanceof MqttMessage)) {
            return;
        }
        MqttMessage msg = NettyUtils.validateMessage(message);
        String clientID = NettyUtils.clientID(ctx.channel());
        MqttMessageType messageType = msg.fixedHeader().messageType();
        MDC.put("msg.type", "[" + messageType.name() + "]");
        switch (messageType) {
            case CONNACK: 
            case PINGREQ: 
            case PINGRESP: {
                LOG.debug("{} {} <{}>", new Object[]{direction, messageType, clientID});
                break;
            }
            case CONNECT: 
            case DISCONNECT: {
                LOG.info("{} {} <{}>", new Object[]{direction, messageType, clientID});
                break;
            }
            case SUBSCRIBE: {
                MqttSubscribeMessage subscribe = (MqttSubscribeMessage)msg;
                LOG.info("{} SUBSCRIBE <{}> to topics {}", direction, clientID, subscribe.payload().topicSubscriptions());
                break;
            }
            case UNSUBSCRIBE: {
                MqttUnsubscribeMessage unsubscribe = (MqttUnsubscribeMessage)msg;
                LOG.info("{} UNSUBSCRIBE <{}> to topics <{}>", direction, clientID, unsubscribe.payload().topics());
                break;
            }
            case PUBLISH: {
                MqttPublishMessage publish = (MqttPublishMessage)msg;
                LOG.debug("{} PUBLISH <{}> to topics <{}>", direction, clientID, publish.variableHeader().topicName());
                break;
            }
            case PUBREC: 
            case PUBCOMP: 
            case PUBREL: 
            case PUBACK: 
            case UNSUBACK: {
                LOG.info("{} {} <{}> packetID <{}>", new Object[]{direction, messageType, clientID, Utils.messageId(msg)});
                break;
            }
            case SUBACK: {
                MqttSubAckMessage suback = (MqttSubAckMessage)msg;
                List<Integer> grantedQoSLevels = suback.payload().grantedQoSLevels();
                LOG.info("{} SUBACK <{}> packetID <{}>, grantedQoses {}", direction, clientID, Utils.messageId(msg), grantedQoSLevels);
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.updateFishtags(ctx);
        LOG.info("Channel Inactive");
        ctx.fireChannelInactive();
        MDC.clear();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.updateFishtags(ctx);
        this.logMQTTMessageWrite(ctx, msg);
        ctx.write(msg, promise).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        MDC.clear();
    }
}

