/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import org.eclipse.equinox.metatype.EquinoxObjectClassDefinition;
import org.eclipse.equinox.metatype.impl.DataParser;
import org.eclipse.equinox.metatype.impl.Designate;
import org.eclipse.equinox.metatype.impl.MetaTypeMsg;
import org.eclipse.equinox.metatype.impl.ObjectClassDefinitionImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.MetaTypeProvider;

public class MetaTypeProviderImpl
implements MetaTypeProvider {
    public static final String METADATA_NOT_FOUND = "METADATA_NOT_FOUND";
    public static final String OCD_ID_NOT_FOUND = "OCD_ID_NOT_FOUND";
    public static final String ASK_INVALID_LOCALE = "ASK_INVALID_LOCALE";
    public static final String META_FILE_EXT = ".XML";
    public static final String RESOURCE_FILE_CONN = "_";
    public static final String RESOURCE_FILE_EXT = ".properties";
    public static final char DIRECTORY_SEP = '/';
    Bundle _bundle;
    Hashtable<String, ObjectClassDefinitionImpl> _allPidOCDs = new Hashtable(7);
    Hashtable<String, ObjectClassDefinitionImpl> _allFPidOCDs = new Hashtable(7);
    String[] _locales;
    boolean _isThereMeta = false;
    protected final LogService logger;

    MetaTypeProviderImpl(Bundle bundle, SAXParser parser, LogService logger) {
        this._bundle = bundle;
        this.logger = logger;
        this._isThereMeta = this.readMetaFiles(bundle, parser);
        if (!this._isThereMeta) {
            logger.log(4, NLS.bind((String)MetaTypeMsg.METADATA_NOT_FOUND, (Object)bundle.getSymbolicName(), (Object)bundle.getBundleId()));
        }
    }

    private boolean readMetaFiles(Bundle bundle, SAXParser saxParser) {
        Enumeration entries = bundle.findEntries("OSGI-INF/metatype", "*", false);
        if (entries == null) {
            return false;
        }
        boolean result = false;
        for (URL entry : Collections.list(entries)) {
            if (entry.getPath().endsWith("/")) continue;
            DataParser parser = new DataParser(bundle, entry, saxParser, this.logger);
            try {
                Collection<Designate> designates = parser.doParse();
                if (!designates.isEmpty()) {
                    result = true;
                }
                for (Designate designate : designates) {
                    if (designate.isFactory()) {
                        this._allFPidOCDs.put(designate.getFactoryPid(), designate.getObjectClassDefinition());
                        continue;
                    }
                    this._allPidOCDs.put(designate.getPid(), designate.getObjectClassDefinition());
                }
            }
            catch (Exception e) {
                this.logger.log(1, NLS.bind((String)MetaTypeMsg.METADATA_FILE_PARSE_ERROR, (Object[])new Object[]{entry, bundle.getBundleId(), bundle.getSymbolicName()}), (Throwable)e);
            }
        }
        return result;
    }

    public EquinoxObjectClassDefinition getObjectClassDefinition(String pid, String locale) {
        if (this.isInvalidLocale(locale)) {
            throw new IllegalArgumentException(NLS.bind((String)MetaTypeMsg.ASK_INVALID_LOCALE, (Object)pid, (Object)locale));
        }
        if (this._allPidOCDs.containsKey(pid)) {
            ObjectClassDefinitionImpl ocd = (ObjectClassDefinitionImpl)this._allPidOCDs.get(pid).clone();
            ocd.setResourceBundle(locale, this._bundle);
            return ocd;
        }
        if (this._allFPidOCDs.containsKey(pid)) {
            ObjectClassDefinitionImpl ocd = (ObjectClassDefinitionImpl)this._allFPidOCDs.get(pid).clone();
            ocd.setResourceBundle(locale, this._bundle);
            return ocd;
        }
        throw new IllegalArgumentException(NLS.bind((String)MetaTypeMsg.OCD_PID_NOT_FOUND, (Object)pid));
    }

    public boolean isInvalidLocale(String locale) {
        if (locale == null || locale.length() == 0) {
            return false;
        }
        int idx_first = locale.indexOf(95);
        int idx_second = locale.lastIndexOf(95);
        if (idx_first == -1 && locale.length() == 2) {
            return false;
        }
        return idx_first != 2 || idx_second != 5 && idx_second != 2;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized String[] getLocales() {
        if (this._locales != null) {
            return this.checkForDefault(this._locales);
        }
        localizationFiles = new Vector<String>(7);
        ocds = this._allPidOCDs.elements();
        while (ocds.hasMoreElements()) {
            ocd = ocds.nextElement();
            localization = ocd.getLocalization();
            if (localization == null || localizationFiles.contains(localization)) continue;
            localizationFiles.add(localization);
        }
        ocds = this._allFPidOCDs.elements();
        while (ocds.hasMoreElements()) {
            ocd = ocds.nextElement();
            localization = ocd.getLocalization();
            if (localization == null || localizationFiles.contains(localization)) continue;
            localizationFiles.add(localization);
        }
        if (localizationFiles.size() == 0) {
            localizationFiles.add(MetaTypeProviderImpl.getBundleLocalization(this._bundle));
        }
        locales = new Vector<String>(7);
        eLocalizationFiles = localizationFiles.elements();
        while (eLocalizationFiles.hasMoreElements()) {
            localizationFile = (String)eLocalizationFiles.nextElement();
            iSlash = localizationFile.lastIndexOf(47);
            baseDir = iSlash < 0 ? "" : localizationFile.substring(0, iSlash);
            baseFileName = String.valueOf('/') + localizationFile + "_";
            entries = this._bundle.findEntries(baseDir, "*.properties", false);
            if (entries != null) ** GOTO lbl37
            continue;
lbl-1000:
            // 1 sources

            {
                resource = ((URL)entries.nextElement()).getPath();
                if (!resource.startsWith(baseFileName) || !resource.toLowerCase().endsWith(".properties")) continue;
                locales.add(resource.substring(baseFileName.length(), resource.length() - ".properties".length()));
lbl37:
                // 3 sources

                ** while (entries.hasMoreElements())
            }
lbl38:
            // 1 sources

        }
        this._locales = locales.toArray(new String[locales.size()]);
        return this.checkForDefault(this._locales);
    }

    static String getBundleLocalization(Bundle bundle) {
        String baseName = (String)bundle.getHeaders("").get("Bundle-Localization");
        if (baseName == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        return baseName;
    }

    private String[] checkForDefault(String[] locales) {
        if (locales == null || locales.length == 0 || locales.length == 1 && Locale.getDefault().toString().equals(locales[0])) {
            return null;
        }
        return locales;
    }
}

