/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.eddystone;

import java.util.Arrays;
import org.eclipse.kura.ble.eddystone.BluetoothLeEddystone;
import org.eclipse.kura.ble.eddystone.BluetoothLeEddystoneDecoder;
import org.eclipse.kura.internal.ble.eddystone.EddystoneFrameType;
import org.eclipse.kura.internal.ble.eddystone.EddystoneURLEncoding;
import org.eclipse.kura.internal.ble.eddystone.EddystoneURLScheme;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothLeEddystoneDecoderImpl
implements BluetoothLeEddystoneDecoder {
    private static final Logger logger = LoggerFactory.getLogger(BluetoothLeEddystoneDecoderImpl.class);
    private static final byte UUID_LIST = 3;
    private static final byte[] EDDYSTONE_UUID = new byte[]{-2, -86};

    protected void activate(ComponentContext context) {
        logger.info("Activating Bluetooth Le Eddystone Codec...");
    }

    protected void deactivate(ComponentContext context) {
        logger.debug("Deactivating Bluetooth Le Eddystone Codec...");
    }

    public Class<BluetoothLeEddystone> getBeaconType() {
        return BluetoothLeEddystone.class;
    }

    public BluetoothLeEddystone decode(byte[] reportData) {
        return BluetoothLeEddystoneDecoderImpl.parseEIRData(reportData);
    }

    private static BluetoothLeEddystone parseEIRData(byte[] b) {
        int ptr = 0;
        while (ptr < b.length) {
            byte structSize = b[ptr];
            if (structSize == 0) break;
            if (b[ptr + 1] == 3 && b[ptr + 2] == EDDYSTONE_UUID[1] && b[ptr + 3] == EDDYSTONE_UUID[0]) {
                BluetoothLeEddystone eddystone = new BluetoothLeEddystone();
                byte txPower = b[ptr + 9];
                EddystoneFrameType frameType = EddystoneFrameType.valueOf(b[ptr + 8]);
                if (frameType.equals((Object)EddystoneFrameType.UID)) {
                    byte[] namespace = Arrays.copyOfRange(b, ptr + 10, ptr + 20);
                    byte[] instance = Arrays.copyOfRange(b, ptr + 20, ptr + 26);
                    eddystone.configureEddystoneUIDFrame(namespace, instance, txPower);
                } else if (frameType.equals((Object)EddystoneFrameType.URL)) {
                    byte[] urlHex = Arrays.copyOfRange(b, ptr + 11, b.length);
                    eddystone.configureEddystoneURLFrame(String.valueOf(EddystoneURLScheme.decodeURLScheme(b[ptr + 10])) + EddystoneURLEncoding.decodeURL(urlHex), txPower);
                }
                return eddystone;
            }
            ptr += structSize + 1;
        }
        return null;
    }
}

