/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.sharedclients;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import java.net.URL;
import javax.xml.namespace.QName;

public class StubContext {
    public static final String TEST_NAME = "testName";
    public static final String WEB_SERVER_HOST = "webServerHost";
    public static final String WEB_SERVER_PORT = "webServerPort";
    public static final String SECURE_WEB_SERVER_PORT = "secureWebServerPort";
    public static final String MONITOR_PORT = "monitorPort";
    public static final String WSI_HOME = "wsiHome";
    private int mode;
    private String endpointURL;
    private String wsdllocURL;
    private String namespace;
    private String service;
    private String port;
    private Class endpointInterface;
    private QName serviceName;
    private QName portName;
    private Object stub;
    private Service webServiceRef;
    private WebServiceFeature[] wsf;

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String endpointURL) {
        this.endpointURL = endpointURL;
    }

    public String getWsdllocURL() {
        return this.wsdllocURL;
    }

    public void setWsdllocURL(String wsdllocURL) {
        this.wsdllocURL = wsdllocURL;
    }

    public WebServiceFeature[] getWSF() {
        return this.wsf;
    }

    public void setWSF(WebServiceFeature[] w) {
        this.wsf = w;
    }

    protected void initStub() throws Exception {
        if (this.stub == null) {
            if (this.mode == 0) {
                this.createJAXWSStub();
                JAXWS_Util.setTargetEndpointAddress(this.stub, this.getEndpointURL());
            } else {
                this.createJavaEEStub();
            }
        }
    }

    protected void createJAXWSStub() throws Exception {
        TestUtil.logMsg((String)"entering createJAXWSStub()");
        try {
            this.serviceName = new QName(this.namespace, this.service);
            this.portName = new QName(this.namespace, this.port);
            Class<?> siClass = Class.forName(this.endpointInterface.getPackage().getName() + "." + this.service);
            this.stub = JAXWS_Util.getPort(new URL(this.getWsdllocURL()), this.serviceName, siClass, this.portName, this.endpointInterface, this.wsf);
            JAXWS_Util.setSOAPLogging(this.stub);
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"StubContext.createJAXWSStub() could not get stub (caught exception)");
            TestUtil.printStackTrace((Throwable)e);
            throw e;
        }
    }

    protected void createJavaEEStub() throws Exception {
        TestUtil.logMsg((String)"entering createJavaEEStub()");
        try {
            TestUtil.logMsg((String)("webServiceRef=" + this.webServiceRef));
            if (this.webServiceRef == null) {
                throw new Exception("webServiceRef is null");
            }
            TestUtil.logMsg((String)("Getting port from WebServiceRef for " + this.endpointInterface.getName()));
            this.stub = this.webServiceRef.getPort(this.endpointInterface);
            TestUtil.logMsg((String)("port=" + this.stub));
            JAXWS_Util.dumpTargetEndpointAddress(this.stub);
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"StubContext.createJavaEEStub() could not get stub (caught exception)");
            TestUtil.printStackTrace((Throwable)e);
            throw e;
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public QName getPortName() {
        return this.portName;
    }

    public String getPort() {
        return this.port;
    }

    public String getService() {
        return this.service;
    }

    public Class getEndpointInterface() {
        return this.endpointInterface;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public Object getStub() throws Exception {
        this.initStub();
        return this.stub;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPortName(QName portName) {
        this.portName = portName;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setEndpointInterface(Class endpointInterface) {
        this.endpointInterface = endpointInterface;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public void setWebServiceRef(Service webServiceRef) {
        this.webServiceRef = webServiceRef;
    }
}

