/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.timer.entity.bmp;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.RemoveException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DAOBean
implements EntityBean {
    protected EntityContext ectx = null;
    protected TSNamingContext nctx = null;
    protected static final String DATASOURCE = "java:comp/env/jdbc/DBTimer";
    protected transient Connection dbConnection = null;
    protected String dsname = null;
    protected DataSource ds = null;
    protected int cofID = 0;
    protected String cofName = null;
    protected float cofPrice = 0.0f;

    public Integer ejbCreate(Properties p, int coffeeID, String coffeName, float coffeePrice, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            this.tableInit();
            this.createNewRow(coffeeID, coffeName, coffeePrice);
        }
        catch (RemoteLoggingInitException e) {
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            throw new CreateException("Unexpected Exception occurred in ejbCreate: " + e);
        }
        return new Integer(coffeeID);
    }

    public void ejbPostCreate(Properties p, int coffeeID, String coffeName, float coffeePrice, int flag) {
    }

    public Integer ejbCreate(Properties p, int coffeeID, String coffeName, float coffeePrice) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            this.tableInit();
            this.createNewRow(coffeeID, coffeName, coffeePrice);
        }
        catch (RemoteLoggingInitException e) {
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            throw new CreateException("Unexpected Exception occurred in ejbCreate: " + e);
        }
        return new Integer(coffeeID);
    }

    public void ejbPostCreate(Properties p, int coffeeID, String coffeName, float coffeePrice) {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Lookup DataSource from JNDI : java:comp/env/jdbc/DBTimer");
            this.dsname = DATASOURCE;
            this.ds = (DataSource)this.nctx.lookup(this.dsname);
            TestUtil.logMsg((String)("dsname=" + this.dsname + "ds=" + this.ds));
        }
        catch (NamingException e) {
            TestUtil.logErr((String)"Unexpected NamingException ... ");
            throw new EJBException("Unable to obtain naming context:" + e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception ... ");
            throw new EJBException("Unexpected Exception occurred in setEntityContext" + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public Integer ejbFindTheBean(Integer key) throws FinderException {
        return new Integer(key);
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        try {
            TestUtil.logMsg((String)"Check if Primary Key Exists");
            boolean foundKey = this.keyExists(key);
            if (foundKey) {
                return key;
            }
            throw new FinderException("Key not found: " + key);
        }
        catch (Exception e) {
            throw new FinderException("Exception occurred: " + e);
        }
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        TestUtil.logMsg((String)("PrimaryKey=" + this.ectx.getPrimaryKey()));
        try {
            this.removeRow((Integer)this.ectx.getPrimaryKey());
        }
        catch (Exception e) {
            throw new RemoveException("Unexpected Exception occurred in ejbRemove");
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    private void getDBConnection() throws SQLException {
        TestUtil.logTrace((String)"getDBConnection");
        if (this.dbConnection != null) {
            try {
                this.closeDBConnection();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception occurred trying to close DB Connection", (Throwable)e);
            }
        }
        this.dbConnection = this.ds.getConnection();
    }

    private void closeDBConnection() throws SQLException {
        TestUtil.logTrace((String)"closeDBConnection");
        if (this.dbConnection != null) {
            this.dbConnection.close();
            this.dbConnection = null;
        }
    }

    private void tableInit() throws SQLException {
        Statement stmt = null;
        TestUtil.logTrace((String)"tableInit");
        this.getDBConnection();
        try {
            stmt = this.dbConnection.createStatement();
            String sqlStr = TestUtil.getProperty((String)"BB_Tab_Delete");
            stmt.executeUpdate(sqlStr);
            TestUtil.logMsg((String)("Deleted all rows from table " + TestUtil.getTableName((String)sqlStr)));
        }
        catch (SQLException s) {
            throw new SQLException("SQL Exception in tableInit:" + s.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)"SQLException occurred closing DB Connection", (Throwable)e);
            }
        }
    }

    private void createNewRow(int cofID, String cofName, float cofPrice) throws CreateException, SQLException {
        Statement pStmt = null;
        TestUtil.logTrace((String)"createNewRow");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Insert1");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setInt(1, cofID);
            pStmt.setString(2, cofName);
            pStmt.setFloat(3, cofPrice);
            if (pStmt.executeUpdate() != 1) {
                throw new CreateException("SQL INSERT failed in createNewRow");
            }
            this.cofID = cofID;
            this.cofName = cofName;
            this.cofPrice = cofPrice;
        }
        catch (SQLException e) {
            throw new SQLException("SQL Exception in createNewRow" + e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)"SQLException occurred in createNewRow", (Throwable)e);
            }
        }
    }

    private boolean keyExists(int pkey) throws SQLException {
        Statement pStmt = null;
        ResultSet result = null;
        TestUtil.logTrace((String)"keyExists");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Select1");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setInt(1, pkey);
            result = pStmt.executeQuery();
            if (!result.next()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new SQLException("Caught SQL Exception in keyExists" + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)"SQLException occurred in keyExists", (Throwable)e);
            }
        }
    }

    private void removeRow(int pkey) throws SQLException {
        Statement pStmt = null;
        TestUtil.logTrace((String)"removeRow");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Delete1");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setInt(1, pkey);
            if (pStmt.executeUpdate() != 1) {
                throw new SQLException("SQL DELETE failed in removeRow");
            }
        }
        catch (SQLException e) {
            throw new SQLException("SQL Exception in removeRow:" + e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.logErr((String)"SQLException occurred in removeRow", (Throwable)e);
            }
        }
    }
}

