/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.sec.annotations.ejb.basicauth;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices12.sec.annotations.ejb.basicauth.Hello;
import com.sun.ts.tests.webservices12.sec.annotations.ejb.basicauth.HelloService;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.WebServiceRef;
import java.util.Map;
import java.util.Properties;

public class Client
extends EETest {
    @WebServiceRef
    static HelloService service;
    private Hello port;
    private Properties props = null;
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private static final String UNAUTH_USERNAME = "authuser";
    private static final String UNAUTH_PASSWORD = "authpassword";
    private String username = "";
    private String password = "";
    private String unauthorizedUser = "";
    private String unauthorizedUserPassword = "";
    private TSURL ctsurl = new TSURL();
    private String hostname = "localhost";
    private String PROTOCOL = "http";
    private String urlString = null;
    private int portnum = 8000;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.username = this.props.getProperty(UserNameProp);
            this.password = this.props.getProperty(UserPasswordProp);
            this.unauthorizedUser = this.props.getProperty(UNAUTH_USERNAME);
            this.unauthorizedUserPassword = this.props.getProperty(UNAUTH_PASSWORD);
            this.hostname = this.props.getProperty("webServerHost");
            this.portnum = Integer.parseInt(this.props.getProperty("webServerPort"));
            this.urlString = this.ctsurl.getURLString(this.PROTOCOL, this.hostname, this.portnum, "/WSEjbBasicAuth/HelloService/Hello");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
        TestUtil.logMsg((String)"setup ok");
    }

    public void sayHelloProtected() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)("Getting port from the Service : " + service));
            Hello port = service.getHelloPort();
            TestUtil.logMsg((String)"Setting username and password in WS port");
            TestUtil.logMsg((String)("username=" + this.username + " password=" + this.password));
            BindingProvider bindingProvider = (BindingProvider)port;
            Map map = bindingProvider.getRequestContext();
            map.put("jakarta.xml.ws.security.auth.username", this.username);
            map.put("jakarta.xml.ws.security.auth.password", this.password);
            TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
            map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
            TestUtil.logMsg((String)"Invoking sayHelloProtected with authorized user on Hello port");
            TestUtil.logMsg((String)"Invocation must be allowed");
            String text = port.sayHelloProtected("Raja");
            TestUtil.logMsg((String)"Test sayHelloProtected passed");
            TestUtil.logMsg((String)("Got Output : " + text));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EETest.Fault("Test sayHelloProtected failed");
        }
    }

    public void sayHelloPermitAll() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)("Getting port from the Service : " + service));
            Hello port = service.getHelloPort();
            TestUtil.logMsg((String)"Setting username and password in WS port");
            TestUtil.logMsg((String)("username=" + this.username + " password=" + this.password));
            BindingProvider bindingProvider = (BindingProvider)port;
            Map map = bindingProvider.getRequestContext();
            map.put("jakarta.xml.ws.security.auth.username", this.username);
            map.put("jakarta.xml.ws.security.auth.password", this.password);
            TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
            map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
            TestUtil.logMsg((String)"Invoking sayHelloPermitAll with any user on Hello port");
            TestUtil.logMsg((String)"Invocation must be allowed");
            String text = port.sayHelloPermitAll("Raja");
            TestUtil.logMsg((String)"Test sayHelloPermitAll passed");
            TestUtil.logMsg((String)("Got Output : " + text));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EETest.Fault("Test sayHelloPermitAll failed");
        }
    }

    public void sayHelloDenyAll() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)("Getting port from the Service : " + service));
            Hello port = service.getHelloPort();
            TestUtil.logMsg((String)"Setting username and password in WS port");
            TestUtil.logMsg((String)("username=" + this.username + " password=" + this.password));
            BindingProvider bindingProvider = (BindingProvider)port;
            Map map = bindingProvider.getRequestContext();
            map.put("jakarta.xml.ws.security.auth.username", this.username);
            map.put("jakarta.xml.ws.security.auth.password", this.password);
            TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
            map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
            TestUtil.logMsg((String)"Invoking sayHelloDenyAll with any user on Hello port");
            TestUtil.logMsg((String)"Invocation must not be allowed (throw exception)");
            port.sayHelloDenyAll("Raja");
            TestUtil.logErr((String)"Test sayHelloDenyAll did not throw expected exception");
            throw new EETest.Fault("Test sayHelloDenyAll failed");
        }
        catch (WebServiceException e) {
            TestUtil.logMsg((String)"Got expected WebServiceException");
            TestUtil.logMsg((String)"Test sayHelloDenyAll Passed");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected Exception " + e.getMessage()));
            throw new EETest.Fault("Test sayHelloDenyAll failed", e);
        }
    }

    public void sayHelloProtectedUnauthorizedUser() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)("Getting port from the Service : " + service));
            Hello port = service.getHelloPort();
            TestUtil.logMsg((String)"Setting username and password in WS port");
            TestUtil.logMsg((String)("username=" + this.unauthorizedUser + " password=" + this.unauthorizedUserPassword));
            BindingProvider bindingProvider = (BindingProvider)port;
            Map map = bindingProvider.getRequestContext();
            map.put("jakarta.xml.ws.security.auth.username", this.unauthorizedUser);
            map.put("jakarta.xml.ws.security.auth.password", this.unauthorizedUserPassword);
            TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
            map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
            TestUtil.logMsg((String)"Invoking sayHelloProtected with unauthorized user on Hello port");
            TestUtil.logMsg((String)"Invocation must not be allowed (throw exception)");
            port.sayHelloProtected("Raja");
            TestUtil.logErr((String)"Test sayHelloProtectedUnauthorizedUser did not throw expected exception");
            throw new EETest.Fault("Test sayHelloProtectedUnauthorizedUser failed");
        }
        catch (WebServiceException e) {
            TestUtil.logMsg((String)"Got expected WebServiceException");
            TestUtil.logMsg((String)"Test sayHelloDenyAll Passed");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected Exception " + e.getMessage()));
            throw new EETest.Fault("Test sayHelloDenyAll failed", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

