/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.testlogic.ejb.bb.argsemantics;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.ejb.calleebeans.CMP20Callee;
import com.sun.ts.tests.common.ejb.calleebeans.CMP20CalleeHome;
import com.sun.ts.tests.common.ejb.calleebeans.CMP20CalleeLocal;
import com.sun.ts.tests.common.ejb.calleebeans.CMP20CalleeLocalHome;
import com.sun.ts.tests.common.ejb.calleebeans.SimpleArgument;
import com.sun.ts.tests.common.ejb.calleebeans.StatefulCallee;
import com.sun.ts.tests.common.ejb.calleebeans.StatefulCalleeHome;
import com.sun.ts.tests.common.ejb.calleebeans.StatefulCalleeLocal;
import com.sun.ts.tests.common.ejb.calleebeans.StatefulCalleeLocalHome;
import java.util.Properties;

public class TestLogic {
    public static final String prefix = "java:comp/env/";
    public static final String statefulRemoteLookup = "java:comp/env/ejb/StatefulCalleeRemote";
    public static final String statefulLocalLookup = "java:comp/env/ejb/StatefulCalleeLocal";
    public static final String statefulBiRemoteLookup = "java:comp/env/ejb/StatefulCalleeBothRemote";
    public static final String statefulBiLocalLookup = "java:comp/env/ejb/StatefulCalleeBothLocal";
    public static final String cmp20RemoteLookup = "java:comp/env/ejb/CMP20CalleeRemote";
    public static final String cmp20LocalLookup = "java:comp/env/ejb/CMP20CalleeLocal";
    public static final String cmp20BiRemoteLookup = "java:comp/env/ejb/CMP20CalleeBothRemote";
    public static final String cmp20BiLocalLookup = "java:comp/env/ejb/CMP20CalleeBothLocal";
    public static final int initialValue = 12;
    public static final int modifiedValue = 24;
    public static final int modifiedValue2 = 48;
    private static StatefulCallee ssfCalleeBean = null;
    private static StatefulCalleeLocal ssfCalleeLocalBean = null;

    public static boolean testStatefulRemote(TSNamingContext nctx, Properties props) {
        return TestLogic.testStatefulRemote(statefulRemoteLookup, nctx, props);
    }

    public static boolean testStatefulLocal(TSNamingContext nctx, Properties props) {
        return TestLogic.testStatefulLocal(statefulLocalLookup, nctx, props);
    }

    public static boolean testStatefulBoth(TSNamingContext nctx, Properties props) {
        boolean pass = TestLogic.testStatefulRemote(statefulBiRemoteLookup, nctx, props);
        return pass &= TestLogic.testStatefulLocal(statefulBiLocalLookup, nctx, props);
    }

    public static boolean testCMP20Remote(TSNamingContext nctx, Properties props) {
        return TestLogic.testCMP20Remote(cmp20RemoteLookup, nctx, props);
    }

    public static boolean testCMP20Local(TSNamingContext nctx, Properties props) {
        return TestLogic.testCMP20Local(cmp20LocalLookup, nctx, props);
    }

    public static boolean testCMP20Both(TSNamingContext nctx, Properties props) {
        boolean pass = TestLogic.testCMP20Remote(cmp20BiRemoteLookup, nctx, props);
        return pass &= TestLogic.testCMP20Local(cmp20BiLocalLookup, nctx, props);
    }

    protected static boolean testStatefulRemote(String lookupName, TSNamingContext nctx, Properties props) {
        boolean pass;
        ssfCalleeBean = null;
        try {
            SimpleArgument arg = new SimpleArgument(12);
            TestUtil.logTrace((String)("[TestLogic] Initial value is " + arg.getValue()));
            TestUtil.logTrace((String)("[TestLogic] Looking up Callee " + lookupName + " ..."));
            StatefulCalleeHome home = (StatefulCalleeHome)nctx.lookup(lookupName, StatefulCalleeHome.class);
            ssfCalleeBean = home.create(props, arg);
            TestUtil.logTrace((String)("[TestLogic] Value after create is " + arg.getValue()));
            ssfCalleeBean.call(props, arg);
            TestUtil.logTrace((String)("[TestLogic] Value after business method is " + arg.getValue()));
            boolean bl = pass = arg.getValue() == 12;
            if (!pass) {
                TestUtil.logErr((String)("[TestLogic] Argument has been modified to " + arg.getValue()));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"[TestLogic] Unexpected exception", (Throwable)e);
        }
        return pass;
    }

    protected static boolean testStatefulLocal(String lookupName, TSNamingContext nctx, Properties props) {
        boolean pass;
        ssfCalleeLocalBean = null;
        try {
            SimpleArgument arg = new SimpleArgument(12);
            TestUtil.logTrace((String)("[TestLogic] Initial value is " + arg.getValue()));
            TestUtil.logTrace((String)("[TestLogic] Looking up Callee " + lookupName + " ..."));
            StatefulCalleeLocalHome home = (StatefulCalleeLocalHome)nctx.lookup(lookupName);
            ssfCalleeLocalBean = home.create(props, arg);
            TestUtil.logTrace((String)("[TestLogic] Value after create is " + arg.getValue()));
            boolean bl = pass = arg.getValue() == 24;
            if (!pass) {
                String msg = "Expected Argument to be set to 24";
                TestUtil.logErr((String)("[TestLogic] " + msg));
                throw new Exception(msg);
            }
            ssfCalleeLocalBean.call(props, arg);
            TestUtil.logTrace((String)("[TestLogic] Value after business method is " + arg.getValue()));
            boolean bl2 = pass = arg.getValue() == 48;
            if (!pass) {
                TestUtil.logErr((String)"[TestLogic] Expected argument to be set to 48");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"[TestLogic] Unexpected exception", (Throwable)e);
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean testCMP20Remote(String lookupName, TSNamingContext nctx, Properties props) {
        boolean pass;
        CMP20Callee bean = null;
        try {
            SimpleArgument arg = new SimpleArgument(12);
            TestUtil.logTrace((String)("[TestLogic] Initial value is " + arg.getValue()));
            TestUtil.logTrace((String)("[TestLogic] Looking up Callee " + lookupName + " ..."));
            CMP20CalleeHome home = (CMP20CalleeHome)nctx.lookup(lookupName, CMP20CalleeHome.class);
            bean = home.create(props, 10, "arabica", 15.5f, arg);
            TestUtil.logTrace((String)("[TestLogic] Value after create is " + arg.getValue()));
            bean.call(props, arg);
            TestUtil.logTrace((String)("[TestLogic] Value after business method is " + arg.getValue()));
            boolean bl = pass = arg.getValue() == 12;
            if (!pass) {
                TestUtil.logErr((String)("[TestLogic] Argument has been modified to " + arg.getValue()));
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"[TestLogic] Unexpected exception", (Throwable)e);
        }
        finally {
            try {
                if (null != bean) {
                    bean.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("[TestLogic] Ignoring exception on bean removal: " + e));
            }
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean testCMP20Local(String lookupName, TSNamingContext nctx, Properties props) {
        boolean pass;
        CMP20CalleeLocal bean = null;
        try {
            SimpleArgument arg = new SimpleArgument(12);
            TestUtil.logTrace((String)("[TestLogic] Initial value is " + arg.getValue()));
            TestUtil.logTrace((String)("[TestLogic] Looking up Callee " + lookupName + " ..."));
            CMP20CalleeLocalHome home = (CMP20CalleeLocalHome)nctx.lookup(lookupName);
            bean = home.create(props, 11, "arabica", 16.5f, arg);
            TestUtil.logTrace((String)("[TestLogic] Value after create is " + arg.getValue()));
            boolean bl = pass = arg.getValue() == 24;
            if (!pass) {
                String msg = "Expected Argument to be set to 24";
                TestUtil.logErr((String)("[TestLogic] " + msg));
                throw new Exception(msg);
            }
            bean.call(props, arg);
            TestUtil.logTrace((String)("[TestLogic] Value after business method is " + arg.getValue()));
            boolean bl2 = pass = arg.getValue() == 48;
            if (!pass) {
                TestUtil.logErr((String)"[TestLogic] Expected argument to be set to 48");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"[TestLogic] Unexpected exception", (Throwable)e);
        }
        finally {
            try {
                if (null != bean) {
                    bean.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("[TestLogic] Ignoring exception on bean removal: " + e));
            }
        }
        return pass;
    }

    public static void cleanUpStatefulBean() {
        TestUtil.logTrace((String)"cleanUpStatefulBean");
        try {
            if (ssfCalleeBean != null) {
                TestUtil.logTrace((String)"cleanUp Session Stateful Remote Callee Bean");
                ssfCalleeBean.remove();
                ssfCalleeBean = null;
            }
            if (ssfCalleeLocalBean != null) {
                TestUtil.logTrace((String)"cleanUp Session Stateful Local Callee Bean");
                ssfCalleeLocalBean.remove();
                ssfCalleeLocalBean = null;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught trying to remove Stateful Session beans", (Throwable)e);
        }
    }
}

