/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.entity.cmp11.ejbref.single;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.ejb.ee.deploy.entity.cmp11.ejbref.single.TestBean;
import com.sun.ts.tests.ejb.ee.deploy.entity.cmp11.ejbref.single.TestBeanHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private static final int beanPK = 1;
    private TestBeanHome home = null;
    private Properties props = null;
    private TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            this.props = props;
            this.logTrace("[Client] Getting Naming Context...");
            this.nctx = new TSNamingContext();
            this.logTrace("[Client] Initializing BMP table...");
            DAOFactory.getInstance().getCoffeeDAO().cleanup();
            this.logTrace("[Client] Looking up the Home...");
            this.home = (TestBeanHome)this.nctx.lookup(testLookup, TestBeanHome.class);
            this.logTrace("[Client] Looked up Home!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void testStatelessInternal() throws EETest.Fault {
        TestBean bean = null;
        try {
            this.logTrace("[Client] Creating TestBean...");
            bean = this.home.create(this.props, 1, "coffee-1", 10.0f);
            this.logTrace("[Client] Checking Stateless internal references...");
            boolean pass = bean.testStatelessInternal(this.props);
            if (!pass) {
                throw new EETest.Fault("Stateless internal EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: ", e);
            throw new EETest.Fault("Stateless internal EJB ref test failed!" + e, e);
        }
        finally {
            if (null != bean) {
                try {
                    bean.remove();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"[Client] Ignoring exception on bean removal!", (Throwable)e);
                }
            }
        }
    }

    public void testStatelessExternal() throws EETest.Fault {
        TestBean bean = null;
        try {
            this.logTrace("[Client] Creating TestBean...");
            bean = this.home.create(this.props, 1, "coffee-1", 1.0f);
            this.logTrace("[Client] Checking Stateless external references...");
            boolean pass = bean.testStatelessExternal(this.props);
            if (!pass) {
                throw new EETest.Fault("Stateless external EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: ", e);
            throw new EETest.Fault("Stateless external EJB ref test failed!" + e, e);
        }
        finally {
            if (null != bean) {
                try {
                    bean.remove();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"[Client] Ignoring exception on bean removal!", (Throwable)e);
                }
            }
        }
    }

    public void testStatefulInternal() throws EETest.Fault {
        TestBean bean = null;
        try {
            this.logTrace("[Client] Creating TestBean...");
            bean = this.home.create(this.props, 1, "coffee-1", 10.0f);
            this.logTrace("[Client] Checking Stateful internal references...");
            boolean pass = bean.testStatefulInternal(this.props);
            if (!pass) {
                throw new EETest.Fault("Stateful internal EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: ", e);
            throw new EETest.Fault("Stateful internal EJB ref test failed!" + e, e);
        }
        finally {
            if (null != bean) {
                try {
                    bean.cleanUpBean();
                    bean.remove();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"[Client] Ignoring exception on bean removal!", (Throwable)e);
                }
            }
        }
    }

    public void testStatefulExternal() throws EETest.Fault {
        TestBean bean = null;
        try {
            this.logTrace("[Client] Creating TestBean...");
            bean = this.home.create(this.props, 1, "coffee-1", 10.0f);
            this.logTrace("[Client] Checking Stateful external references...");
            boolean pass = bean.testStatefulExternal(this.props);
            if (!pass) {
                throw new EETest.Fault("Stateful external EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: ", e);
            throw new EETest.Fault("Stateful external EJB ref test failed!" + e, e);
        }
        finally {
            if (null != bean) {
                try {
                    bean.cleanUpBean();
                    bean.remove();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"[Client] Ignoring exception on bean removal!", (Throwable)e);
                }
            }
        }
    }

    public void testBMPInternal() throws EETest.Fault {
        TestBean bean = null;
        try {
            this.logTrace("[Client] Creating TestBean...");
            bean = this.home.create(this.props, 1, "coffee-1", 10.0f);
            this.logTrace("[Client] Checking BMP internal references...");
            boolean pass = bean.testBMPInternal(this.props);
            if (!pass) {
                throw new EETest.Fault("BMP internal EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: ", e);
            throw new EETest.Fault("BMP internal EJB ref test failed!" + e, e);
        }
        finally {
            if (null != bean) {
                try {
                    bean.remove();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"[Client] Ignoring exception on bean removal!", (Throwable)e);
                }
            }
        }
    }

    public void testBMPExternal() throws EETest.Fault {
        TestBean bean = null;
        try {
            this.logTrace("[Client] Creating TestBean...");
            bean = this.home.create(this.props, 1, "coffee-1", 10.0f);
            this.logTrace("[Client] Checking BMP external references...");
            boolean pass = bean.testBMPExternal(this.props);
            if (!pass) {
                throw new EETest.Fault("BMP external EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: ", e);
            throw new EETest.Fault("BMP external EJB ref test failed!" + e, e);
        }
        finally {
            if (null != bean) {
                try {
                    bean.remove();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"[Client] Ignoring exception on bean removal!", (Throwable)e);
                }
            }
        }
    }

    public void testCMP11Internal() throws EETest.Fault {
        TestBean bean = null;
        boolean pass = false;
        try {
            this.logTrace("Client: Creating TestBean...");
            bean = this.home.create(this.props, 1, "coffee-1", 10.0f);
            this.logTrace("[Client] Checking CMP11 internal references...");
            pass = bean.testCMP11Internal(this.props);
            if (!pass) {
                throw new EETest.Fault("CMP11 internal EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: ", e);
            throw new EETest.Fault("CMP11 internal EJB ref test failed!" + e, e);
        }
        finally {
            if (null != bean) {
                try {
                    bean.remove();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"[Client] Ignoring exception on bean removal!", (Throwable)e);
                }
            }
        }
    }

    public void testCMP11External() throws EETest.Fault {
        TestBean bean = null;
        boolean pass = false;
        try {
            this.logTrace("[Client] Creating TestBean...");
            bean = this.home.create(this.props, 1, "coffee-1", 10.0f);
            this.logTrace("[Client] Checking CMP11 external references...");
            pass = bean.testCMP11External(this.props);
            if (!pass) {
                throw new EETest.Fault("CMP11 external EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: ", e);
            throw new EETest.Fault("CMP11 external EJB ref test failed!" + e, e);
        }
        finally {
            if (null != bean) {
                try {
                    bean.remove();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"[Client] Ignoring exception on bean removal!", (Throwable)e);
                }
            }
        }
    }

    public void testCMP20Internal() throws EETest.Fault {
        TestBean bean = null;
        boolean pass = false;
        try {
            this.logTrace("[Client] Creating TestBean...");
            bean = this.home.create(this.props, 1, "coffee-1", 10.0f);
            this.logTrace("[Client] Checking CMP 2.0 internal references...");
            pass = bean.testCMP20Internal(this.props);
            if (!pass) {
                throw new EETest.Fault("CMP2.0 internal EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: ", e);
            throw new EETest.Fault("CMP2.0 internal EJB ref test failed!" + e, e);
        }
        finally {
            if (null != bean) {
                try {
                    bean.remove();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"[Client] Ignoring exception on bean removal!", (Throwable)e);
                }
            }
        }
    }

    public void testCMP20External() throws EETest.Fault {
        TestBean bean = null;
        boolean pass = false;
        try {
            this.logTrace("[Client] Creating TestBean...");
            bean = this.home.create(this.props, 1, "coffee-1", 10.0f);
            this.logTrace("[Client] Checking CMP 2.0 external references...");
            pass = bean.testCMP20External(this.props);
            if (!pass) {
                throw new EETest.Fault("CMP2.0 external EJB ref test failed!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Caught exception: ", e);
            throw new EETest.Fault("CMP2.0 external EJB ref test failed!" + e, e);
        }
        finally {
            if (null != bean) {
                try {
                    bean.remove();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"[Client] Ignoring exception on bean removal!", (Throwable)e);
                }
            }
        }
    }

    public void cleanup() {
        this.logTrace("[Client] cleanup()");
    }
}

