/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.misc.getresource.common;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;

public class GetResourceTest {
    public static final String NON_EXISTING_RESOURCE = "nbmvzpoqacfkol91267bm.txt";

    public void getResourceWithClass(Class cls, String name, String expected) throws TestFailedException {
        GetResourceTest.verify(GetResourceTest.getResourceContent(cls, name), expected);
    }

    public void getResourceWithClassLoader(Class cls, String name, String expected) throws TestFailedException {
        URL url = GetResourceTest.getContextClassLoader(cls).getResource(name);
        if (url == null) {
            throw new TestFailedException("ClassLoader.getResource(" + name + ") returned a null URL.  The classloader is " + GetResourceTest.getContextClassLoader(cls));
        }
        String content = GetResourceTest.getResourceContent(url, name);
        GetResourceTest.verify(content, expected);
    }

    public void getResourceAsStreamWithClass(Class cls, String name, String expected) throws TestFailedException {
        InputStream is = cls.getResourceAsStream(name);
        if (is == null) {
            throw new TestFailedException("Class.getResourceAsStream(" + name + ") returned a null InputStream.  The class is " + cls);
        }
        String content = GetResourceTest.getResourceContent(is, name);
        GetResourceTest.verify(content, expected);
    }

    public void getResourceAsStreamWithClassLoader(Class cls, String name, String expected) throws TestFailedException {
        InputStream is = GetResourceTest.getContextClassLoader(cls).getResourceAsStream(name);
        if (is == null) {
            throw new TestFailedException("ClassLoader.getResourceAsStream(" + name + ") returned a null InputStream.  The classloader is " + GetResourceTest.getContextClassLoader(cls));
        }
        String content = GetResourceTest.getResourceContent(is, name);
        GetResourceTest.verify(content, expected);
    }

    public static String getResourceContent(Class cls, String name) throws TestFailedException {
        URL url = cls.getResource(name);
        if (url == null) {
            throw new TestFailedException("Class.getResource(" + name + ") returned a null URL.  The class is " + cls + ".  The classloader is " + GetResourceTest.getContextClassLoader(cls));
        }
        return GetResourceTest.getResourceContent(url, name);
    }

    public static String getResourceContent(URL url, String name) {
        try {
            return GetResourceTest.getResourceContent(url.openStream(), name);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static String getResourceContent(InputStream is, String name) {
        String result = null;
        InputStreamReader reader = new InputStreamReader(is);
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        int n = 0;
        try {
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
            result = ((Object)writer).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public void getResourceNullParam(Class cls) throws TestFailedException {
        try {
            cls.getResource(null);
            throw new TestFailedException("Expecting NullPointerException, but got none.");
        }
        catch (NullPointerException nullPointerException) {
            try {
                GetResourceTest.getContextClassLoader(cls).getResource(null);
                throw new TestFailedException("Expecting NullPointerException, but got none.");
            }
            catch (NullPointerException nullPointerException2) {
                return;
            }
        }
    }

    public void getResourceAsStreamNullParam(Class cls) throws TestFailedException {
        try {
            cls.getResourceAsStream(null);
            throw new TestFailedException("Expecting NullPointerException, but got none.");
        }
        catch (NullPointerException nullPointerException) {
            try {
                GetResourceTest.getContextClassLoader(cls).getResourceAsStream(null);
                throw new TestFailedException("Expecting NullPointerException, but got none.");
            }
            catch (NullPointerException nullPointerException2) {
                return;
            }
        }
    }

    public void getResourceNonexisting(Class cls) throws TestFailedException {
        this.getResourceNonexisting0(cls, NON_EXISTING_RESOURCE);
        this.getResourceNonexisting0(cls, NON_EXISTING_RESOURCE);
        this.getResourceNonexisting0(cls, "/nbmvzpoqacfkol91267bm.txt");
        this.getResourceNonexisting0(cls, "///////////nbmvzpoqacfkol91267bm.txt");
        this.getResourceNonexisting0(GetResourceTest.getContextClassLoader(cls), NON_EXISTING_RESOURCE);
        this.getResourceNonexisting0(GetResourceTest.getContextClassLoader(cls), NON_EXISTING_RESOURCE);
        this.getResourceNonexisting0(GetResourceTest.getContextClassLoader(cls), "/nbmvzpoqacfkol91267bm.txt");
        this.getResourceNonexisting0(GetResourceTest.getContextClassLoader(cls), "///////////nbmvzpoqacfkol91267bm.txt");
    }

    public void getResourceAsStreamNonexisting(Class cls) throws TestFailedException {
        this.getResourceAsStreamNonexisting0(cls, NON_EXISTING_RESOURCE);
        this.getResourceAsStreamNonexisting0(cls, NON_EXISTING_RESOURCE);
        this.getResourceAsStreamNonexisting0(cls, "/nbmvzpoqacfkol91267bm.txt");
        this.getResourceAsStreamNonexisting0(cls, "//////nbmvzpoqacfkol91267bm.txt");
        this.getResourceAsStreamNonexisting0(GetResourceTest.getContextClassLoader(cls), NON_EXISTING_RESOURCE);
        this.getResourceAsStreamNonexisting0(GetResourceTest.getContextClassLoader(cls), NON_EXISTING_RESOURCE);
        this.getResourceAsStreamNonexisting0(GetResourceTest.getContextClassLoader(cls), "/nbmvzpoqacfkol91267bm.txt");
        this.getResourceAsStreamNonexisting0(GetResourceTest.getContextClassLoader(cls), "//////nbmvzpoqacfkol91267bm.txt");
    }

    private void getResourceNonexisting0(Class cls, String name) throws TestFailedException {
        URL url = cls.getResource(name);
        if (url != null) {
            throw new TestFailedException("Expecting null when getResource " + name + ", but got " + url);
        }
    }

    private void getResourceNonexisting0(ClassLoader loader, String name) throws TestFailedException {
        URL url = loader.getResource(name);
        if (url != null) {
            throw new TestFailedException("Expecting null when getResource " + name + ", but got " + url);
        }
    }

    private void getResourceAsStreamNonexisting0(Class cls, String name) throws TestFailedException {
        InputStream is = cls.getResourceAsStream(name);
        if (is != null) {
            throw new TestFailedException("Expecting null when getResource " + name + ", but got " + is);
        }
    }

    private void getResourceAsStreamNonexisting0(ClassLoader loader, String name) throws TestFailedException {
        InputStream is = loader.getResourceAsStream(name);
        if (is != null) {
            throw new TestFailedException("Expecting null when getResource " + name + ", but got " + is);
        }
    }

    public static ClassLoader getContextClassLoader(Class cls) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = cls.getClassLoader();
        }
        return loader;
    }

    public static void verify(String content, String expected) throws TestFailedException {
        if (!(expected = expected.trim()).equals(content = content.trim())) {
            throw new TestFailedException("Failed to retrieve the resource. Expecting " + expected + ", actual: " + content);
        }
        TLogger.log((String[])new String[]{"Resource retrieved correctly and the content is: " + expected});
    }
}

