/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.sec.permsxml;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.sec.permsxml.PermDDTestIF;
import jakarta.ejb.Remote;
import jakarta.ejb.Stateful;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.security.SecurityPermission;
import java.util.PropertyPermission;

@Stateful(name="PermDDTestEJB")
@Remote(value={PermDDTestIF.class})
public class PermDDTestEJB
implements PermDDTestIF {
    private static final String SEC_MGR_WARNING = "ERROR:  Security Manager is NOT enabled and must be for these tests.  If you have passed these tests while running with Security Manager enabled, you can use keywords to bypass the running of these tests when Security Manager is disabled.";

    @Override
    public boolean validateCustomPerm() {
        boolean rval = false;
        this.debug("Enterred: PermDDTestEJB.validateCustomPerm().");
        try {
            if (null == System.getSecurityManager()) {
                this.debug(SEC_MGR_WARNING);
                return false;
            }
            SecurityPermission perm = new SecurityPermission("CTSPermission1_name");
            this.doCheckPermission(perm);
            this.debug("CTSPermission1_name permission okay");
            this.debug("SUCCESS:  validateCustomPerm passed.");
            rval = true;
        }
        catch (AccessControlException ex) {
            this.debug("FAILURE:  CTSPermission1_name perm missing, throwing AccessControlException.");
            ex.printStackTrace();
            return false;
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateCustomPerm(), throwing unexpected Exception.");
            ex.printStackTrace();
            return false;
        }
        this.debug("Leaving PermDDTestEJB.validateCustomPerm() with rval = " + rval);
        return rval;
    }

    @Override
    public boolean validateLocalGrantForCustomPerm() {
        boolean rval = false;
        this.debug("Enterred: PermDDTestEJB.validateLocalGrantForCustomPerm().");
        try {
            if (null == System.getSecurityManager()) {
                this.debug(SEC_MGR_WARNING);
                return false;
            }
            SecurityPermission perm = new SecurityPermission("CTSPermission2_name");
            this.doCheckPermission(perm);
            this.debug("SUCCESS:  validateLocalGrantForCustomPerm passed.");
            rval = true;
        }
        catch (AccessControlException ex) {
            this.debug("CTSPermission2_name permission property threw unexpected AccessControlException.");
            this.debug("FAILURE:  validateLocalGrantForCustomPerm() did threw unexpected AccessControlException.");
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateLocalGrantForCustomPerm had unexpeted exception.");
            ex.printStackTrace();
        }
        return rval;
    }

    @Override
    public boolean validateRestrictedLocalPerm() {
        boolean rval = false;
        this.debug("Enterred: PermDDTestEJB.validateRestrictedLocalPerm().");
        try {
            if (null == System.getSecurityManager()) {
                this.debug(SEC_MGR_WARNING);
                return false;
            }
            PropertyPermission readPropertyPerm = new PropertyPermission("TestPropertyPerm", "read");
            try {
                this.doCheckPermission(readPropertyPerm);
                this.debug("SUCCESS:  validateRestrictedLocalPerm() has grant for read of TestPropertyPerm");
                rval = true;
            }
            catch (AccessControlException ex) {
                this.debug("FAILURE:  validateRestrictedLocalPerm() threw unexpected exception for read of TestPropertyPerm.");
                ex.printStackTrace();
                return false;
            }
            this.debug("SUCCESS:  validateRestrictedLocalPerm passed.");
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateRestrictedLocalPerm had unexpected exception.");
            ex.printStackTrace();
            rval = false;
        }
        return rval;
    }

    @Override
    public boolean validateRequiredPermSet() {
        boolean rval = false;
        this.debug("Enterred: PermDDTestEJB.validateRequiredPermSet().");
        try {
            if (null == System.getSecurityManager()) {
                this.debug(SEC_MGR_WARNING);
                return false;
            }
            RuntimePermission rtperm = new RuntimePermission("loadLibrary.*");
            this.doCheckPermission(rtperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + rtperm.toString());
            RuntimePermission rtperm2 = new RuntimePermission("queuePrintJob");
            this.doCheckPermission(rtperm2);
            this.debug("validateRequiredPermSet():  valid perm for: " + rtperm2.toString());
            SocketPermission socperm = new SocketPermission("*", "connect");
            this.doCheckPermission(socperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + socperm.toString());
            FilePermission fperm = new FilePermission("*", "read");
            this.doCheckPermission(fperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + fperm.toString());
            PropertyPermission pperm = new PropertyPermission("*", "read");
            this.doCheckPermission(pperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + pperm.toString());
            this.debug("SUCCESS:  validateRequiredPermSet passed.");
            rval = true;
        }
        catch (AccessControlException ex) {
            this.debug("FAILURE:  validateRequiredPermSet had perm missing, throwing AccessControlException.");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateRequiredPermSet had unexpected Exception.");
            ex.printStackTrace();
        }
        return rval;
    }

    @Override
    public boolean validateMissingPermFails() {
        boolean rval = false;
        this.debug("Enterred: PermDDTestEJB.validateMissingPermFails().");
        try {
            if (null == System.getSecurityManager()) {
                this.debug(SEC_MGR_WARNING);
                return false;
            }
            SecurityPermission perm = new SecurityPermission("CTSPermission3_name");
            this.doCheckPermission(perm);
            this.debug("FAILURE:  CTSPermission3_name permission okay");
        }
        catch (AccessControlException ex) {
            this.debug("SUCCESS:  CTSPermission3_name doesnt exist and was caught.");
            this.debug("SUCCESS:  validateMissingPermFails passed.");
            rval = true;
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateMissingPermFails threw unexpected exception.");
            ex.printStackTrace();
        }
        return rval;
    }

    @Override
    public boolean validateLocalPermsInvalidName() {
        this.debug("Enterred: PermDDTestEJB.validateLocalPermsInvalidName().");
        try {
            if (null == System.getSecurityManager()) {
                this.debug(SEC_MGR_WARNING);
                return false;
            }
            SecurityPermission readPropertyPerm = new SecurityPermission("NonExistingName");
            try {
                this.doCheckPermission(readPropertyPerm);
                this.debug("FAILURE:  validateLocalPermsInvalidName() did not throw expected AccessControlException.");
                return false;
            }
            catch (AccessControlException ex) {
                this.debug("SUCCESS:  validateLocalPermsInvalidName() threw expected AccessControlException");
                try {
                    SecurityPermission perm = new SecurityPermission("CTSPermission_second_name");
                    this.doCheckPermission(perm);
                    this.debug("CTSPermission_second_name permission property granted AccessControlException.");
                }
                catch (AccessControlException ex2) {
                    this.debug("FAILURE:  validateLocalPermsInvalidName() threw unexpected exception.");
                    return false;
                }
                catch (Exception ex3) {
                    this.debug("FAILURE:  validateLocalPermsInvalidName had unexpeted exception.");
                    ex3.printStackTrace();
                    return false;
                }
                this.debug("SUCCESS:  validateLocalPermsInvalidName passed.");
            }
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateLocalPermsInvalidName had unexpected exception.");
            ex.printStackTrace();
        }
        return true;
    }

    public void doCheckPermission(Permission pp) throws Exception {
        final Permission perm = pp;
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws AccessControlException {
                AccessController.checkPermission(perm);
                return null;
            }
        });
    }

    private void debug(String str) {
        System.out.println(str);
        TestUtil.logMsg((String)str);
    }
}

