/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndQ;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Properties;

public class MsgBean
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private ConnectionFactory cf = null;
    private Destination Dest = null;
    private MessageProducer mSender = null;
    private Session sess = null;

    public MsgBean() {
        TestUtil.logTrace((String)"@MsgBean()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"@MsgBean-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.cf = (ConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.cf == null) {
                TestUtil.logErr((String)"error looking up ConnectionFactory");
            }
            TestUtil.logTrace((String)"got a ConnectionFactory!!");
            this.Dest = (Destination)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.Dest == null) {
                TestUtil.logErr((String)"Dest error");
            }
            TestUtil.logTrace((String)"got a Dest ");
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"MDB ejbCreate Error!", (Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps(msg, this.p);
        TestUtil.logTrace((String)("@onMessage! " + msg));
        Connection Conn = null;
        try {
            if (msg.getObjectProperty("properties") != null) {
                this.initLogging((Properties)msg.getObjectProperty("properties"));
            }
            if ((Conn = this.cf.createConnection()) == null) {
                TestUtil.logErr((String)"connection error");
            } else {
                Conn.start();
                this.sess = Conn.createSession(true, 0);
            }
            TestUtil.logTrace((String)"started the connection !!");
            if (msg.getStringProperty("MessageType").equals("TextMessage")) {
                this.sendATextMessage();
            } else if (msg.getStringProperty("MessageType").equals("BytesMessage")) {
                this.sendABytesMessage();
            } else if (msg.getStringProperty("MessageType").equals("MapMessage")) {
                this.sendAMapMessage();
            } else if (msg.getStringProperty("MessageType").equals("StreamMessage")) {
                this.sendAStreamMessage();
            } else if (msg.getStringProperty("MessageType").equals("ObjectMessage")) {
                this.sendAnObjectMessage();
            } else {
                TestUtil.logTrace((String)"@onMessage - invalid message type found in StringProperty");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught in onMessage!", (Throwable)e);
        }
        finally {
            if (Conn != null) {
                try {
                    Conn.close();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Error closing Connection", (Throwable)e);
                }
            }
        }
    }

    public void initLogging(Properties p) {
        try {
            TestUtil.init((Properties)p);
            TestUtil.logTrace((String)"MsgBean initLogging OK.");
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"MsgBean initLogging failed.");
            throw new EJBException(e.getMessage());
        }
    }

    private void sendATextMessage() {
        TestUtil.logTrace((String)"@sendATextMessage");
        try {
            String myMsg = "I am sending a text message as requested";
            this.mSender = this.sess.createProducer(this.Dest);
            TextMessage msg = this.sess.createTextMessage();
            msg.setText(myMsg);
            msg.setStringProperty("MessageType", "TextMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught sending a TextMessage!", (Throwable)e);
        }
    }

    private void sendABytesMessage() {
        TestUtil.logTrace((String)"@sendABytesMessage");
        try {
            byte aByte = 10;
            this.mSender = this.sess.createProducer(this.Dest);
            BytesMessage msg = this.sess.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)msg, this.p);
            msg.writeByte(aByte);
            msg.setStringProperty("MessageType", "BytesMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught sending a BytesMessage!", (Throwable)e);
        }
    }

    private void sendAMapMessage() {
        TestUtil.logTrace((String)"@sendAMapMessage");
        try {
            String myMsg = "I am sending a map message as requested";
            this.mSender = this.sess.createProducer(this.Dest);
            MapMessage msg = this.sess.createMapMessage();
            JmsUtil.addPropsToMessage((Message)msg, this.p);
            msg.setString("MapMessage", myMsg);
            msg.setStringProperty("MessageType", "MapMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught sending a MapMessage!", (Throwable)e);
        }
    }

    private void sendAStreamMessage() {
        TestUtil.logTrace((String)"@sendAStreamMessage");
        try {
            String myMsg = "I am sending a stream message as requested";
            this.mSender = this.sess.createProducer(this.Dest);
            StreamMessage msg = this.sess.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)msg, this.p);
            msg.writeString(myMsg);
            msg.setStringProperty("MessageType", "StreamMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught sending a StreamMessage!", (Throwable)e);
        }
    }

    private void sendAnObjectMessage() {
        TestUtil.logTrace((String)"@sendAnObjectMessage");
        try {
            String myMsg = "I am sending a text message as requested";
            this.mSender = this.sess.createProducer(this.Dest);
            ObjectMessage msg = this.sess.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)msg, this.p);
            msg.setObject((Serializable)((Object)myMsg));
            msg.setStringProperty("MessageType", "ObjectMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught sending an ObjectMessage!", (Throwable)e);
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"In MsgBean::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"In MsgBean::remove()!!");
    }
}

