/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.tx.entity.bmp.bm.TxR_Exceptions;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.tx.txEbean.AppException;
import com.sun.ts.tests.ejb.ee.tx.txEbean.TxEBean;
import com.sun.ts.tests.ejb.ee.tx.txEbean.TxEBeanHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.FinderException;
import jakarta.ejb.ObjectNotFoundException;
import jakarta.ejb.RemoveException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionRolledbackException;
import jakarta.transaction.UserTransaction;
import java.util.ArrayList;
import java.util.Properties;

public class TestBeanEJB
implements SessionBean {
    private Properties testProps = new Properties();
    private TSNamingContext jctx = null;
    private SessionContext sctx = null;
    private static final String txEBeanRequired = "java:comp/env/ejb/TxRequired";
    private TxEBeanHome beanHome = null;
    private String tName1 = null;

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
    }

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate w/Properties");
        try {
            this.initLogging(p);
            TestUtil.logTrace((String)"Call to initLogging DONE");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception from initLogging - TestBean:" + e.getMessage()), (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Getting Naming Context");
            this.jctx = new TSNamingContext();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Create exception: " + e.getMessage()), (Throwable)e);
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public boolean test1() {
        TestUtil.logMsg((String)"test1");
        TestUtil.logMsg((String)"Cause an AppException");
        TxEBean beanref = null;
        boolean testResult = false;
        UserTransaction ut = null;
        String brand1 = "First brand";
        String brand2 = "Second brand";
        try {
            TestUtil.logTrace((String)"Looking up the TxEBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEBeanHome)this.jctx.lookup(txEBeanRequired, TxEBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref = this.beanHome.create(this.tName1, 1, brand1, 1.0f, this.testProps);
            TestUtil.logTrace((String)"Getting the UserTransaction interface");
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Update brand name and catch AppException");
            ut.begin();
            try {
                beanref.updateBrandName(brand2, -1);
                TestUtil.logTrace((String)"Did not receive AppException as expected");
            }
            catch (AppException ae) {
                TestUtil.logTrace((String)"AppException received as expected.");
                testResult = true;
            }
            ut.commit();
            TestUtil.logTrace((String)"Transaction commited");
            boolean ae = testResult;
            return ae;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (beanref != null) {
                    beanref.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean test2() {
        TestUtil.logMsg((String)"test2");
        TestUtil.logMsg((String)"Cause a SystemException");
        TxEBean beanref = null;
        boolean t2 = false;
        boolean t1 = false;
        boolean testResult = false;
        UserTransaction ut = null;
        String brand1 = "First brand";
        String brand2 = "Second brand";
        Object key = null;
        try {
            TestUtil.logTrace((String)"Looking up the TxEBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEBeanHome)this.jctx.lookup(txEBeanRequired, TxEBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref = this.beanHome.create(this.tName1, 1, brand1, 1.0f, this.testProps);
            TestUtil.logTrace((String)"Getting the UserTransaction interface");
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Update brand name and catch TransactionRolledbackException");
            ut.begin();
            try {
                beanref.updateBrandName(brand2, -3);
                TestUtil.logTrace((String)"Did not receive TransactionRolledbackException as expected");
            }
            catch (TransactionRolledbackException re) {
                TestUtil.logTrace((String)"TransactionRolledbackException received as expected.");
                t1 = true;
            }
            TestUtil.logTrace((String)"Check that the transaction was marked for rollback");
            int txStatus = ut.getStatus();
            if (txStatus == 1) {
                TestUtil.logTrace((String)"Transaction is marked for rollback");
                TestUtil.printTransactionStatus((int)txStatus);
                t2 = true;
            } else {
                TestUtil.logTrace((String)"Transaction not marked for rollback as expected");
            }
            TestUtil.logTrace((String)"Starting rollback");
            ut.rollback();
            TestUtil.logTrace((String)"Rollback finished");
            if (t1 && t2) {
                testResult = true;
            }
            boolean bl = testResult;
            return bl;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (beanref != null) {
                    beanref.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean test3() {
        TestUtil.logMsg((String)"test3");
        TestUtil.logMsg((String)"Cause a CreateException");
        UserTransaction ut = null;
        TxEBean beanref3 = null;
        TxEBean beanref2 = null;
        TxEBean beanref1 = null;
        boolean testResult = false;
        String brand1 = "First brand";
        String brand2 = "Second brand";
        int key1 = 1;
        int key2 = 2;
        try {
            TestUtil.logTrace((String)"Looking up the TxEBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEBeanHome)this.jctx.lookup(txEBeanRequired, TxEBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref1 = this.beanHome.create(this.tName1, key1, brand1, 1.0f, this.testProps);
            beanref2 = this.beanHome.create(this.tName1, key2, brand2, 1.0f, this.testProps);
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Starting User Transaction");
            ut.begin();
            try {
                beanref3 = this.beanHome.create(this.tName1, key2, brand2, 1.0f, this.testProps);
                TestUtil.logTrace((String)"Did not get CreateException as expected");
            }
            catch (CreateException re) {
                TestUtil.logTrace((String)"Got CreateException as expected");
                testResult = true;
            }
            TestUtil.logTrace((String)"Starting commit");
            ut.commit();
            TestUtil.logTrace((String)"Commit finished");
            boolean re = testResult;
            return re;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (beanref1 != null) {
                    beanref1.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref1: " + e.getMessage()), (Throwable)e);
            }
            try {
                if (beanref2 != null) {
                    beanref2.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref2: " + e.getMessage()), (Throwable)e);
            }
            try {
                if (beanref3 != null) {
                    beanref3.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref3: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean test5() {
        TestUtil.logMsg((String)"test5");
        TestUtil.logMsg((String)"Cause a FinderException");
        UserTransaction ut = null;
        TxEBean beanref2 = null;
        TxEBean beanref1 = null;
        boolean testResult = false;
        ArrayList al = new ArrayList();
        String brand1 = "First brand";
        String brand2 = "Second brand";
        int key1 = 1;
        int key2 = 2;
        try {
            TestUtil.logTrace((String)"Looking up the TxEBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEBeanHome)this.jctx.lookup(txEBeanRequired, TxEBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref1 = this.beanHome.create(this.tName1, key1, brand1, 1.0f, this.testProps);
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Starting User Transaction");
            ut.begin();
            beanref2 = this.beanHome.create(this.tName1, key2, brand1, 1.0f, this.testProps);
            try {
                if (beanref2 != null) {
                    beanref2.remove();
                    TestUtil.logTrace((String)"beanRef2 sucessfully removed");
                }
            }
            catch (RemoveException re) {
                TestUtil.logErr((String)("Could not remove beanref2: " + re.getMessage()), (Throwable)re);
            }
            beanref2 = null;
            try {
                TestUtil.logTrace((String)"Trying to find by brand name");
                al = (ArrayList)this.beanHome.findByBrandName(this.tName1, brand2, this.testProps);
                TestUtil.logTrace((String)"Did not receive expected FinderException");
            }
            catch (FinderException fe) {
                TestUtil.logTrace((String)("Caught expected FinderException: " + fe.getMessage()), (Throwable)fe);
                testResult = true;
            }
            TestUtil.logTrace((String)"Starting rollback");
            ut.rollback();
            TestUtil.logTrace((String)"Rollback finished");
            boolean fe = testResult;
            return fe;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (beanref1 != null) {
                    beanref1.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref1: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean test6() {
        TestUtil.logMsg((String)"test6");
        TestUtil.logMsg((String)"Cause an ObjectNotFoundException");
        UserTransaction ut = null;
        TxEBean beanref2 = null;
        TxEBean beanref = null;
        boolean testResult = false;
        String brand1 = "First brand";
        int key1 = 1;
        try {
            TestUtil.logTrace((String)"Looking up the TxEBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEBeanHome)this.jctx.lookup(txEBeanRequired, TxEBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref = this.beanHome.create(this.tName1, key1, brand1, 1.0f, this.testProps);
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Starting User Transaction");
            ut.begin();
            try {
                beanref2 = this.beanHome.findtxEbean(this.tName1, new Integer(26130), this.testProps);
                TestUtil.logTrace((String)"Did not recieve expected ObjectNotFoundException");
            }
            catch (ObjectNotFoundException onf) {
                TestUtil.logTrace((String)"Received Expected ObjectNotFoundException");
                testResult = true;
            }
            TestUtil.logTrace((String)"Starting rollback");
            ut.rollback();
            TestUtil.logTrace((String)"Rollback finished");
            boolean onf = testResult;
            return onf;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (beanref != null) {
                    beanref.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test7() {
        TestUtil.logMsg((String)"test7");
        TestUtil.logMsg((String)"Cause a RemoveException");
        UserTransaction ut = null;
        TxEBean beanref = null;
        boolean testResult = false;
        String brand1 = "First brand";
        int key1 = 1;
        try {
            TestUtil.logTrace((String)"Looking up the TxEBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEBeanHome)this.jctx.lookup(txEBeanRequired, TxEBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref = this.beanHome.create(this.tName1, key1, brand1, 1.0f, this.testProps);
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Starting User Transaction");
            ut.begin();
            TestUtil.logTrace((String)"Forcing a RemoveException");
            beanref.throwRemoveException();
            TestUtil.logTrace((String)"Did not receive expected RemoveException");
        }
        catch (RemoveException re) {
            testResult = true;
            TestUtil.logTrace((String)"RemoveException received as expected");
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        try {
            TestUtil.logTrace((String)"Starting rollback");
            ut.rollback();
            TestUtil.logTrace((String)"Rollback finished");
        }
        catch (Exception er) {
            TestUtil.logErr((String)("Exception caught while trying to rollback" + er.getMessage()), (Throwable)er);
        }
        finally {
            try {
                if (beanref != null) {
                    beanref.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref: " + e.getMessage()), (Throwable)e);
            }
        }
        return testResult;
    }

    public boolean test8() {
        TestUtil.logMsg((String)"test8");
        TestUtil.logMsg((String)"Cause an EJBException");
        TxEBean beanref = null;
        boolean t2 = false;
        boolean t1 = false;
        boolean testResult = false;
        UserTransaction ut = null;
        String brand1 = "First brand";
        String brand2 = "Second brand";
        Object key = null;
        try {
            TestUtil.logTrace((String)"Looking up the TxEBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEBeanHome)this.jctx.lookup(txEBeanRequired, TxEBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref = this.beanHome.create(this.tName1, 1, brand1, 1.0f, this.testProps);
            TestUtil.logTrace((String)"Getting the UserTransaction interface");
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Update brand name and catch TransactionRolledbackException");
            ut.begin();
            try {
                beanref.updateBrandName(brand2, -5);
                TestUtil.logTrace((String)"Did not receive TransactionRolledbackException as expected");
            }
            catch (TransactionRolledbackException re) {
                TestUtil.logTrace((String)"TransactionRolledbackException received as expected.");
                t1 = true;
            }
            TestUtil.logTrace((String)"Check that the transaction was marked for rollback");
            int txStatus = ut.getStatus();
            if (txStatus == 1) {
                TestUtil.logTrace((String)"Transaction is marked for rollback");
                TestUtil.printTransactionStatus((int)txStatus);
                t2 = true;
            } else {
                TestUtil.logTrace((String)"Did not receive transaction marked for rollback as expected");
            }
            TestUtil.logTrace((String)"Starting rollback");
            ut.rollback();
            TestUtil.logTrace((String)"Rollback finished");
            if (t1 && t2) {
                testResult = true;
            }
            boolean bl = testResult;
            return bl;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (beanref != null) {
                    beanref.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean test9() {
        TestUtil.logMsg((String)"test9");
        TestUtil.logMsg((String)"Cause an Error");
        TxEBean beanref = null;
        boolean t2 = false;
        boolean t1 = false;
        boolean testResult = false;
        UserTransaction ut = null;
        String brand1 = "First brand";
        String brand2 = "Second brand";
        Object key = null;
        try {
            TestUtil.logTrace((String)"Looking up the TxEBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxEBeanHome)this.jctx.lookup(txEBeanRequired, TxEBeanHome.class);
            TestUtil.logTrace((String)"Creating EJB instances of java:comp/env/ejb/TxRequired");
            beanref = this.beanHome.create(this.tName1, 1, brand1, 1.0f, this.testProps);
            TestUtil.logTrace((String)"Getting the UserTransaction interface");
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Update brand name and catch TransactionRolledbackException");
            ut.begin();
            try {
                beanref.updateBrandName(brand2, -6);
                TestUtil.logTrace((String)"Did not receive TransactionRolledbackException as expected");
            }
            catch (TransactionRolledbackException re) {
                TestUtil.logTrace((String)"TransactionRolledbackException received as expected.");
                t1 = true;
            }
            TestUtil.logTrace((String)"Check that the transaction was marked for rollback");
            int txStatus = ut.getStatus();
            if (txStatus == 1) {
                TestUtil.logTrace((String)"Transaction is marked for rollback");
                TestUtil.printTransactionStatus((int)txStatus);
                t2 = true;
            } else {
                TestUtil.logTrace((String)"Did not receive transaction marked for rollback as expected");
            }
            TestUtil.logTrace((String)"Starting rollback");
            ut.rollback();
            TestUtil.logTrace((String)"Rollback finished");
            if (t1 && t2) {
                testResult = true;
            }
            boolean bl = testResult;
            return bl;
        }
        catch (Exception e) {
            try {
                if (ut.getStatus() != 6) {
                    ut.rollback();
                }
            }
            catch (SystemException se) {
                TestUtil.logErr((String)("Exception checking transaction status: " + se.getMessage()), (Throwable)se);
            }
            TestUtil.logErr((String)("Unexpected exception caught: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (beanref != null) {
                    beanref.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception removing beanref: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        this.testProps = p;
        try {
            TestUtil.init((Properties)p);
            this.tName1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"TxEBean_Delete"));
            TestUtil.logTrace((String)("tName1: " + this.tName1));
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.logErr((String)("RemoteLoggingInitException: " + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

