/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookup.client;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.JAXWS_Data;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookup.client.Echo;
import com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookup.client.EchoService;
import com.sun.ts.tests.webservices13.servlet.WSWebServiceRefLookup.client.EjbClientIF;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJBException;
import jakarta.ejb.Remote;
import jakarta.ejb.Stateful;
import jakarta.xml.ws.WebServiceRef;
import java.util.Properties;

@Stateful(name="WSWebServiceRefLookupClntBean")
@Remote(value={EjbClientIF.class})
public class EjbClient
implements EjbClientIF {
    private Properties harnessProps = null;
    private static final boolean debug = false;
    private String urlString;
    @WebServiceRef(name="service/wswsreflookupservice")
    EchoService service = null;
    Echo port = null;
    @WebServiceRef(lookup="java:comp/env/service/wswsreflookupservice")
    EchoService service2 = null;
    Echo port2 = null;

    private void getPort() throws Exception {
        TestUtil.logMsg((String)("EjbClient DEBUG: service=" + this.service));
        this.port = (Echo)this.service.getPort(Echo.class);
        TestUtil.logMsg((String)"EjbClient DEBUG: Obtained port");
        TestUtil.logMsg((String)("EjbClient DEBUG: port=" + this.port));
        this.getTargetEndpointAddress(this.port);
        TestUtil.logMsg((String)("EjbClient DEBUG: service2=" + this.service2));
        TestUtil.logMsg((String)"EjbClient DEBUG: Obtained port");
        this.port2 = (Echo)this.service2.getPort(Echo.class);
        TestUtil.logMsg((String)("EjbClient DEBUG: port2=" + this.port2));
    }

    private void getTargetEndpointAddress(Object port) throws Exception {
        TestUtil.logMsg((String)("Get Target Endpoint Address for port=" + port));
        String urlString = JAXWS_Util.getTargetEndpointAddress(port);
        TestUtil.logMsg((String)("Target Endpoint Address=" + urlString));
    }

    @PostConstruct
    public void postConstruct() {
        try {
            this.getPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("DEBUG postConstruct()");
        System.out.println("EjbClient DEBUG: service=" + this.service);
        System.out.println("EjbClient DEBUG: port=" + this.port);
        System.out.println("EjbClient DEBUG: service2=" + this.service2);
        System.out.println("EjbClient DEBUG: port2=" + this.port2);
        if (this.service == null || this.service2 == null || this.port == null || this.port2 == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    public void init(Properties p) {
        this.harnessProps = p;
        try {
            TestUtil.init((Properties)p);
            this.urlString = this.harnessProps.getProperty("ENDPOINTURL");
            JAXWS_Util.setTargetEndpointAddress(this.port2, this.urlString);
            this.getTargetEndpointAddress(this.port2);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
    }

    @Override
    public boolean testwsreflookup() {
        TestUtil.logMsg((String)"testwsreflookup");
        boolean pass = true;
        return this.stringTest();
    }

    private boolean stringTest() {
        TestUtil.logMsg((String)"stringTest");
        boolean pass = true;
        String request = "Mary";
        try {
            String response = this.port2.echoString(request);
            if (!JAXWS_Data.compareValues(request, response, "String")) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

