/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.ejbql.schema;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CreditCardDVC;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CreditCardException;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CreditCardLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Customer;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerLocalHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.LineItemDVC;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.LineItemException;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.LineItemLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.LineItemLocalHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Order;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderLocalHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Product;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.ProductHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.ProductLocal;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.ProductLocalHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.RemoveException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public abstract class OrderEJB
implements EntityBean {
    private static final String LineItemLocal = "java:comp/env/ejb/LineItemLocal";
    private static final String CreditCardLocal = "java:comp/env/ejb/CreditCardLocal";
    private static final String Order = "java:comp/env/ejb/Order";
    private static final String Product = "java:comp/env/ejb/Product";
    private static final String OrderLocal = "java:comp/env/ejb/OrderLocal";
    private static final String ProductLocal = "java:comp/env/ejb/ProductLocal";
    private static final String CustomerLocal = "java:comp/env/ejb/CustomerLocal";
    private static final String Customer = "java:comp/env/ejb/Customer";
    private EntityContext ectx = null;

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract double getTotalPrice();

    public abstract void setTotalPrice(double var1);

    public abstract CustomerLocal getCustomer();

    public abstract void setCustomer(CustomerLocal var1);

    public abstract CreditCardLocal getCreditCard();

    public abstract void setCreditCard(CreditCardLocal var1);

    public abstract LineItemLocal getSampleLineItem();

    public abstract void setSampleLineItem(LineItemLocal var1);

    public abstract Collection getLineItems();

    public abstract void setLineItems(Collection var1);

    private LineItemLocal createLineItemLocal(String id, int quantity, Order order, Product product) throws Exception {
        TestUtil.logTrace((String)"createLineItemLocal");
        TSNamingContext nctx = new TSNamingContext();
        LineItemLocalHome lineItemLocalHome = (LineItemLocalHome)nctx.lookup(LineItemLocal);
        String orderPK = (String)order.getPrimaryKey();
        OrderLocalHome orderLocalHome = (OrderLocalHome)nctx.lookup(OrderLocal);
        OrderLocal orderLocal = orderLocalHome.findByPrimaryKey(orderPK);
        String productPK = (String)product.getPrimaryKey();
        ProductLocalHome productLocalHome = (ProductLocalHome)nctx.lookup(ProductLocal);
        ProductLocal productLocal = productLocalHome.findByPrimaryKey(productPK);
        LineItemLocal lineItemLocal = lineItemLocalHome.create(id, quantity, orderLocal, productLocal);
        return lineItemLocal;
    }

    public abstract LineItemLocal ejbSelectLineItem(String var1) throws FinderException;

    public abstract Collection ejbSelectAllExpiredCreditCards() throws FinderException;

    public abstract Collection ejbSelectAllLineItems() throws FinderException;

    public abstract Collection ejbSelectSampleLineItems(LineItemLocal var1) throws FinderException;

    public abstract Collection ejbSelectCreditCardBalances() throws FinderException;

    public abstract String ejbSelectMinSingle() throws FinderException;

    public abstract int ejbSelectMaxSingle() throws FinderException;

    public abstract double ejbSelectAvgSingle() throws FinderException;

    public abstract Collection ejbSelectAllCreditCardBalances() throws FinderException;

    public String ejbCreate(String id, Customer customer) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setId(id);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, Customer customer) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            TSNamingContext nctx = new TSNamingContext();
            String customerPK = (String)customer.getPrimaryKey();
            CustomerLocalHome customerLocalHome = (CustomerLocalHome)nctx.lookup(CustomerLocal);
            CustomerLocal customerLocal = customerLocalHome.findByPrimaryKey(customerPK);
            this.setCustomer(customerLocal);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public Collection ejbHomeSelectAllExpiredCreditCards() throws CreditCardException {
        TestUtil.logTrace((String)"ejbHomeSelectAllExpiredCreditCards");
        try {
            Collection ccol = this.ejbSelectAllExpiredCreditCards();
            return ccol;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreditCardException("ejbHomeSelectAllExpiredCreditCards: " + e);
        }
    }

    public Collection ejbHomeSelectAllLineItems() throws LineItemException {
        TestUtil.logTrace((String)"ejbHomeSelectAllLineItems");
        Vector<LineItemDVC> v1 = new Vector<LineItemDVC>();
        LineItemLocal liLeb = null;
        LineItemDVC liDvc = null;
        try {
            Collection ccol = this.ejbSelectAllLineItems();
            Iterator iterator = ccol.iterator();
            TSNamingContext nctx = new TSNamingContext();
            while (iterator.hasNext()) {
                liLeb = (LineItemLocal)iterator.next();
                String orderPK = (String)liLeb.getOrder().getPrimaryKey();
                OrderHome orderHome = (OrderHome)nctx.lookup(Order, OrderHome.class);
                Order order = orderHome.findByPrimaryKey(orderPK);
                String productPK = (String)liLeb.getProduct().getPrimaryKey();
                ProductHome productHome = (ProductHome)nctx.lookup(Product, ProductHome.class);
                Product product = productHome.findByPrimaryKey(productPK);
                liDvc = new LineItemDVC(liLeb.getId(), liLeb.getQuantity(), order, product);
                v1.add(liDvc);
            }
            return v1;
        }
        catch (FinderException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new LineItemException("ejbHomeSelectAllLineItems: " + e);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new LineItemException("ejbHomeSelectAllLineItems: " + e);
        }
    }

    public Collection ejbHomeSelectSampleLineItems(LineItemDVC l) throws LineItemException {
        TestUtil.logTrace((String)"ejbHomeSelectSampleLineItems");
        try {
            TSNamingContext nctx = new TSNamingContext();
            LineItemLocalHome lineItemLocalHome = (LineItemLocalHome)nctx.lookup(LineItemLocal);
            String liLebPK = l.getId();
            LineItemLocal liLeb = lineItemLocalHome.findByPrimaryKey(liLebPK);
            Collection ccol = this.ejbSelectSampleLineItems(liLeb);
            return ccol;
        }
        catch (FinderException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new LineItemException("ejbHomeSelectSampleLineItems: " + e);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new LineItemException("ejbHomeSelectSampleLineItems: " + e);
        }
    }

    public Collection ejbHomeSelectCreditCardBalances() throws CreditCardException {
        TestUtil.logTrace((String)"ejbHomeSelectCreditCardBalances");
        try {
            Collection ccol = this.ejbSelectCreditCardBalances();
            return ccol;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreditCardException("ejbHomeSelectCreditCardBalances: " + e);
        }
    }

    public String ejbHomeSelectMinSingle() {
        TestUtil.logTrace((String)"ejbHomeSelectMinSingle");
        try {
            String s = this.ejbSelectMinSingle();
            return s;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectMinSingle: " + e);
        }
    }

    public int ejbHomeSelectMaxSingle() {
        TestUtil.logTrace((String)"ejbHomeSelectMaxSingle");
        try {
            int i = this.ejbSelectMaxSingle();
            return i;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectMaxSingle: " + e);
        }
    }

    public double ejbHomeSelectAvgSingle() {
        TestUtil.logTrace((String)"ejbHomeSelectAvgSingle");
        try {
            double d = this.ejbSelectAvgSingle();
            return d;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("ejbHomeSelectAvgSingle: " + e);
        }
    }

    public void addLineItem(LineItemDVC p) throws LineItemException {
        try {
            LineItemLocal li = this.createLineItemLocal(p.getId(), p.getQuantity(), p.getOrder(), p.getProduct());
            Collection ccol = this.getLineItems();
            ccol.add(li);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new LineItemException("addLineItem: " + e);
        }
    }

    public void addSampleLineItem(LineItemDVC p) throws LineItemException {
        LineItemLocal liLeb = null;
        try {
            liLeb = this.createLineItemLocal(p.getId(), p.getQuantity(), p.getOrder(), p.getProduct());
            this.setSampleLineItem(liLeb);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new LineItemException("addSampleLineItem: " + e);
        }
    }

    public Collection getClientLineItems() throws LineItemException {
        Vector<LineItemDVC> v1 = new Vector<LineItemDVC>();
        LineItemLocal liLeb = null;
        LineItemDVC liDvc = null;
        try {
            Collection ccol = this.getLineItems();
            Iterator iterator = ccol.iterator();
            TSNamingContext nctx = new TSNamingContext();
            while (iterator.hasNext()) {
                liLeb = (LineItemLocal)iterator.next();
                String orderPK = (String)liLeb.getOrder().getPrimaryKey();
                OrderHome orderHome = (OrderHome)nctx.lookup(Order, OrderHome.class);
                Order order = orderHome.findByPrimaryKey(orderPK);
                String productPK = (String)liLeb.getProduct().getPrimaryKey();
                ProductHome productHome = (ProductHome)nctx.lookup(Product, ProductHome.class);
                Product product = productHome.findByPrimaryKey(productPK);
                liDvc = new LineItemDVC(liLeb.getId(), liLeb.getQuantity(), order, product);
                v1.add(liDvc);
            }
            return v1;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new LineItemException("getClientLineItems: " + e);
        }
    }

    public CreditCardDVC getClientCreditCard() throws CreditCardException {
        Vector v1 = new Vector();
        CreditCardLocal ccLeb = null;
        CreditCardDVC ccDvc = null;
        try {
            TSNamingContext nctx = new TSNamingContext();
            ccLeb = this.getCreditCard();
            String orderPK = (String)ccLeb.getOrder().getPrimaryKey();
            OrderHome orderHome = (OrderHome)nctx.lookup(Order, OrderHome.class);
            Order order = orderHome.findByPrimaryKey(orderPK);
            String customerPK = (String)ccLeb.getCustomer().getPrimaryKey();
            CustomerHome customerHome = (CustomerHome)nctx.lookup(Customer, CustomerHome.class);
            Customer customer = customerHome.findByPrimaryKey(customerPK);
            ccDvc = new CreditCardDVC(ccLeb.getId(), ccLeb.getNumber(), ccLeb.getType(), ccLeb.getExpires(), ccLeb.getApproved(), ccLeb.getBalance(), order, customer);
            return ccDvc;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreditCardException("getClientCreditCard: " + e);
        }
    }

    public Collection ejbHomeSelectAllCreditCardBalances() throws CreditCardException {
        TestUtil.logTrace((String)"ejbHomeSelectAllCreditCardBalances");
        try {
            Collection ccol = this.ejbSelectAllCreditCardBalances();
            return ccol;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreditCardException("ejbHomeSelectAllCreditCardBalances: " + e);
        }
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

