/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.sec.descriptors.ejb.certificate;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices12.sec.descriptors.ejb.certificate.HelloCertificate;
import com.sun.ts.tests.webservices12.sec.descriptors.ejb.certificate.HelloCertificateService;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.WebServiceRef;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class Client
extends EETest {
    HelloCertificate certificatePort;
    private TSURL ctsurl = new TSURL();
    private String hostname = "localhost";
    private String PROTOCOL = "https";
    private String urlString = null;
    private int portnum = 8000;
    @WebServiceRef(name="service/secEjb/wscertificate")
    static HelloCertificateService service = null;

    private void getPort() throws Exception {
        TestUtil.logMsg((String)("service=" + service));
        TestUtil.logMsg((String)"Get port from certificate Service");
        this.certificatePort = service.getHelloCertificatePort();
        TestUtil.logMsg((String)("port=" + this.certificatePort));
        TestUtil.logMsg((String)"certificate port obtained");
        BindingProvider bindingProvider = (BindingProvider)this.certificatePort;
        Map map = bindingProvider.getRequestContext();
        TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
        map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.hostname = p.getProperty("webServerHost");
            this.portnum = Integer.parseInt(p.getProperty("securedWebServicePort"));
            String tlsVersion = p.getProperty("client.cert.test.jdk.tls.client.protocols");
            if (tlsVersion != null) {
                TestUtil.logMsg((String)("client.cert.test.jdk.tls.client.protocols=" + tlsVersion));
                System.setProperty("https.protocols", tlsVersion);
            }
            this.urlString = this.ctsurl.getURLString(this.PROTOCOL, this.hostname, this.portnum, "/WSSecEjbCertificate/ejb");
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            this.getPort();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        TestUtil.logMsg((String)"setup ok");
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }

    private void printSeperationLine() {
        TestUtil.logMsg((String)"---------------------------");
    }

    public void secEjbCertificate() throws EETest.Fault {
        TestUtil.logMsg((String)"secEjbCertificate");
        try {
            String ret1 = this.certificatePort.sayHelloCertificate("secEjbCertificate");
            if (!ret1.equals("'secEjbCertificate' from HelloCertificateImpl!")) {
                TestUtil.logMsg((String)("secEjbCertificate failed: return value: " + ret1));
                throw new EETest.Fault("SecEjbCertificate failed");
            }
            TestUtil.logMsg((String)"secEjbCertificate passed");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("secEjbCertificate failed: got exception " + t.toString()));
            throw new EETest.Fault("secEjbCertificate failed");
        }
    }
}

