/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.ejb.annotations.WSEjbWebServiceRefTest1;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbWebServiceRefTest1.Hello;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbWebServiceRefTest1.WSEjbWebServiceRefTest1HelloService;
import jakarta.xml.ws.WebServiceRef;
import java.net.URL;
import java.util.Properties;
import javax.naming.InitialContext;

public class Client
extends EETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private TSURL ctsurl = new TSURL();
    private static final String ENDPOINT_URL = "wsejbwebservicereftest1.endpoint";
    private static final String WSDLLOC_URL = "wsejbwebservicereftest1.wsdlloc";
    private String url = null;
    private static URL wsdlurl = null;
    private Hello port;
    @WebServiceRef
    static WSEjbWebServiceRefTest1HelloService service;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXWS_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXWS_Util.getURLFromProp(WSDLLOC_URL);
        wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + wsdlurl));
    }

    private void getPort() throws Exception {
        TestUtil.logMsg((String)"Get wsejbwebservicereftest1 Service via @WebServiceRef annotation");
        TestUtil.logMsg((String)"Uses no attribute @WebServiceRef");
        TestUtil.logMsg((String)("service=" + service));
        TestUtil.logMsg((String)"Get port from service");
        this.port = service.getHelloPort();
        TestUtil.logMsg((String)("port=" + this.port));
        TestUtil.logMsg((String)"Port obtained");
        JAXWS_Util.dumpTargetEndpointAddress(this.port);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            if (pass) {
                this.getTestURLs();
                this.getPort();
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    private void printSeperationLine() {
        TestUtil.logMsg((String)"---------------------------");
    }

    public void WSEjbWebServiceRefTest1CallHello() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbWebServiceRefTest1CallHello");
        try {
            String txt = this.port.hello("Hi there");
            if (!txt.equals("Hi there to you too!")) {
                throw new RuntimeException("Msg returned from hello() incorrect");
            }
            TestUtil.logMsg((String)"WSEjbWebServiceRefTest1CallHello passed");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault("WSEjbWebServiceRefTest1CallHello failed");
        }
    }

    public void WSEjbWebServiceRefTest1CallBye() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbWebServiceRefTest1CallBye");
        try {
            String txt = this.port.bye("Bye-bye");
            if (!txt.equals("Bye-bye and take care")) {
                throw new RuntimeException("Msg returned from bye() incorrect");
            }
            TestUtil.logMsg((String)"WSEjbWebServiceRefTest1CallBye passed");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault("WSEjbWebServiceRefTest1CallBye failed");
        }
    }

    public void WSEjbWebServiceRefTest1VerifyTargetEndpointAddress() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbWebServiceRefTest1VerifyTargetEndpointAddress");
        try {
            String endpointaddr = JAXWS_Util.getTargetEndpointAddress(this.port);
            TestUtil.logMsg((String)"Verify the target endpoint address");
            if (!endpointaddr.equals(this.url)) {
                throw new RuntimeException("Target Endpoint Address is incorrect: " + endpointaddr);
            }
            TestUtil.logMsg((String)"WSEjbWebServiceRefTest1VerifyTargetEndpointAddress passed");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault("WSEjbWebServiceRefTest1VerifyTargetEndpointAddress failed");
        }
    }

    public void WSEjbWebServiceRefTest1VerifyJNDILookupOfService() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbWebServiceRefTest1VerifyJNDILookupOfService");
        try {
            TestUtil.logMsg((String)"Test JNDI lookup for wsejbwebservicereftest1 Service");
            InitialContext ctx = new InitialContext();
            WSEjbWebServiceRefTest1HelloService service = (WSEjbWebServiceRefTest1HelloService)((Object)ctx.lookup("java:comp/env/com.sun.ts.tests.webservices12.ejb.annotations.WSEjbWebServiceRefTest1.Client/service"));
            TestUtil.logMsg((String)("service=" + service));
            TestUtil.logMsg((String)"WSEjbWebServiceRefTest1VerifyJNDILookupOfService passed");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault("WSEjbWebServiceRefTest1VerifyJNDILookupOfService failed");
        }
    }
}

