/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.localTx.lifecycle;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class lifecycleClient1
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private TSConnection con = null;
    private String whitebox_tx = null;
    private TSDataSource ds1 = null;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        lifecycleClient1 theTests = new lifecycleClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.whitebox_tx = p.getProperty("whitebox-tx");
        this.logMsg("Using: " + this.whitebox_tx);
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception constructing DBSupport object: " + e.getMessage(), e);
        }
        try {
            this.nctx = new TSNamingContext();
            this.ds1 = (TSDataSource)this.nctx.lookup(this.whitebox_tx);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testAssociationMCFandRA() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTxManagedConnectionFactory setResourceAdapter 1";
        String toCheck2 = "LocalTxResourceAdapter Started 1";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b1 || !b2) {
            throw new EETest.Fault("ManagedConnectionFactory.setResourceAdapter or ResourceAdapter.start not called");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
    }

    public void testAssociationMCFandRA2() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTxManagedConnectionFactory setResourceAdapter 2";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (b1) {
            throw new EETest.Fault("ManagedConnectionFactory.setResourceAdapter erroneously called more than once.");
        }
        TestUtil.logMsg((String)"testAssociationMCFandRA2 called correctly");
    }

    public void testInstantiationOfRA() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTxResourceAdapterImpl Constructor";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new EETest.Fault("ResourceAdapter not Instantiated");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
    }

    public void testBootstrapforNull() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTxResourceAdapter BootstrapContext Not Null ";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new EETest.Fault("ResourceAdapter not Instantiated");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
    }

    public void testRASharability() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTxResourceAdapter Started 2";
        String toCheck2 = "LocalTxResourceAdapter Started 1";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b1 || !b2) {
            throw new EETest.Fault("Resource Adapter is Shared or reused.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
    }

    public void testMCFcalledOnce() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTxManagedConnectionFactory setResourceAdapter";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new EETest.Fault("LocalTxManagedConnectionFactory.setResourceAdapter not called .");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
    }

    public void testRAforJavaBean() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTxResourceAdapter.setRAName";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new EETest.Fault("Application Server did not call JavaBean setter and getter methods.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        TestUtil.logMsg((String)"Exception dropping table.");
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"Cleanup");
        this.ds1.clearLog();
        try {
            this.con.close();
        }
        catch (Exception sqle) {
            TestUtil.logErr((String)("Exception on cleanup: " + sqle.getMessage()), (Throwable)sqle);
        }
    }
}

