/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.ejbql.where_clause;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AliasHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Customer;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.LineItemDVC;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.ProductHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Schema;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Util;
import java.util.Collection;
import java.util.Properties;

public class Client
extends EETest {
    private CustomerHome customerHome = null;
    private OrderHome orderHome = null;
    private AliasHome aliasHome = null;
    private ProductHome productHome = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            this.props = p;
            Schema.setup(p);
            this.customerHome = Schema.customerHome;
            this.orderHome = Schema.orderHome;
            this.aliasHome = Schema.aliasHome;
            this.productHome = Schema.productHome;
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void whereTest1() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders with a total price < $100");
            o = this.orderHome.findOrdersByQuery1();
            expectedPKs = new String[]{"9", "10", "12", "13"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders with total price < $100");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders with total price < $100");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest1 failed");
        }
    }

    public void whereTest2() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders with a total price > $553.95");
            o = this.orderHome.findOrdersByQuery2();
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "11", "14", "16"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders with total price > $553.95");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders with total price > $553.95");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest2: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest2 failed");
        }
    }

    public void whereTest3() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders where the total price is NOT less than $4500");
            o = this.orderHome.findOrdersByQuery3();
            expectedPKs = new String[]{"5", "11", "16"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders for Query 3");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders for Query 3");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest3 failed");
        }
    }

    public void whereTest4() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders where the line item quantity is 1 AND the customer name is Robert E. Bissett");
            o = this.orderHome.findOrdersByQuery4();
            expectedPKs = new String[]{"4", "9"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders for Query 4");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders for Query 4");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest4 failed");
        }
    }

    public void whereTest5() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders where the customer name is Karen R. Tegan OR the total price is less than $100");
            o = this.orderHome.findOrdersByQuery5();
            expectedPKs = new String[]{"6", "9", "10", "12", "13"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders for Query5");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders for Query5");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest5: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest5 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest5 failed");
        }
    }

    public void whereTest6() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders where line item quantity is 1 AND the order total less than 100 or customer name is Robert E. Bissett");
            o = this.orderHome.findOrdersByQuery6();
            expectedPKs = new String[]{"4", "9", "12", "13"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders for Query 6");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders for Query 6");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest6: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest6 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest6 failed");
        }
    }

    public void whereTest7() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders with line item quantity < 2 for customer Robert E. Bissett");
            o = this.orderHome.findOrdersByQuery9("Robert E. Bissett");
            expectedPKs = new String[]{"4", "9"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders for Query 9");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders for Query 9");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest7: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest7 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest7 failed");
        }
    }

    public void whereTest8() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders with a total price BETWEEN $1000 and $1200");
            o = this.orderHome.findOrdersByQuery12();
            expectedPKs = new String[]{"1", "3", "7", "8", "14"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders with total price BETWEEN $1000 and $1200");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders with total price BETWEEN $1000 and $1200");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest8: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest8 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest8 failed");
        }
    }

    public void whereTest9() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders with a total price NOT BETWEEN $1000 and $1200");
            o = this.orderHome.findOrdersByQuery13();
            expectedPKs = new String[]{"2", "4", "5", "6", "9", "10", "11", "12", "13", "15", "16"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders with total price NOT BETWEEN $1000 and $1200");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders with total price NOT BETWEEN $1000 and $1200");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest9: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest9 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest9 failed");
        }
    }

    public void whereTest10() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders that do not have approved Credit Cards");
            o = this.orderHome.findOrdersByQuery14();
            expectedPKs = new String[]{"1", "7", "11", "13"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found orders with unapproved Credit Cards");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders with unapproved Credit Cards");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest10: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest10 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest10 failed");
        }
    }

    public void whereTest11() throws EETest.Fault {
        boolean pass = true;
        Customer c = null;
        try {
            TestUtil.logMsg((String)"Find customer with name: Stephen S. D'Milla");
            c = this.customerHome.findCustomerByName("Stephen S. D'Milla");
            if (!Util.checkEJB(c, "5")) {
                TestUtil.logErr((String)"UnSuccessfully found customer Stephen S. D'Milla");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customer Stephen S. D'Milla");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest11: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest11 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest11 failed");
        }
    }

    public void whereTest12() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all customers IN home city: Lexington");
            c = this.customerHome.findCustomersByQuery8();
            expectedPKs = new String[]{"2"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers IN home city: Lexington");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers IN home city: Lexington");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest12: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest12 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest12 failed");
        }
    }

    public void whereTest13() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all customers NOT IN home city: Swansea or Brookline");
            c = this.customerHome.findCustomersByQuery9();
            expectedPKs = new String[]{"1", "2", "5", "6", "7", "8", "10", "11", "12", "13", "14"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers NOT IN home city: Swansea or Brookline");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers NOT IN home city: Swansea or Brookline");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest13: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest13 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest13 failed");
        }
    }

    public void whereTest14() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find All Customers with home ZIP CODE that ends in 77");
            c = this.customerHome.findCustomersByQuery10();
            expectedPKs = new String[]{"2"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers with home ZIP CODE ending in 77");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers with home ZIP CODE ending in 77");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest14: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest14 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest14 failed");
        }
    }

    public void whereTest15() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all customers with a home zip code that does not contain 44 in the third and fourth position");
            c = this.customerHome.findCustomersByQuery11();
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "9", "10", "11", "12", "13", "14"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers whose home zip code does not contain 44");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers whose ZIP CODE does not contain 44");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest15: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest15 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest15 failed");
        }
    }

    public void whereTest16() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all customers who do not have aliases");
            c = this.customerHome.findCustomersByQuery12();
            expectedPKs = new String[]{"6"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found customers who do not have aliases defined");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers who do not have aliases defined");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest16: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest16 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest16 failed");
        }
    }

    public void whereTest17() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all customers who have aliases");
            c = this.customerHome.findCustomersByQuery13();
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found customers who have aliases defined");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers who have aliases defined");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest17: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest17 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest17 failed");
        }
    }

    public void whereTest18() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find All Customers who have a null work zip code entry");
            c = this.customerHome.findCustomersByQuery25();
            expectedPKs = new String[]{"13"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found customers who have null work zip codes");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers who have null work zip codes");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest18: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest18 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest18 failed");
        }
    }

    public void whereTest19() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all customers who do not have null work zip code entry");
            c = this.customerHome.findCustomersByQuery26();
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found customers who do not have null work zip codes");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers do not have null work zip codes");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest19: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest19 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest19 failed");
        }
    }

    public void whereTest20() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection a = null;
        try {
            TestUtil.logMsg((String)"Find all aliases who have match: stevie");
            a = this.aliasHome.findAliasesByQuery2();
            expectedPKs = new String[]{"14"};
            if (!Util.checkEJBs(a, 3, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found matches to alias: stevie");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all matches with alias: stevie");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest20: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest20 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest20 failed");
        }
    }

    public void whereTest21() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection a = null;
        try {
            TestUtil.logMsg((String)"Find all aliases containing the substring: iris");
            a = this.aliasHome.findAliasesByQuery3("iris", 1, 4);
            expectedPKs = new String[]{"20"};
            if (!Util.checkEJBs(a, 3, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found expected aliases");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found expected aliases");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest21: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest21 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest21 failed");
        }
    }

    public void whereTest22() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection a = null;
        try {
            TestUtil.logMsg((String)"Find aliases whose alias name is greater than 4 characters");
            a = this.aliasHome.findAliasesByQuery4();
            expectedPKs = new String[]{"8", "10", "13", "14", "18", "28", "29"};
            if (!Util.checkEJBs(a, 3, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found alias names with greater than 4 characters");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found alias names with greater than 4 characters");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest22: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest22 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest22 failed");
        }
    }

    public void whereTest23() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all Orders with a total price greater than 1180");
            o = this.orderHome.findOrdersByQuery16(1180.0);
            expectedPKs = new String[]{"1", "2", "4", "5", "6", "11", "16"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found orders with total price greater than 1180.00");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found orders with total price greater than 1180.00");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest23: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest23 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest23 failed");
        }
    }

    public void whereTest24() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection a = null;
        try {
            TestUtil.logMsg((String)"Find all aliases who contain the string: ev in their alias name");
            a = this.aliasHome.findAliasesByQuery5();
            expectedPKs = new String[]{"13", "14", "18"};
            if (!Util.checkEJBs(a, 3, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found aliases who match the given string: ev");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all aliases who match the string: ev in their alias name");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest24: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest24 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest24 failed");
        }
    }

    public void whereTest25() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection a = null;
        try {
            TestUtil.logMsg((String)"Find aliases who are members of customersNoop");
            a = this.aliasHome.findAliasesByQuery6();
            expectedPKs = new String[]{};
            if (!Util.checkEJBs(a, 3, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found aliases in MEMBER collection");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found aliases in MEMBER collection");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest25: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest25 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest25 failed");
        }
    }

    public void whereTest26() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection a = null;
        try {
            TestUtil.logMsg((String)"Find aliases who are NOT members of collection");
            a = this.aliasHome.findAliasesByQuery7();
            expectedPKs = new String[30];
            for (int i = 0; i < 30; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!Util.checkEJBs(a, 3, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found aliases NOT in member collection");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found aliases NOT in member collection");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest26: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest26 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest26 failed");
        }
    }

    public void whereTest27() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all customers with an alias LIKE: sh_ll");
            c = this.customerHome.findCustomersByQuery28();
            expectedPKs = new String[]{"3"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers with an alias LIKE: sh_ll");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers with an alias LIKE: sh_ll");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest27: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest27 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest27 failed");
        }
    }

    public void whereTest28() throws EETest.Fault {
        boolean pass = true;
        Customer c = null;
        try {
            TestUtil.logMsg((String)"Find customer with home address in Lexington, MA");
            c = this.customerHome.getCustomerByQuery29("10 Griffin Road", "Lexington", "MA", "02277");
            if (!Util.checkEJB(c, "2")) {
                TestUtil.logErr((String)"UnSuccessfully found customer Arthur D. Frechette");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customer Arthur D. Frechette");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest28: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest28 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest28 failed");
        }
    }

    public void whereTest29() throws EETest.Fault {
        boolean pass = true;
        Customer c = null;
        try {
            TestUtil.logMsg((String)"Find customer with home address in Hudson, New Hampshire");
            c = this.customerHome.findCustomerByQuery29("100 Forrest Drive", "Hudson", "NH", "78654");
            if (!Util.checkEJB(c, "5")) {
                TestUtil.logErr((String)"UnSuccessfully found customer Stephen S. DMilla");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customer Stephen S. DMilla");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest29: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest29 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest29 failed");
        }
    }

    public void whereTest30() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find customers with home city of Peabody");
            c = this.customerHome.getCustomersByQuery32("Peabody");
            expectedPKs = new String[]{"7", "8"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found customers with home city of Peabody");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customers with home city of Peabody");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest30: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest30 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest30 failed");
        }
    }

    public void whereTest31() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find customers with home city Peabody");
            c = this.customerHome.findCustomersByQuery32("Peabody");
            expectedPKs = new String[]{"7", "8"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found customers with home city of Peabody");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customers with home city of Peabody");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest31: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest31 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest31 failed");
        }
    }

    public void whereTest32() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders where line items are members of the orders");
            o = this.orderHome.findOrdersByQuery17();
            expectedPKs = new String[16];
            for (int i = 0; i < 16; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders with line item members");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found orders with line item members");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest32: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest32 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest32 failed");
        }
    }

    public void whereTest33() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        LineItemDVC liDvc = null;
        try {
            TestUtil.logMsg((String)"Find orders whose orders are do NOT contain the specified line items");
            liDvc = Schema.lineItemDVC[29];
            o = this.orderHome.selectSampleLineItems(liDvc);
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found orders NOT containing specified line item");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found orders NOT containing specified line item");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest33: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest33 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest33 failed");
        }
    }

    public void whereTest34() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find orders who have Samples in their orders");
            o = this.orderHome.findOrdersByQuery18();
            expectedPKs = new String[]{"1", "6"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found orders with Samples");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found orders with Samples");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest34: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest34 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest34 failed");
        }
    }

    public void whereTest35() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders which contain lineitems not of quantities 1 or 5");
            o = this.orderHome.findOrdersByQuery19();
            expectedPKs = new String[]{"10", "12", "14", "15", "16"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders with lineitem quantities not of 1 or 5");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders with lineitems of quantities not of 1 or 5");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest35: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest35 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest35 failed");
        }
    }

    public void whereTest36() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all customers whose lives in city Attleboro");
            c = this.customerHome.findCustomersByQuery37("Attleboro");
            expectedPKs = new String[]{"13"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers living in Attleboro");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers living in Attleboro");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest36: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest36 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest36 failed");
        }
    }

    public void whereTest37() throws EETest.Fault {
        boolean pass1 = true;
        boolean pass2 = true;
        String[] expectedPKs = null;
        String[] expectedPKs2 = null;
        Collection c1 = null;
        Collection c2 = null;
        try {
            TestUtil.logMsg((String)"Execute two queries composed differently and verify results");
            c1 = this.customerHome.findCustomersByQuery33();
            expectedPKs = new String[]{"5", "6", "12", "14"};
            c2 = this.customerHome.findCustomersByQuery34();
            expectedPKs2 = new String[]{"5", "6", "12", "14"};
            if (!Util.checkEJBs(c1, 1, expectedPKs)) {
                TestUtil.logErr((String)"ERROR: findCustomersByQuery33 returned unexpected results");
                pass1 = false;
            } else {
                TestUtil.logMsg((String)"findCustomersByQuery33 returned expected results");
            }
            if (!Util.checkEJBs(c2, 1, expectedPKs2)) {
                TestUtil.logErr((String)"ERROR: findCustomersByQuery34 returned unexpected results");
                pass2 = false;
            } else {
                TestUtil.logMsg((String)"findCustomersByQuery34 returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest37: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest37 failed", e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("whereTest37 failed");
        }
    }

    public void whereTest38() throws EETest.Fault {
        boolean pass1 = true;
        boolean pass2 = true;
        String[] expectedPKs = null;
        String[] expectedPKs2 = null;
        Collection c1 = null;
        Collection c2 = null;
        try {
            TestUtil.logMsg((String)"Execute two queries composed differently and verify results");
            c1 = this.customerHome.findCustomersByQuery35();
            expectedPKs = new String[]{"1", "2", "3", "4", "7", "8", "9", "10", "11", "13"};
            c2 = this.customerHome.findCustomersByQuery36();
            expectedPKs2 = new String[]{"1", "2", "3", "4", "7", "8", "9", "10", "11", "13"};
            if (!Util.checkEJBs(c1, 1, expectedPKs)) {
                TestUtil.logErr((String)"ERROR: findCustomersByQuery35 returned unexpected results");
                pass1 = false;
            } else {
                TestUtil.logMsg((String)"findCustomersByQuery35 returned expected results");
            }
            if (!Util.checkEJBs(c2, 1, expectedPKs2)) {
                TestUtil.logErr((String)"ERROR: findCustomersByQuery36 returned unexpected results");
                pass2 = false;
            } else {
                TestUtil.logMsg((String)"findCustomersByQuery36 returned expected resuts");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest38: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest38 failed", e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("whereTest38 failed");
        }
    }

    public void whereTest39() throws EETest.Fault {
        boolean pass1 = true;
        boolean pass2 = true;
        String[] expectedPKs = null;
        String[] expectedPKs2 = null;
        Collection p1 = null;
        Collection p2 = null;
        try {
            TestUtil.logMsg((String)"Execute two queries composed differently and verify results");
            p1 = this.productHome.findProductsByQuery2();
            expectedPKs = new String[]{"8", "9", "17"};
            p2 = this.productHome.findProductsByQuery3();
            expectedPKs2 = new String[]{"8", "9", "17"};
            if (!Util.checkEJBs(p1, 4, expectedPKs)) {
                TestUtil.logErr((String)"ERROR:  findProductsByQuery2 returned unexpected results");
                pass1 = false;
            } else {
                TestUtil.logMsg((String)"findProductsByQuery2 returned expected results");
            }
            if (!Util.checkEJBs(p2, 4, expectedPKs2)) {
                TestUtil.logErr((String)"ERROR:  findProductsByQuery3 returned unexpected results");
                pass2 = false;
            } else {
                TestUtil.logMsg((String)"findProductsByQuery3 returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest39: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest39 failed", e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("whereTest39 failed");
        }
    }

    public void whereTest40() throws EETest.Fault {
        boolean pass1 = true;
        boolean pass2 = true;
        String[] expectedPKs = null;
        String[] expectedPKs2 = null;
        Collection p1 = null;
        Collection p2 = null;
        try {
            TestUtil.logMsg((String)"Execute two queries composed differently and verify results");
            p1 = this.productHome.findProductsByQuery4();
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "10", "11", "12", "13", "14", "15", "16", "18"};
            p2 = this.productHome.findProductsByQuery5();
            expectedPKs2 = new String[]{"1", "2", "3", "4", "5", "6", "7", "10", "11", "12", "13", "14", "15", "16", "18"};
            if (!Util.checkEJBs(p1, 4, expectedPKs)) {
                TestUtil.logErr((String)"ERROR: findProductsByQuery4 returned unexpected results");
                pass1 = false;
            } else {
                TestUtil.logMsg((String)"findProductsByQuery4 returned expected results");
            }
            if (!Util.checkEJBs(p2, 4, expectedPKs2)) {
                TestUtil.logErr((String)"ERROR: findProductsByQuery5 returned unexpected results");
                pass2 = false;
            } else {
                TestUtil.logMsg((String)"findProductsByQuery5 returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest40: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest40 failed", e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("whereTest40 failed");
        }
    }

    public void whereTest41() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection p = null;
        try {
            TestUtil.logMsg((String)"Find orders that have the quantity of 50 available");
            p = this.productHome.findProductsByQuery6();
            expectedPKs = new String[]{"5"};
            if (!Util.checkEJBs(p, 4, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all products with quantity 50");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all products of quantity 50");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest41: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest41 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest41 failed");
        }
    }

    public void whereTest42() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        double dbl = 2500.0;
        try {
            TestUtil.logMsg((String)"Find orders specifying creditcard type and credit card balance");
            o = this.orderHome.findOrdersByQuery21("VISA", dbl);
            expectedPKs = new String[]{"3"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found expected orders");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found expected orders");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest42: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest42 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest42 failed");
        }
    }

    public void whereTest43() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find orders specifying creditcard type ONLY");
            o = this.orderHome.findOrdersByQuery21("AXP");
            expectedPKs = new String[]{"8", "9", "10", "13"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found expected orders");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found expected orders");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest43: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest43 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest43 failed");
        }
    }

    public void whereTest44() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        double dbl = 50.0;
        try {
            TestUtil.logMsg((String)"Find customers with specific credit card balance");
            c = this.customerHome.findCustomersByQuery42(dbl);
            expectedPKs = new String[]{"3"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully returned expected results");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest44: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest44 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest44 failed");
        }
    }

    public void whereTest45() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all customers with an alias that contains an underscore");
            c = this.customerHome.findCustomersByQuery44();
            expectedPKs = new String[]{"3"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers with an alias LIKE: %_%");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers with an alias LIKE: %_%");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception whereTest45: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("whereTest45 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("whereTest45 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }
}

