/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.delete;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Person;
import ee.jakarta.tck.nosql.factories.PersonListSupplier;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class DeleteTemplateTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with no conditions")
    void shouldInsertIterableAndDeleteNoCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Person.class).execute();
            List result = this.template.select(Person.class).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with simple condition")
    void shouldInsertIterableAndDeleteWithSimpleCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Person.class).where("name").eq((Object)entities.get(0).getName()).execute();
            List result = this.template.select(Person.class).where("name").eq((Object)entities.get(0).getName()).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with greater-than condition")
    void shouldInsertIterableAndDeleteWithGreaterThanCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Person.class).where("age").gt((Object)entities.get(0).getAge()).execute();
            List result = this.template.select(Person.class).where("age").gt((Object)entities.get(0).getAge()).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with less-than condition")
    void shouldInsertIterableAndDeleteWithLessThanCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Person.class).where("age").lt((Object)entities.get(0).getAge()).execute();
            List result = this.template.select(Person.class).where("age").lt((Object)entities.get(0).getAge()).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with 'in' condition")
    void shouldInsertIterableAndDeleteWithInCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Person.class).where("name").in(List.of(entities.get(0).getName())).execute();
            List result = this.template.select(Person.class).where("name").in(List.of(entities.get(0).getName())).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with 'between' condition")
    void shouldInsertIterableAndDeleteWithBetweenCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Person.class).where("age").between((Object)entities.get(0).getAge(), (Object)(entities.get(0).getAge() + 5)).execute();
            List result = this.template.select(Person.class).where("age").between((Object)entities.get(0).getAge(), (Object)(entities.get(0).getAge() + 5)).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with 'complex' query")
    void shouldInsertIterableAndDeleteWithComplexQuery(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Person.class).where("age").gt((Object)entities.get(0).getAge()).and("name").eq((Object)entities.get(0).getName()).execute();
            List result = this.template.select(Person.class).where("age").gt((Object)entities.get(0).getAge()).and("name").eq((Object)entities.get(0).getName()).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }
}

