/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb.indexes;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.orientdb.indexes.OrientNodeIndex;

final class ResultSetIterable<T>
implements IGraphIterable<T> {
    private final Class<T> klass;
    private final String key;
    private final Object valueExpr;
    private final OrientNodeIndex nodeIndex;

    public ResultSetIterable(String key, Object valueExpr, OrientNodeIndex nodeIndex, Class<T> klass) {
        this.key = key;
        this.valueExpr = valueExpr;
        this.klass = klass;
        this.nodeIndex = nodeIndex;
    }

    public Iterator<T> iterator() {
        OIndex<?> idx = this.nodeIndex.getIndex(this.valueExpr.getClass());
        if (idx == null) {
            return Collections.emptyIterator();
        }
        Collection resultSet = (Collection)idx.get((Object)new OCompositeKey(new Object[]{this.key, this.valueExpr}));
        if (resultSet == null || resultSet.isEmpty()) {
            return Collections.emptyListIterator();
        }
        final Iterator itIdentifiable = resultSet.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return itIdentifiable.hasNext();
            }

            @Override
            public T next() {
                return ResultSetIterable.this.nodeIndex.getDatabase().getElementById(((OIdentifiable)itIdentifiable.next()).getIdentity(), ResultSetIterable.this.klass);
            }

            @Override
            public void remove() {
                itIdentifiable.remove();
            }
        };
    }

    public int size() {
        OIndex<?> idx = this.nodeIndex.getIndex(this.valueExpr.getClass());
        if (idx == null) {
            return 0;
        }
        Collection resultSet = (Collection)idx.get((Object)new OCompositeKey(new Object[]{this.key, this.valueExpr}));
        return resultSet.size();
    }

    public T getSingle() {
        return this.iterator().next();
    }
}

