/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb.indexes;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.orientdb.OrientDatabase;
import org.eclipse.hawk.orientdb.indexes.OIndexCursorFactory;

final class IndexCursorFactoryNodeIterable<T>
implements IGraphIterable<T> {
    private final OIndexCursorFactory factory;
    private final OrientDatabase graph;
    private final Class<T> klass;

    IndexCursorFactoryNodeIterable(OIndexCursorFactory factory, OrientDatabase graph, Class<T> klass) {
        this.factory = factory;
        this.graph = graph;
        this.klass = klass;
    }

    public Iterator<T> iterator() {
        final Iterator<OIdentifiable> results = this.factory.query();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                try {
                    return results != null && results.hasNext();
                }
                catch (ArrayIndexOutOfBoundsException | NoSuchElementException ex) {
                    return false;
                }
            }

            @Override
            public T next() {
                OIdentifiable next = (OIdentifiable)results.next();
                ORID id = next.getIdentity();
                return IndexCursorFactoryNodeIterable.this.graph.getElementById(id, IndexCursorFactoryNodeIterable.this.klass);
            }

            @Override
            public void remove() {
                results.remove();
            }
        };
    }

    public int size() {
        Iterator<T> it = this.iterator();
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public T getSingle() {
        return this.iterator().next();
    }
}

