/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb;

import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.File;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.orientdb.OrientDatabase;

public class RemoteOrientDatabase
extends OrientDatabase {
    private static final String DBTYPE_DOC = "document";
    public static final String DBSTORAGE_PLOCAL = "plocal";
    public static final String DBSTORAGE_MEMORY = "memory";
    private String rootUsername = "root";
    private String rootPassword = "root";
    private String dbUsername = "admin";
    private String dbPassword = "admin";
    private String storageType = "plocal";

    @Override
    public void run(File parentfolder, IConsole c) {
        try {
            this.run("remote:localhost/" + parentfolder.getName(), parentfolder, c);
        }
        catch (Exception e) {
            c.printerrln((Throwable)e);
        }
    }

    @Override
    public void run(String iURL, File parentfolder, IConsole c) throws Exception {
        this.dbURL = iURL;
        OServerAdmin admin = this.getServerAdmin();
        if (!admin.existsDatabase(this.storageType)) {
            admin.createDatabase(DBTYPE_DOC, this.storageType);
        }
        admin.close();
        super.run(iURL, parentfolder, c);
    }

    @Override
    public void delete() throws Exception {
        this.shutdown();
        OServerAdmin admin = this.getServerAdmin();
        admin.dropDatabase(this.storageType);
        admin.close();
    }

    protected OServerAdmin getServerAdmin() throws Exception {
        OServerAdmin admin = new OServerAdmin(this.dbURL);
        admin.connect(this.rootUsername, this.rootPassword);
        return admin;
    }

    protected OStorage getUnderlyingStorage(OStorage storage) {
        OStorage underlying = storage.getUnderlying();
        if (underlying != storage) {
            return this.getUnderlyingStorage(underlying);
        }
        return underlying;
    }

    public String getRootUsername() {
        return this.rootUsername;
    }

    public void setRootUsername(String rootUsername) {
        this.rootUsername = rootUsername;
    }

    public String getRootPassword() {
        return this.rootPassword;
    }

    public void setRootPassword(String rootPassword) {
        this.rootPassword = rootPassword;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    @Override
    public String getHumanReadableName() {
        return "Remote " + super.getHumanReadableName();
    }

    @Override
    protected boolean exists(ODatabaseDocumentTx db) {
        return true;
    }
}

