/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gmf.internal.xpand.codeassist.XpandTokens;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalComputer;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalFactory;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class KeywordProposalComputer
implements ProposalComputer {
    private final String textPastInsertionPoint;
    private final ProposalFactory proposalFactory;
    private static final Pattern PREFIX = Pattern.compile("([A-Z]+)\\z");

    public KeywordProposalComputer(String textPastInsertionPoint, ProposalFactory factory) {
        this.textPastInsertionPoint = textPastInsertionPoint;
        assert (factory != null);
        this.proposalFactory = factory;
    }

    @Override
    public List<ICompletionProposal> computeProposals(String txt, ExecutionContext ctx) {
        String prefix = this.getPrefix(txt);
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (prefix.length() > 0 || txt.endsWith("\u00ab")) {
            String[] kw;
            boolean needsRT = !this.textPastInsertionPoint.trim().startsWith("\u00bb");
            String[] stringArray = kw = XpandTokens.allKeywords();
            int n = kw.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.toLowerCase().startsWith(prefix.toLowerCase())) {
                    String insertString = string;
                    if (!string.startsWith("END")) {
                        insertString = String.valueOf(insertString) + " ";
                    } else if (needsRT) {
                        insertString = String.valueOf(insertString) + "\u00bb";
                    }
                    result.add(this.proposalFactory.createKeywordProposal(insertString, string, prefix));
                }
                ++n2;
            }
        }
        return result;
    }

    private String getPrefix(String txt) {
        Matcher m = PREFIX.matcher(txt);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }
}

