/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui.dashboard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.bridge.ui.dashboard.DashboardState;
import org.eclipse.gmf.internal.bridge.ui.dashboard.DashboardFigure;
import org.eclipse.gmf.internal.bridge.ui.dashboard.DashboardMediator;
import org.eclipse.gmf.internal.bridge.ui.dashboard.Messages;
import org.eclipse.gmf.internal.bridge.ui.dashboard.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class DashboardPart
extends ViewPart {
    private static final String ACTIVE_PROJECT_KEY = "activeProject";
    private static final String SYNC_SELECTION_KEY = "syncSelection";
    private FigureCanvas canvas;
    private DashboardMediator mediator;
    private ISelectionListener projectUpdater;
    private IProject activeProject;
    private String dashboardInitialProjectName;
    private boolean syncSelection = true;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.dashboardInitialProjectName = memento.getString(ACTIVE_PROJECT_KEY);
            String syncSelectionValue = memento.getString(SYNC_SELECTION_KEY);
            if (syncSelectionValue != null) {
                this.syncSelection = Boolean.valueOf(syncSelectionValue);
            }
        }
        Action syncSelectionAction = new Action(Messages.DashboardPart_Synchronize, 2){};
        syncSelectionAction.setToolTipText(Messages.DashboardPart_SynchronizeSelection);
        ImageDescriptor synchImage = Plugin.getDefault().getImageRegistry().getDescriptor("/icons/cview16/synced.gif");
        if (synchImage != null) {
            syncSelectionAction.setImageDescriptor(synchImage);
        }
        syncSelectionAction.setChecked(this.syncSelection);
        syncSelectionAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty())) {
                    DashboardPart.this.syncSelection = (Boolean)event.getNewValue();
                    if (DashboardPart.this.syncSelection && DashboardPart.this.mediator != null && DashboardPart.this.activeProject != DashboardPart.this.mediator.getProject()) {
                        DashboardPart.this.updateDashboardProject(DashboardPart.this.activeProject);
                    }
                }
            }
        });
        site.getActionBars().getToolBarManager().add((IAction)syncSelectionAction);
    }

    public void createPartControl(Composite parent) {
        IProject dashboardProject;
        this.canvas = new FigureCanvas(parent);
        this.mediator = new DashboardMediator(parent.getShell());
        DashboardFigure contents = new DashboardFigure();
        this.mediator.setView(contents);
        this.canvas.setContents((IFigure)contents);
        this.projectUpdater = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                DashboardPart.this.updateActiveProject(selection);
            }
        };
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.projectUpdater);
        this.updateActiveProject(this.getSite().getWorkbenchWindow().getSelectionService().getSelection());
        if (this.mediator.getProject() == null && this.dashboardInitialProjectName != null && (dashboardProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.dashboardInitialProjectName)).exists()) {
            this.updateDashboardProject(dashboardProject);
        }
        Plugin.getDefault().getDashboardActionRegistry().registerMediator(this.mediator);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.mediator != null && this.mediator.getProject() != null) {
            memento.putString(ACTIVE_PROJECT_KEY, this.mediator.getProject().getName());
            if (!this.syncSelection) {
                memento.putString(SYNC_SELECTION_KEY, String.valueOf(this.syncSelection));
            }
        }
    }

    public void dispose() {
        if (this.mediator != null) {
            Plugin.getDefault().getDashboardActionRegistry().unregisterMediator(this.mediator);
            this.mediator = null;
        }
        if (this.projectUpdater != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.projectUpdater);
            this.projectUpdater = null;
        }
        super.dispose();
    }

    public void setFocus() {
        if (this.canvas != null) {
            this.canvas.setFocus();
        }
    }

    protected void updateActiveProject(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IProject newActiveProject = null;
        for (Object element : (IStructuredSelection)selection) {
            IResource resource;
            IProject project = null;
            if (element instanceof IResource) {
                project = ((IResource)element).getProject();
            } else if (element instanceof IAdaptable && (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null) {
                project = resource.getProject();
            }
            if (project == null) continue;
            if (project.equals((Object)this.activeProject)) {
                return;
            }
            if (newActiveProject != null) continue;
            newActiveProject = project;
        }
        if (newActiveProject != null) {
            this.activeProject = newActiveProject;
            if (this.syncSelection && this.mediator != null) {
                this.updateDashboardProject(newActiveProject);
            }
        }
    }

    protected void updateDashboardProject(IProject project) {
        this.mediator.setProjectAndState(project, new DashboardState(project));
    }
}

