/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.loops;

import java.util.Set;
import org.eclipse.elk.core.options.PortSide;

public enum SelfLoopType {
    ONE_SIDE,
    TWO_SIDES_CORNER,
    TWO_SIDES_OPPOSING,
    THREE_SIDES,
    FOUR_SIDES;


    public static SelfLoopType fromPortSides(Set<PortSide> portSides) {
        if (portSides.contains(PortSide.UNDEFINED)) {
            throw new IllegalArgumentException("Port sides must not contain UNDEFINED");
        }
        switch (portSides.size()) {
            case 1: {
                return ONE_SIDE;
            }
            case 2: {
                boolean northSouth;
                boolean eastWest = portSides.contains(PortSide.EAST) && portSides.contains(PortSide.WEST);
                boolean bl = northSouth = portSides.contains(PortSide.NORTH) && portSides.contains(PortSide.SOUTH);
                if (eastWest || northSouth) {
                    return TWO_SIDES_OPPOSING;
                }
                return TWO_SIDES_CORNER;
            }
            case 3: {
                return THREE_SIDES;
            }
            case 4: {
                return FOUR_SIDES;
            }
        }
        return null;
    }
}

