/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTagElement;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.IDocElement;
import org.eclipse.jdt.core.dom.JavaDocRegion;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.TagProperty;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.internal.core.dom.util.DOMASTUtil;

public final class TagElement
extends AbstractTagElement {
    public static final SimplePropertyDescriptor TAG_NAME_PROPERTY = TagElement.internalTagNamePropertyFactory(TagElement.class);
    public static final ChildListPropertyDescriptor FRAGMENTS_PROPERTY = TagElement.internalFragmentsPropertyFactory(TagElement.class);
    public static final ChildListPropertyDescriptor TAG_PROPERTIES_PROPERTY = new ChildListPropertyDescriptor(TagElement.class, "tagProperties", TagProperty.class, true);
    private static final List PROPERTY_DESCRIPTORS;
    private static final List PROPERTY_DESCRIPTORS_18;
    public static final String TAG_AUTHOR = "@author";
    public static final String TAG_CODE = "@code";
    public static final String TAG_DEPRECATED = "@deprecated";
    public static final String TAG_DOCROOT = "@docRoot";
    public static final String TAG_EXCEPTION = "@exception";
    public static final String TAG_HIDDEN = "@hidden";
    public static final String TAG_INDEX = "@index";
    public static final String TAG_INHERITDOC = "@inheritDoc";
    public static final String TAG_LINK = "@link";
    public static final String TAG_LINKPLAIN = "@linkplain";
    public static final String TAG_LITERAL = "@literal";
    public static final String TAG_PARAM = "@param";
    public static final String TAG_PROVIDES = "@provides";
    public static final String TAG_RETURN = "@return";
    public static final String TAG_SEE = "@see";
    public static final String TAG_SERIAL = "@serial";
    public static final String TAG_SERIALDATA = "@serialData";
    public static final String TAG_SERIALFIELD = "@serialField";
    public static final String TAG_SINCE = "@since";
    public static final String TAG_SUMMARY = "@summary";
    public static final String TAG_THROWS = "@throws";
    public static final String TAG_USES = "@uses";
    public static final String TAG_VALUE = "@value";
    public static final String TAG_VERSION = "@version";
    public static final String TAG_API_NOTE = "@apiNote";
    public static final String TAG_IMPL_SPEC = "@implSpec";
    public static final String TAG_IMPL_NOTE = "@implNote";
    public static final String TAG_SNIPPET = "@snippet";
    public static final String TAG_HIGHLIGHT = "@highlight";
    public static final String TAG_REPLACE = "@replace";
    private ASTNode.NodeList tagProperties = new ASTNode.NodeList(this, TAG_PROPERTIES_PROPERTY);

    static {
        ArrayList propertyList = new ArrayList(3);
        TagElement.createPropertyList(TagElement.class, propertyList);
        TagElement.addProperty(TAG_NAME_PROPERTY, propertyList);
        TagElement.addProperty(FRAGMENTS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = TagElement.reapPropertyList(propertyList);
        propertyList = new ArrayList(4);
        TagElement.createPropertyList(TagElement.class, propertyList);
        TagElement.addProperty(TAG_NAME_PROPERTY, propertyList);
        TagElement.addProperty(FRAGMENTS_PROPERTY, propertyList);
        TagElement.addProperty(TAG_PROPERTIES_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_18 = TagElement.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (DOMASTUtil.isJavaDocCodeSnippetSupported(apiLevel)) {
            return PROPERTY_DESCRIPTORS_18;
        }
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final ChildListPropertyDescriptor internalFragmentsPropertyFactory() {
        return FRAGMENTS_PROPERTY;
    }

    @Override
    final SimplePropertyDescriptor internalTagNamePropertyFactory() {
        return TAG_NAME_PROPERTY;
    }

    TagElement(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return TagElement.propertyDescriptors(apiLevel);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == FRAGMENTS_PROPERTY) {
            return this.fragments();
        }
        if (property == TAG_PROPERTIES_PROPERTY) {
            return this.tagProperties();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 65;
    }

    @Override
    ASTNode clone0(AST target) {
        TagElement result = new TagElement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setTagName(this.getTagName());
        result.fragments().addAll(ASTNode.copySubtrees(target, this.fragments()));
        if (DOMASTUtil.isJavaDocCodeSnippetSupported(target.apiLevel)) {
            result.tagProperties().addAll(ASTNode.copySubtrees(target, this.tagProperties()));
        }
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor, this.fragments);
            if (DOMASTUtil.isJavaDocCodeSnippetSupported(this.getAST().apiLevel)) {
                this.acceptChildren(visitor, this.tagProperties);
            }
        }
        visitor.endVisit(this);
    }

    public List tagProperties() {
        this.unsupportedBelow18();
        return this.tagProperties;
    }

    public List tagRegions() {
        this.unsupportedBelow18();
        ArrayList<JavaDocRegion> regions = new ArrayList<JavaDocRegion>();
        List frags = this.fragments();
        if (frags != null) {
            for (Object fragment : frags) {
                if (!(fragment instanceof JavaDocRegion) || ((JavaDocRegion)fragment).isDummyRegion()) continue;
                regions.add((JavaDocRegion)fragment);
            }
        }
        return regions;
    }

    public List tagRegionsContainingTextElement(ASTNode docElem) {
        this.unsupportedBelow18();
        ArrayList<JavaDocRegion> regions = new ArrayList<JavaDocRegion>();
        if (docElem == null || !(docElem instanceof IDocElement)) {
            return regions;
        }
        int textElemStart = docElem.getStartPosition();
        int textElemEnd = textElemStart + docElem.getLength();
        List javaDocRegions = this.tagRegions();
        for (JavaDocRegion region : javaDocRegions) {
            int regionStart = region.getStartPosition();
            int regionEnd = regionStart + region.getLength();
            if (regionStart > textElemStart || regionEnd < textElemEnd) continue;
            regions.add(region);
        }
        return regions;
    }

    public List tagRegionsStartingAtTextElement(ASTNode docElem) {
        this.unsupportedBelow18();
        ArrayList<JavaDocRegion> regions = new ArrayList<JavaDocRegion>();
        if (docElem == null || !(docElem instanceof TextElement)) {
            return regions;
        }
        TextElement textElem = (TextElement)docElem;
        List javaDocRegions = this.tagRegions();
        for (JavaDocRegion region : javaDocRegions) {
            Object textObj;
            if (region.isDummyRegion() || !textElem.equals(textObj = region.getProperty("SnippetRegionTextElement"))) continue;
            regions.add(region);
        }
        return regions;
    }

    @Override
    int memSize() {
        return super.memSize();
    }

    @Override
    int treeSize() {
        return this.memSize() + (DOMASTUtil.isJavaDocCodeSnippetSupported(this.getAST().apiLevel) ? this.tagProperties.listSize() : 0);
    }
}

