/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MyBufferedWriter.java 69257 2012-12-20 15:38:14Z adf $
 */

package com.sun.ts.tests.jsonp.common;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import java.io.*;

// A wrapper class to BufferedWriter class used to inject IOException errors
// when the throwIOException instance variable is set. All methods delegate
// to the parent super class and check whether or not to throw an IOException
// before delegation.

public class MyBufferedWriter extends BufferedWriter {

  private boolean throwIOException;

  public MyBufferedWriter(Writer out) {
	super(out);
  }

  public MyBufferedWriter(Writer out, int sz) {
	super(out, sz);
  }

  public MyBufferedWriter(Writer out, int sz, boolean throwIOException) {
	super(out, sz);
	this.throwIOException = throwIOException;
  }

  private void checkToTripIOException() throws IOException {
	if (throwIOException) {
	    TestUtil.logMsg("*** tripping an IOException ***");
	    throw new IOException("tripping an IOException");
	}
  }

  public void setThrowIOException(boolean throwIOException) {
	this.throwIOException = throwIOException;
  }

  public void write(int c) throws IOException {
	checkToTripIOException();
	super.write(c);
  }

  public void write(char[] cbuf) throws IOException {
	checkToTripIOException();
	super.write(cbuf);
  }

  public void write(char[] cbuf, int offset, int length) throws IOException {
	checkToTripIOException();
	super.write(cbuf, offset, length);
  }

  public void write(String str) throws IOException {
	checkToTripIOException();
	super.write(str);
  }

  public void write(String str, int offset, int length) throws IOException {
	checkToTripIOException();
	super.write(str, offset, length);
  }

  public void close() throws IOException {
	checkToTripIOException();
	super.close();
  }

  public void flush() throws IOException {
	checkToTripIOException();
	super.flush();
  }
}
