/*
 * Copyright (c) 2016 Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jsonp.api.jsonarraytests;

import javax.json.JsonArrayBuilder;
import javax.json.JsonValue;

import static com.sun.ts.tests.jsonp.api.common.JsonAssert.*;

// $Id: ArrayCommon.java 74752 2016-12-16 14:37:56Z tkraus $
/**
 * JavaScript Object Notation (JSON) compatibility tests for {@link JsonArray} and {@link JsonArrayBuilder}.
 */
public abstract class ArrayCommon {
    
    /**
     * Create and initialize array builder to contain single value.
     * Child class callback.
     * @param value JSON value stored in the builder. Value of {@code null} is stored as JSON {@code null} keyword.
     * @return JSON array builder containing value.
     */
    protected abstract JsonArrayBuilder createArrayBuilder(
            final Object value
    );

    /**
     * Create and initialize array builder to contain single value.
     * Child class callback.
     * @param index Position in the array where value is added.
     * @param value JSON value stored in the builder. Value of {@code null} is stored as JSON {@code null} keyword.
     * @return JSON array builder containing value.
     */
    protected abstract JsonArrayBuilder createArrayBuilder(
            final int index,
            final Object value
    );

    /**
     * Update array builder to contain next value.
     * Child class callback.
     * @param builder JSON array builder to update.
     * @param value JSON value stored in the builder. Value of {@code null} is stored as JSON {@code null} keyword.
     * @return JSON array builder with value updated.
     */
    protected abstract JsonArrayBuilder updateOperationBuilder(
            final JsonArrayBuilder builder,
            final Object value
    );

    /**
     * Update array builder to contain next value.
     * Child class callback.
     * @param builder JSON array builder to update.
     * @param index Position in the array where value is added.
     * @param value JSON value stored in the builder. Value of {@code null} is stored as JSON {@code null} keyword.
     * @return JSON array builder with value updated.
     */
    protected abstract JsonArrayBuilder updateOperationBuilder(
            final JsonArrayBuilder builder,
            final int index,
            final Object value
    );

    /**
     * Operation result check.
     * @param check Expected modified JSON value.
     * @param out Operation output.
     * @return Value of {@code true} if operation passed or {@code false} otherwise.
     */
    protected boolean operationFailed(final JsonValue check, final JsonValue out) {
        return out == null || !assertEquals(check, out);
    }

}
