/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.enterprise.util.ApplicationClientPropertiesFileConverter;
import com.sun.enterprise.util.PropsToXmlConverter;
import com.sun.enterprise.util.WebPropertiesFileConverter;
import java.io.File;

public class Props2Xml {
    private File descriptorDirectory;
    private File generatedFilesDirectory;
    String[] descriptors;
    private String name;

    public static void main(String[] args) throws Exception {
        Props2Xml helper = new Props2Xml(args);
        helper.process();
    }

    private Props2Xml(String[] args) {
        int index = 0;
        this.descriptorDirectory = new File(args[index++]);
        this.generatedFilesDirectory = new File(args[index++]);
        this.name = args[index++];
        this.descriptors = new String[args.length - index];
        int i = 0;
        while (index < args.length) {
            this.descriptors[i] = args[index++];
            ++i;
        }
    }

    private void process() throws Exception {
        for (int i = 0; i < this.descriptors.length; ++i) {
            String[] args;
            String descriptorName = this.descriptors[i];
            File descriptorFile = new File(this.descriptorDirectory, descriptorName);
            int extIndex = descriptorName.lastIndexOf(".");
            String xmlName = this.name + ".xml";
            String runtimeXmlName = this.name + ".runtime.xml";
            String descNameMinusExt = descriptorName;
            File xmlFile = null;
            if (descriptorName.endsWith(".props")) {
                xmlName = this.name + "_ejb.xml";
                runtimeXmlName = this.name + "_ejb.runtime.xml";
                descNameMinusExt = descriptorName;
                xmlFile = new File(this.generatedFilesDirectory, xmlName);
                if (xmlFile.exists() && xmlFile.lastModified() >= descriptorFile.lastModified()) continue;
                System.out.println("calling ejb props converter!");
                args = new String[]{descriptorFile.getPath(), this.generatedFilesDirectory.getPath(), this.generatedFilesDirectory.getPath() + File.separator + descriptorName + ".xml", this.generatedFilesDirectory.getPath() + File.separator + xmlName, this.generatedFilesDirectory.getPath() + File.separator + runtimeXmlName};
                try {
                    PropsToXmlConverter.main((String[])args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (descriptorName.endsWith(".webprops")) {
                xmlName = this.name + "_web.xml";
                runtimeXmlName = this.name + "_web.runtime.xml";
                descNameMinusExt = descriptorName;
                xmlFile = new File(this.generatedFilesDirectory, xmlName);
                if (xmlFile.exists() && xmlFile.lastModified() >= descriptorFile.lastModified()) continue;
                System.out.println("calling web props converter!");
                args = new String[]{descriptorFile.getPath(), this.generatedFilesDirectory + File.separator + xmlName, this.generatedFilesDirectory + File.separator + runtimeXmlName};
                try {
                    WebPropertiesFileConverter.main((String[])args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!descriptorName.endsWith(".cprops")) continue;
            xmlName = this.name + "_client.xml";
            runtimeXmlName = this.name + "_client.runtime.xml";
            descNameMinusExt = descriptorName;
            xmlFile = new File(this.generatedFilesDirectory, xmlName);
            if (xmlFile.exists() && xmlFile.lastModified() >= descriptorFile.lastModified()) continue;
            System.out.println("calling appclient props converter!");
            System.out.println(descriptorFile.getPath() + "," + this.generatedFilesDirectory + File.separator + xmlName + "," + this.generatedFilesDirectory + File.separator + runtimeXmlName);
            args = new String[]{descriptorFile.getPath(), this.generatedFilesDirectory + File.separator + xmlName, this.generatedFilesDirectory + File.separator + runtimeXmlName};
            try {
                ApplicationClientPropertiesFileConverter.main((String[])args);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

