/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.deliverable.cts.deploy;

import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyNotSetException;
import com.sun.ts.lib.deliverable.cts.deploy.StandardDeployment14;
import com.sun.ts.lib.deliverable.cts.deploy.StandardDeployment14ServerInterface;
import com.sun.ts.lib.porting.DeploymentInfo;
import com.sun.ts.lib.porting.TSDeployment;
import com.sun.ts.lib.porting.TSDeployment2;
import com.sun.ts.lib.porting.TSDeploymentException;
import com.sun.ts.lib.porting.TSDeploymentInterface;
import com.sun.ts.lib.util.TestUtil;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class StandardDeployment14SeparateVM
extends StandardDeployment14
implements TSDeploymentInterface {
    private StandardDeployment14ServerInterface deploymentServer = null;
    private Map extraParameters = new HashMap();

    @Override
    public void init(PrintWriter out) {
        try {
            TestUtil.logHarnessDebug((String)"StandardDeployment14SeparateVM:  in init");
            this.iPortingSet = TSDeployment.iPortingSet;
            this.extraParameters.put("porting_set", new Integer(this.iPortingSet));
            TestUtil.logHarness((String)("StandardDeployment14:  Using porting set #" + this.iPortingSet));
            String portingString = String.valueOf(this.iPortingSet);
            this.log = out;
            this.propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
            String portClass = "porting.ts.deploy2.class." + this.iPortingSet;
            TestUtil.logHarness((String)("Using " + portClass));
            this.dep2 = TSDeployment2.getDeploymentInstance(this.log, portClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getDeploymentServer() throws TSDeploymentException {
        String sHost = "";
        String sPort = "2002";
        try {
            sHost = InetAddress.getLocalHost().getHostName();
            try {
                sPort = this.propMgr.getProperty("harness.deployment.server.port");
                TestUtil.logHarnessDebug((String)("harness.deployment.server.port = " + sPort));
            }
            catch (PropertyNotSetException pe) {
                this.log.print(pe.getMessage());
                this.log.print("error looking up property:  sun.porting_server.port");
                this.log.print("Defaulting to port #:  " + sPort);
            }
            this.deploymentServer = (StandardDeployment14ServerInterface)Naming.lookup("rmi://" + sHost + ":" + sPort + "/StandardDeployment14Server");
            this.deploymentServer.init(this.propMgr.getJteProperties(), this.extraParameters);
        }
        catch (MalformedURLException me) {
            this.log.print(me.getMessage());
            me.printStackTrace();
            throw new TSDeploymentException(me.getMessage(), (Throwable)me);
        }
        catch (UnknownHostException ue) {
            this.log.print(ue.getMessage());
            this.log.print("unknown host:  " + sHost);
            ue.printStackTrace();
            throw new TSDeploymentException(ue.getMessage(), (Throwable)ue);
        }
        catch (NotBoundException nbe) {
            this.log.print(nbe.getMessage());
            nbe.printStackTrace();
            throw new TSDeploymentException(nbe.getMessage(), (Throwable)nbe);
        }
        catch (RemoteException e) {
            TestUtil.logHarness((String)("Failed to deploy using StandardDeploymentServer: " + e.getMessage()));
            e.printStackTrace();
            throw new TSDeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String deploy(DeploymentInfo info) throws TSDeploymentException {
        String classpath = null;
        try {
            if (this.deploymentServer == null) {
                this.getDeploymentServer();
            }
            classpath = this.deploymentServer.deploy(info);
        }
        catch (RemoteException e) {
            TestUtil.logHarness((String)("Failed to deploy using StandardDeploymentServer:  " + e.getMessage()));
            e.printStackTrace();
            throw new TSDeploymentException(e.getMessage());
        }
        return classpath;
    }

    @Override
    public boolean isDeployed(Properties p) throws TSDeploymentException {
        boolean bIsInstalled = false;
        try {
            if (this.deploymentServer == null) {
                this.getDeploymentServer();
            }
            bIsInstalled = this.deploymentServer.isDeployed(p);
        }
        catch (RemoteException e) {
            TestUtil.logHarness((String)("Failed to check if app was deployed usingStandardDeploymentServer:  " + e.getMessage()));
            e.printStackTrace();
            throw new TSDeploymentException(e.getMessage());
        }
        return bIsInstalled;
    }

    @Override
    public void undeploy(Properties p) throws TSDeploymentException {
        try {
            if (this.deploymentServer == null) {
                this.getDeploymentServer();
            }
            this.deploymentServer.undeploy(p);
        }
        catch (RemoteException e) {
            TestUtil.logHarness((String)("Failed to undepoy using StandardDeploymentServer:  " + e.getMessage()));
            e.printStackTrace();
            throw new TSDeploymentException(e.getMessage());
        }
    }
}

