/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.ee.resources;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgi.ee.resources.Habitat;
import org.glassfish.osgi.ee.resources.Invalidate;
import org.glassfish.osgi.ee.resources.ResourceHelper;
import org.glassfish.osgi.ee.resources.ResourceProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class BaseResourceManager {
    private Habitat habitat;
    protected List<ServiceRegistration> services = new ArrayList<ServiceRegistration>();
    protected static final Logger logger = Logger.getLogger(BaseResourceManager.class.getPackage().getName());
    protected ResourceHelper resourceHelper;

    public BaseResourceManager(Habitat habitat) {
        this.habitat = habitat;
        this.resourceHelper = new ResourceHelper(habitat);
    }

    protected void unRegisterResource(ServiceRegistration serviceRegistration, BundleContext context) {
        this.debug("unregistering resource [" + serviceRegistration.getReference().getProperty("jndi-name") + "]");
        Invalidate proxy = (Invalidate)serviceRegistration.getReference().getBundle().getBundleContext().getService(serviceRegistration.getReference());
        serviceRegistration.unregister();
        proxy.invalidate();
    }

    public void unRegisterResource(BindableResource resource, ResourceRef resRef, BundleContext bundleContext) {
        String jndiName = resource.getJndiName();
        ServiceRegistration toRemove = null;
        for (ServiceRegistration serviceRegistration : this.services) {
            if (!serviceRegistration.getReference().getProperty("jndi-name").equals(jndiName)) continue;
            this.unRegisterResource(serviceRegistration, bundleContext);
            toRemove = serviceRegistration;
            break;
        }
        if (toRemove != null) {
            this.services.remove(toRemove);
        }
    }

    public void unRegisterResources(BundleContext context) {
        Iterator<ServiceRegistration> it = this.services.iterator();
        while (it.hasNext()) {
            ServiceRegistration serviceRegistration = it.next();
            this.unRegisterResource(serviceRegistration, context);
            it.remove();
        }
    }

    protected Habitat getHabitat() {
        return this.habitat;
    }

    protected Resources getResources() {
        return this.habitat.getComponent(Domain.class).getResources();
    }

    protected ResourceHelper getResourceHelper() {
        return this.resourceHelper;
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected void registerResourceAsService(BundleContext bundleContext, BindableResource bindableResource, String name, Dictionary properties, Object o) {
        ServiceRegistration service = bundleContext.registerService(name, o, properties);
        this.debug("registering resource [" + bindableResource.getJndiName() + "]");
        this.services.add(service);
    }

    protected Object getProxy(String jndiName, Class[] ifaces, ClassLoader loader) {
        ResourceProxy proxy = new ResourceProxy(jndiName);
        return Proxy.newProxyInstance(loader, ifaces, (InvocationHandler)proxy);
    }

    protected void debug(String s) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[osgi-ee-resources] : " + s);
        }
    }
}

