/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.deliverable.cts.deploy;

import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.deliverable.cts.deploy.DMProps;
import com.sun.ts.lib.deliverable.cts.deploy.DeployTestUtil;
import com.sun.ts.lib.deliverable.cts.deploy.OperationStatus;
import com.sun.ts.lib.harness.ExecutionMode;
import com.sun.ts.lib.implementation.sun.javaee.runtime.SunRIDeploymentInfo;
import com.sun.ts.lib.porting.DeploymentInfo;
import com.sun.ts.lib.porting.TSDeployment;
import com.sun.ts.lib.porting.TSDeployment2;
import com.sun.ts.lib.porting.TSDeploymentException;
import com.sun.ts.lib.porting.TSDeploymentInterface;
import com.sun.ts.lib.porting.TSDeploymentInterface2;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;

public class StandardDeployment14
implements TSDeploymentInterface {
    protected static final String DEPLOYED_MODULES_FILE = "ts-deployed-modules";
    protected static String TEMP_DIR;
    protected PrintWriter log;
    protected int iPortingSet = 1;
    private String url = "deployer:???:???:999";
    private DeploymentManager depMgr;
    private DeployTestUtil dtu;
    private DMProps dmProps;
    protected TSDeploymentInterface2 dep2;
    protected Hashtable htDeployedModules = new Hashtable();
    protected PropertyManagerInterface propMgr;
    protected String sDepNumber = null;
    protected String deployStateFile;

    public void init(PrintWriter writer) {
        this.log = writer;
        TestUtil.logHarness((String)"StandardDeployment14.init()");
        this.iPortingSet = TSDeployment.iPortingSet;
        TestUtil.logHarness((String)("StandardDeployment14:  Using porting set #" + this.iPortingSet));
        try {
            this.propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
            try {
                String portingString = String.valueOf(this.iPortingSet);
                this.initDeployTestUtils(portingString);
                this.deployStateFile = TEMP_DIR + File.separator + DEPLOYED_MODULES_FILE + "_" + portingString + ".ser";
            }
            catch (TSDeploymentException e) {
                TestUtil.logHarness((String)"Unable to initialize the deployment utilities.");
            }
            this.htDeployedModules = this.getDeployedModules();
            this.dumpDeployedMods(this.htDeployedModules);
            TestUtil.logHarnessDebug((String)"Adding shutdown hook for state serialization");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    int harnessExecMode = ExecutionMode.getExecutionMode((PropertyManagerInterface)StandardDeployment14.this.propMgr);
                    if (harnessExecMode == 1 || harnessExecMode == 4) {
                        try {
                            TestUtil.logHarness((String)"IN SHUTDOWN HOOK BEFORE WRITE");
                            StandardDeployment14.this.dumpDeployedMods(StandardDeployment14.this.htDeployedModules);
                            StandardDeployment14.this.writeMap(StandardDeployment14.this.htDeployedModules);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        return;
                    }
                    if (harnessExecMode == 2) {
                        return;
                    }
                    TestUtil.logHarness((String)("IN SHUTDOWNHOOK state file is : \"" + StandardDeployment14.this.deployStateFile + "\""));
                    StandardDeployment14.this.dumpDeployedMods(StandardDeployment14.this.htDeployedModules);
                    Map deployedModules = (Map)StandardDeployment14.this.htDeployedModules.clone();
                    if (deployedModules.size() != 0) {
                        TestUtil.logHarness((String)"Shutdown requested during test run.  Undeploying previously deployed applications...");
                        try {
                            StandardDeployment14.this.initDeployTestUtils(StandardDeployment14.this.sDepNumber);
                        }
                        catch (TSDeploymentException e) {
                            TestUtil.logHarness((String)"Unable to initialize the deployment utilities.  Applications will not be undeployed.");
                        }
                        Iterator i = deployedModules.keySet().iterator();
                        while (i.hasNext()) {
                            try {
                                StandardDeployment14.this.undeploy((String)i.next());
                            }
                            catch (TSDeploymentException tde) {
                                TestUtil.logHarness((String)("Unexpected exception while undeploying application during shutdown. Cause: " + tde.getMessage()));
                            }
                        }
                        StandardDeployment14.this.dtu.releaseDeploymentManager();
                        StandardDeployment14.this.deleteDeployedModulesState();
                    }
                }
            });
            String portClass = "porting.ts.deploy2.class." + this.iPortingSet;
            TestUtil.logHarness((String)("Using " + portClass));
            this.dep2 = TSDeployment2.getDeploymentInstance(this.log, portClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.logHarness((String)"Creation of TSDeployment2 implementation instance failed. Please check the values of 'porting.ts.deploy2.class.1' and 'porting.ts.deploy2.class.2'");
        }
    }

    public String deploy(DeploymentInfo info) throws TSDeploymentException {
        try {
            String javaeeLevel;
            Properties p;
            OperationStatus status;
            String sArchive = info.getEarFile();
            String[] sRunTimeFileArray = info.getRuntimeFiles();
            TestUtil.logHarness((String)"StandardDeployment14.deploy()");
            this.sDepNumber = info.getProperty("deployment.props.number");
            this.initDeployTestUtils(this.sDepNumber);
            TestUtil.logHarness((String)("Starting to distribute:  " + sArchive));
            File earfile = new File(sArchive);
            Object plan = this.dep2.getDeploymentPlan(info);
            TestUtil.logHarness((String)("file: " + earfile.toString()));
            if (plan != null) {
                TestUtil.logHarness((String)("plan: " + plan.toString()));
            } else {
                TestUtil.logHarness((String)"No deployment plan for this archive.");
            }
            Target[] targets = this.dep2.getTargetsToUse(this.dtu.getTargets(), info);
            if (targets == null || targets.length == 0) {
                throw new TSDeploymentException("Empty Target List: ");
            }
            if (plan instanceof InputStream) {
                status = this.dtu.distributeModuleStreams(targets, new FileInputStream(earfile), (InputStream)plan);
            } else if (plan instanceof File || plan == null) {
                status = this.dtu.distributeModuleFiles(targets, earfile, (File)plan);
            } else {
                throw new TSDeploymentException("Object returned from getDeploymentPlan must return either an InputStream or a File.  May also be null in some cases like connectors.");
            }
            if (status.isFailed()) {
                throw new TSDeploymentException("Distribute to one or more targets failed " + status.errMessage());
            }
            TestUtil.logHarness((String)("$$$$$$$$$$ Deployment SUCCEEDED for \"" + earfile + "\""));
            this.dep2.postDistribute(status.getProgressObject());
            status = this.dtu.startModule(status.getDeployedTargetIDs());
            if (status.isFailed()) {
                throw new TSDeploymentException("Starting of module failed on one or more targets " + status.errMessage());
            }
            this.dep2.postStart(status.getProgressObject());
            this.htDeployedModules.put(StandardDeployment14.getAppName(sArchive), status.getDeployedTargetIDs());
            if (sArchive.indexOf("connector" + File.separator + "deployment" + File.separator + "ejb_Deployment.ear") != -1) {
                p = new Properties();
                p.setProperty("rar_file", sArchive);
                this.dep2.createConnectionFactory(status.getDeployedTargetIDs(), p);
            }
            if (sArchive.indexOf("xa" + File.separator + "ee" + File.separator + "tsr" + File.separator + "ejb_Tsr.ear") != -1) {
                p = new Properties();
                p.setProperty("rar_file", sArchive);
                this.dep2.createConnectionFactory(status.getDeployedTargetIDs(), p);
            }
            if ((javaeeLevel = this.propMgr.getProperty("javaee.level", "full")).contains("full") && !sArchive.endsWith(".rar")) {
                return this.dep2.getClientClassPath(status.getDeployedTargetIDs(), info, this.dtu.getDeploymentManager());
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (TSDeploymentException)new TSDeploymentException("Deployment Failed.").initCause((Throwable)e);
        }
    }

    public void undeploy(String moduleId) throws TSDeploymentException {
        ModuleType moduleType = StandardDeployment14.getModuleType(moduleId);
        TargetModuleID[] idsToUndeploy = (TargetModuleID[])this.htDeployedModules.get(StandardDeployment14.getAppName(moduleId));
        TestUtil.logHarnessDebug((String)("$$$$$$$$$$$$$ idsToUndeploy.length = " + idsToUndeploy.length));
        TestUtil.logHarnessDebug((String)("$$$$$$$$$$$$$ Undeploying Module ID \"" + idsToUndeploy[0].getModuleID() + "\""));
        if (idsToUndeploy == null) {
            TestUtil.logHarness((String)"idToUndeploy is null.  Assuming that the module is not currently deployed");
            return;
        }
        TestUtil.logHarness((String)("Undeploying module \"" + moduleId + "\""));
        OperationStatus status = null;
        try {
            status = this.dtu.stopModule(idsToUndeploy);
            if (status.isFailed()) {
                TestUtil.logHarness((String)("Stop failed for one or more targets while undeploying module \"" + moduleId + "\""));
            }
            this.dep2.postStop(status.getProgressObject());
            status = this.dtu.undeployModule(idsToUndeploy);
            if (status.isFailed()) {
                TestUtil.logHarness((String)("Undeploy failed for one or more targets \"" + status.errMessage() + "\""));
            }
            this.dep2.postUndeploy(status.getProgressObject());
            this.htDeployedModules.remove(StandardDeployment14.getAppName(moduleId));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TSDeploymentException("Error while undeploying");
        }
        if (status.isFailed()) {
            throw new TSDeploymentException("Undeploy failed for one or more targets \"" + status.errMessage() + "\"");
        }
    }

    public void undeploy(Properties p) throws TSDeploymentException {
        String sArchive = p.getProperty("ear_file");
        TestUtil.logHarness((String)"StandardDeployment14.undeploy()");
        this.initDeployTestUtils(p.getProperty("deployment.props.number"));
        if (sArchive.indexOf("connector" + File.separator + "deployment" + File.separator + "ejb_Deployment.ear") != -1 || sArchive.indexOf("xa" + File.separator + "ee" + File.separator + "tsr" + File.separator + "ejb_Tsr.ear") != -1) {
            p.setProperty("rar_file", sArchive);
            TargetModuleID[] modulesToUndeploy = (TargetModuleID[])this.htDeployedModules.get(StandardDeployment14.getAppName(sArchive));
            if (modulesToUndeploy.length == 0) {
                TestUtil.logHarness((String)("undeploy failed for application \"" + sArchive + "\""));
                throw new TSDeploymentException("undeploy failed for application \"" + sArchive + "\"");
            }
            this.dep2.removeConnectionFactory(modulesToUndeploy, p);
        }
        this.undeploy(sArchive);
    }

    public boolean isDeployed(Properties p) throws TSDeploymentException {
        TestUtil.logHarness((String)"StandardDeployment14.isDeployed()");
        String sArchive = p.getProperty("ear_file");
        String sAppName = StandardDeployment14.getAppName(sArchive);
        if (this.htDeployedModules == null) {
            return false;
        }
        try {
            this.normalizeMap(this.getTargets());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TargetModuleID[] id = (TargetModuleID[])this.htDeployedModules.get(sAppName);
        if (id != null && id.length > 0) {
            TestUtil.logHarnessDebug((String)("StandardDeployment14.isDeployed():  After checking hashtable, id = " + sAppName));
            return true;
        }
        TestUtil.logHarnessDebug((String)"StandardDeployment14.isDeployed():  After checking hashtable, id = null");
        return false;
    }

    public void deployConnector(Properties p) throws TSDeploymentException {
        TestUtil.logHarness((String)"StandardDeployment14.deployConnector()");
        String sRarFileName = p.getProperty("rar_file");
        SunRIDeploymentInfo info = null;
        try {
            info = new SunRIDeploymentInfo(sRarFileName, new String[0]);
            info.setProperty("deployment.props.number", p.getProperty("deployment.props.number"));
            this.deploy(info);
            TargetModuleID[] targets = (TargetModuleID[])this.htDeployedModules.get(StandardDeployment14.getAppName(sRarFileName));
            this.dep2.createConnectionFactory(targets, p);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TSDeploymentException("Error while deploying Connector");
        }
    }

    public void undeployConnector(Properties p) throws TSDeploymentException {
        TestUtil.logHarness((String)"StandardDeployment14.undeployConnector()");
        if (this.isConnectorDeployed(p)) {
            String rarFile = p.getProperty("rar_file");
            TargetModuleID[] targets = (TargetModuleID[])this.htDeployedModules.get(StandardDeployment14.getAppName(rarFile));
            this.dep2.removeConnectionFactory(targets, p);
            p.setProperty("ear_file", rarFile);
            this.undeploy(p);
        } else {
            TestUtil.logHarness((String)"StandardDeployment14.undeployConnector() - not undeploying.");
        }
    }

    public boolean isConnectorDeployed(Properties p) throws TSDeploymentException {
        TestUtil.logHarness((String)"StandardDeployment14.isConnectorDeployed()");
        p.setProperty("ear_file", p.getProperty("rar_file"));
        return this.isDeployed(p);
    }

    protected void initDeployTestUtils(String sPropNum) throws TSDeploymentException {
        try {
            if (this.dtu != null) {
                return;
            }
            String sJar = this.propMgr.getProperty("deployManagerJarFile." + sPropNum);
            String sUri = this.propMgr.getProperty("deployManageruri." + sPropNum);
            String sUname = this.propMgr.getProperty("deployManageruname." + sPropNum);
            String sPassword = this.propMgr.getProperty("deployManagerpasswd." + sPropNum);
            TestUtil.logHarnessDebug((String)("StandardDeployment14.initDeployTestUtils() + sPropNum = " + sPropNum));
            TestUtil.logHarnessDebug((String)("deployManagerJarFile:  " + sJar));
            TestUtil.logHarnessDebug((String)("deployManageruri:  " + sUri));
            TestUtil.logHarnessDebug((String)("deployManageruname:  " + sUname));
            TestUtil.logHarnessDebug((String)("deployManagerpasswd:  " + sPassword));
            this.dmProps = new DMProps(sJar, sUri, sUname, sPassword);
            this.dtu = new DeployTestUtil(this.dmProps);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TSDeploymentException("Failed to get DeployTestUtil: " + e.getMessage());
        }
        try {
            this.depMgr = this.dtu.getDeploymentManager();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.logHarness((String)("Exception loading DeploymentFactoryManager factories: " + e));
            throw new TSDeploymentException("Unable to get DeploymentManager: " + e.getMessage());
        }
    }

    public String getAppClientArgs(Properties p) {
        return this.dep2.getAppClientArgs(p);
    }

    public Hashtable getInteropJNDINames(DeploymentInfo[] infoArray) {
        return this.dep2.getDependentValues(infoArray);
    }

    private static ModuleType getModuleType(String sArchive) {
        String sExtension = sArchive.substring(sArchive.lastIndexOf(".") + 1);
        ModuleType mt = sExtension.equalsIgnoreCase("ear") ? ModuleType.EAR : (sExtension.equalsIgnoreCase("rar") ? ModuleType.RAR : (sExtension.equalsIgnoreCase("jar") ? (sArchive.indexOf("component") != -1 ? ModuleType.EJB : ModuleType.EJB) : (sExtension.equalsIgnoreCase("war") ? ModuleType.WAR : ModuleType.EAR)));
        return mt;
    }

    protected static String getAppName(String path) {
        return path.substring(path.lastIndexOf(File.separator) + 1);
    }

    protected void dumpDeployedMods(Hashtable map) {
        StringBuffer message = new StringBuffer("Deployed Modules: \n");
        if (map == null || map.keySet() == null) {
            TestUtil.logHarness((String)"There are no deployed modules, returning");
            return;
        }
        for (String modName : map.keySet()) {
            message.append("\t" + modName + "\n");
        }
        TestUtil.logHarness((String)message.toString());
    }

    protected boolean isValidTargetID(TargetModuleID targModID, SerializableTargetID[] serTargModIDs) {
        boolean result = false;
        SerializableTargetID test = new SerializableTargetID(targModID);
        for (int i = 0; i < serTargModIDs.length; ++i) {
            if (!serTargModIDs[i].equals(test)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean isValidTargetID(TargetModuleID targModID, TargetModuleID[] serTargModIDs) {
        boolean result = false;
        for (int i = 0; i < serTargModIDs.length; ++i) {
            if (!serTargModIDs[i].equals(targModID)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected TargetModuleID[] getRunningTargetModuleIDs(String sModuleName, Target[] targets) throws Exception {
        return this.depMgr.getRunningModules(StandardDeployment14.getModuleType(sModuleName), targets);
    }

    protected void normalizeMap(Target[] targets) throws Exception {
        ArrayList<TargetModuleID> targModIDsList = null;
        TestUtil.logHarnessDebug((String)"Target[]");
        for (int i = 0; i < targets.length; ++i) {
            TestUtil.logHarnessDebug((String)("[" + targets[i].getDescription() + ", " + targets[i].getName() + "]"));
        }
        Hashtable<String, TargetModuleID[]> result = new Hashtable<String, TargetModuleID[]>();
        for (String modName : this.htDeployedModules.keySet()) {
            int i;
            TargetModuleID[] targModIDs = this.getRunningTargetModuleIDs(modName, targets);
            if (targModIDs == null || targModIDs.length == 0) continue;
            TestUtil.logHarnessDebug((String)("****** Module name = \"" + modName + "\""));
            TestUtil.logHarnessDebug((String)("****** targModIDs.length = " + targModIDs.length));
            TestUtil.logHarnessDebug((String)"TargetModuleID[]");
            for (int i2 = 0; i2 < targModIDs.length; ++i2) {
                TestUtil.logHarnessDebug((String)("[" + targModIDs[i2].getModuleID() + ", " + targModIDs[i2].getTarget().getDescription() + ", " + targModIDs[i2].getTarget().getName() + "]"));
            }
            TargetModuleID[] savedIDs = (TargetModuleID[])this.htDeployedModules.get(modName);
            TestUtil.logHarnessDebug((String)("****** savedIDs.length = " + savedIDs.length));
            TestUtil.logHarnessDebug((String)"TargetModuleID[]");
            for (i = 0; i < savedIDs.length; ++i) {
                TestUtil.logHarnessDebug((String)("[" + savedIDs[i].getModuleID() + "]"));
            }
            targModIDsList = new ArrayList<TargetModuleID>();
            for (i = 0; i < targModIDs.length; ++i) {
                if (!this.isValidTargetID(targModIDs[i], savedIDs)) continue;
                TestUtil.logHarnessDebug((String)("&&&&&&&& Adding = " + targModIDs[i].getModuleID()));
                targModIDsList.add(targModIDs[i]);
                TestUtil.logHarnessDebug((String)("&&&&&&&& targModIDsList.size() is " + targModIDsList.size()));
                break;
            }
            if (targModIDsList.size() > 0) {
                TargetModuleID[] validSavedIDs = targModIDsList.toArray(new TargetModuleID[targModIDsList.size()]);
                result.put(modName, validSavedIDs);
                continue;
            }
            TestUtil.logHarnessDebug((String)("$$$$$ We did not find any valid IDs :  " + modName));
        }
        TestUtil.logHarnessDebug((String)"DUMP OF RESULT");
        this.dumpDeployedMods(result);
        TestUtil.logHarnessDebug((String)"END DUMP OF RESULT END");
        this.htDeployedModules = result;
    }

    protected Hashtable normalizeMap(Hashtable map, Target[] targets) throws Exception {
        ArrayList<TargetModuleID> targModIDsList = null;
        TestUtil.logHarnessDebug((String)"Target[]");
        for (int i = 0; i < targets.length; ++i) {
            TestUtil.logHarnessDebug((String)("[" + targets[i].getDescription() + ", " + targets[i].getName() + "]"));
        }
        Hashtable<String, TargetModuleID[]> result = new Hashtable<String, TargetModuleID[]>();
        for (String modName : map.keySet()) {
            int i;
            TargetModuleID[] targModIDs = this.getRunningTargetModuleIDs(modName, targets);
            if (targModIDs == null || targModIDs.length == 0) continue;
            TestUtil.logHarnessDebug((String)("****** Module name = \"" + modName + "\""));
            TestUtil.logHarnessDebug((String)("****** targModIDs.length = " + targModIDs.length));
            TestUtil.logHarnessDebug((String)"TargetModuleID[]");
            for (int i2 = 0; i2 < targModIDs.length; ++i2) {
                TestUtil.logHarnessDebug((String)("[" + targModIDs[i2].getModuleID() + ", " + targModIDs[i2].getTarget().getDescription() + ", " + targModIDs[i2].getTarget().getName() + "]"));
            }
            SerializableTargetID[] serIDs = (SerializableTargetID[])map.get(modName);
            TestUtil.logHarnessDebug((String)("****** serIDs.length = " + serIDs.length));
            TestUtil.logHarnessDebug((String)"SerializableTargetModuleID[]");
            for (i = 0; i < serIDs.length; ++i) {
                TestUtil.logHarnessDebug((String)("[" + serIDs[i].getModuleID() + "]"));
            }
            targModIDsList = new ArrayList<TargetModuleID>();
            for (i = 0; i < targModIDs.length; ++i) {
                if (!this.isValidTargetID(targModIDs[i], serIDs)) continue;
                TestUtil.logHarnessDebug((String)("&&&&&&&& Adding = " + targModIDs[i].getModuleID()));
                targModIDsList.add(targModIDs[i]);
                TestUtil.logHarnessDebug((String)("&&&&&&&& targModIDsList.size() is " + targModIDsList.size()));
                break;
            }
            if (targModIDsList.size() <= 0) continue;
            TargetModuleID[] validSerIDs = targModIDsList.toArray(new TargetModuleID[targModIDsList.size()]);
            result.put(modName, validSerIDs);
        }
        TestUtil.logHarnessDebug((String)"DUMP OF RESULT");
        this.dumpDeployedMods(result);
        TestUtil.logHarnessDebug((String)"END DUMP OF RESULT END");
        return result;
    }

    protected Hashtable normalizeMap(Hashtable map) {
        Hashtable<String, SerializableTargetID[]> result = new Hashtable<String, SerializableTargetID[]>();
        for (String key : map.keySet()) {
            TargetModuleID[] tmid = (TargetModuleID[])map.get(key);
            SerializableTargetID[] serIDs = new SerializableTargetID[tmid.length];
            for (int i = 0; i < tmid.length; ++i) {
                serIDs[i] = new SerializableTargetID(tmid[i]);
            }
            result.put(key, serIDs);
        }
        return result;
    }

    protected void writeMap(Hashtable map) throws IOException {
        this.deleteDeployedModulesState();
        ObjectOutputStream oout = null;
        Hashtable newMap = this.normalizeMap(map);
        try {
            oout = new ObjectOutputStream(new FileOutputStream(this.deployStateFile));
            oout.writeObject(newMap);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                oout.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable readMap() throws IOException {
        Hashtable result = null;
        File inFile = new File(this.deployStateFile);
        if (inFile.isFile()) {
            ObjectInputStream oin = null;
            try {
                oin = new ObjectInputStream(new FileInputStream(this.deployStateFile));
                result = (Hashtable)oin.readObject();
            }
            catch (IOException e) {
                throw e;
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
            finally {
                try {
                    oin.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    protected Hashtable getDeployedModules() {
        Hashtable result = null;
        Hashtable serMap = null;
        try {
            serMap = this.readMap();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (serMap == null) {
            result = new Hashtable();
        } else {
            try {
                result = this.normalizeMap(serMap, this.getTargets());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected void deleteDeployedModulesState() {
        try {
            File removeMe = new File(TEMP_DIR + File.separator + DEPLOYED_MODULES_FILE);
            removeMe.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Target[] getTargets() {
        return this.depMgr.getTargets();
    }

    static {
        TestUtil.initJavaTest();
        TEMP_DIR = System.getProperty("java.io.tmpdir");
        if (TEMP_DIR != null && TEMP_DIR.endsWith(File.separator)) {
            TEMP_DIR = TEMP_DIR.substring(0, TEMP_DIR.length() - 1);
        }
    }

    protected static class SerializableTargetID
    implements Serializable {
        private SerializableTarget target;
        private String moduleID;

        public SerializableTargetID(TargetModuleID id) {
            this.moduleID = id.getModuleID();
            this.target = new SerializableTarget(id.getTarget());
        }

        public SerializableTarget getTarget() {
            return this.target;
        }

        public String getModuleID() {
            return this.moduleID;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            SerializableTargetID that = null;
            if (obj instanceof SerializableTargetID) {
                that = (SerializableTargetID)obj;
                boolean bl = this.moduleID == null ? that.getModuleID() == null : (result = this.moduleID.equals(that.getModuleID()));
                result = result && (this.target == null ? that.getTarget() == null : this.target.equals(that.getTarget()));
            }
            return result;
        }
    }

    protected static class SerializableTarget
    implements Serializable {
        private String description;
        private String name;

        public SerializableTarget(Target target) {
            this.description = target.getDescription();
            this.name = target.getName();
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            SerializableTarget that = null;
            boolean result = false;
            if (this instanceof SerializableTarget) {
                that = (SerializableTarget)obj;
                boolean bl = this.description == null ? that.getDescription() == null : (result = this.description.equals(that.getDescription()));
                result = result && (this.name == null ? that.getName() == null : this.name.equals(that.getName()));
            }
            return result;
        }
    }
}

