/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.internal;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;

public class DestructibleBeanInstance<T> {
    private final T instance;
    private final InjectionTarget<T> injectionTarget;

    public DestructibleBeanInstance(BeanManager beanManager, Class<T> key) {
        this.injectionTarget = this.createInjectionTarget(beanManager, key);
        this.instance = DestructibleBeanInstance.createAndInjectBeans(beanManager, this.injectionTarget);
    }

    public DestructibleBeanInstance(BeanManager beanManager, T instance) {
        this.injectionTarget = this.createInjectionTarget(beanManager, instance.getClass());
        DestructibleBeanInstance.injectBeans(beanManager, beanManager.createCreationalContext(null), this.injectionTarget, instance);
        this.instance = instance;
    }

    public T getInstance() {
        return this.instance;
    }

    public void destroy() {
        this.injectionTarget.preDestroy(this.instance);
        this.injectionTarget.dispose(this.instance);
    }

    private InjectionTarget<T> createInjectionTarget(BeanManager beanManager, Class<T> type) {
        AnnotatedType annotatedType = beanManager.createAnnotatedType(type);
        return beanManager.createInjectionTarget(annotatedType);
    }

    private static <T> T createAndInjectBeans(BeanManager beanManager, InjectionTarget<T> injectionTarget) {
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        Object instance = injectionTarget.produce(creationalContext);
        DestructibleBeanInstance.injectBeans(beanManager, creationalContext, injectionTarget, instance);
        return (T)instance;
    }

    private static <T> void injectBeans(BeanManager beanManager, CreationalContext<T> creationalContext, InjectionTarget<T> injectionTarget, T instance) {
        injectionTarget.inject(instance, creationalContext);
        injectionTarget.postConstruct(instance);
    }
}

