/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.types.MessageDestinationReferenceContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;

public class MessageDestinationRefNode
extends DeploymentDescriptorNode<MessageDestinationReferenceDescriptor> {
    private MessageDestinationReferenceDescriptor descriptor;

    @Override
    public MessageDestinationReferenceDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new MessageDestinationReferenceDescriptor();
        }
        return this.descriptor;
    }

    @Override
    protected Map getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("jndi-name", "setJndiName");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("message-destination-ref-name".equals(element.getQName())) {
            XMLNode parentNode = this.getParentNode();
            Object parentDesc = null;
            parentDesc = parentNode.getDescriptor() instanceof WebBundleDescriptor ? parentNode.getDescriptor() : this.getParentNode().getDescriptor();
            if (parentDesc instanceof MessageDestinationReferenceContainer) {
                try {
                    this.descriptor = ((MessageDestinationReferenceContainer)parentDesc).getMessageDestinationReferenceByName(value);
                }
                catch (IllegalArgumentException iae) {
                    DOLUtils.getDefaultLogger().warning(iae.getMessage());
                }
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, MessageDestinationReferenceDescriptor msgDestRef) {
        Node msgDestRefNode = super.writeDescriptor(parent, nodeName, msgDestRef);
        MessageDestinationRefNode.appendTextChild(msgDestRefNode, "message-destination-ref-name", msgDestRef.getName());
        MessageDestinationRefNode.appendTextChild(msgDestRefNode, "jndi-name", msgDestRef.getJndiName());
        return msgDestRefNode;
    }

    public static void writeMessageDestinationReferences(Node parent, MessageDestinationReferenceContainer descriptor) {
        Iterator msgDestRefs = descriptor.getMessageDestinationReferenceDescriptors().iterator();
        if (msgDestRefs.hasNext()) {
            MessageDestinationRefNode messageDestinationRefNode = new MessageDestinationRefNode();
            while (msgDestRefs.hasNext()) {
                messageDestinationRefNode.writeDescriptor(parent, "message-destination-ref", (MessageDestinationReferenceDescriptor)msgDestRefs.next());
            }
        }
    }
}

