/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.namespace.QName;
import org.glassfish.deployment.common.Descriptor;

public class ServiceRefPortInfo
extends Descriptor {
    private String serviceEndpointInterface;
    private boolean containerManaged;
    private String portComponentLinkName;
    private WebServiceEndpoint portComponentLink;
    private ServiceReferenceDescriptor serviceRef;
    private QName wsdlPort;
    private Set stubProperties;
    private Set callProperties;
    private String targetEndpointAddress;
    private MessageSecurityBindingDescriptor messageSecBindingDesc = null;
    private String mtomEnabled = null;

    public ServiceRefPortInfo(ServiceRefPortInfo other) {
        super((Descriptor)other);
        this.serviceEndpointInterface = other.serviceEndpointInterface;
        this.containerManaged = other.containerManaged;
        this.portComponentLinkName = other.portComponentLinkName;
        this.portComponentLink = other.portComponentLink;
        this.serviceRef = other.serviceRef;
        this.wsdlPort = other.wsdlPort;
        this.mtomEnabled = other.mtomEnabled;
        this.stubProperties = new HashSet();
        Iterator i = other.stubProperties.iterator();
        while (i.hasNext()) {
            this.stubProperties.add(new NameValuePairDescriptor((NameValuePairDescriptor)((Object)i.next())));
        }
        this.callProperties = new HashSet();
        i = other.callProperties.iterator();
        while (i.hasNext()) {
            this.callProperties.add(new NameValuePairDescriptor((NameValuePairDescriptor)((Object)i.next())));
        }
        this.targetEndpointAddress = other.targetEndpointAddress;
    }

    public ServiceRefPortInfo() {
        this.stubProperties = new HashSet();
        this.callProperties = new HashSet();
        this.containerManaged = false;
    }

    public void setServiceReference(ServiceReferenceDescriptor desc) {
        this.serviceRef = desc;
    }

    public ServiceReferenceDescriptor getServiceReference() {
        return this.serviceRef;
    }

    public boolean hasServiceEndpointInterface() {
        return this.serviceEndpointInterface != null;
    }

    public void setServiceEndpointInterface(String sei) {
        this.serviceEndpointInterface = sei;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setIsContainerManaged(boolean flag) {
        this.containerManaged = flag;
    }

    public boolean isContainerManaged() {
        return this.containerManaged;
    }

    public boolean isClientManaged() {
        return !this.containerManaged;
    }

    public void setPortComponentLinkName(String linkName) {
        this.setPortComponentLinkName(linkName, false);
    }

    public WebServiceEndpoint setPortComponentLinkName(String linkName, boolean resolve) {
        this.portComponentLinkName = linkName;
        return resolve ? this.resolveLinkName() : null;
    }

    public boolean hasPortComponentLinkName() {
        return this.portComponentLinkName != null;
    }

    public String getPortComponentLinkName() {
        return this.portComponentLinkName;
    }

    public void setMessageSecurityBinding(MessageSecurityBindingDescriptor messageSecBindingDesc) {
        this.messageSecBindingDesc = messageSecBindingDesc;
    }

    public MessageSecurityBindingDescriptor getMessageSecurityBinding() {
        return this.messageSecBindingDesc;
    }

    public boolean isLinkedToPortComponent() {
        return this.portComponentLinkName != null && this.portComponentLink != null;
    }

    public WebServiceEndpoint resolveLinkName() {
        WebServiceEndpoint port = null;
        String linkName = this.portComponentLinkName;
        if (linkName != null && linkName.length() > 0) {
            int hashIndex = linkName.indexOf(35);
            boolean absoluteLink = hashIndex != -1;
            BundleDescriptor bundleDescriptor = this.getBundleDescriptor();
            Application app = bundleDescriptor.getApplication();
            BundleDescriptor targetBundle = bundleDescriptor;
            String portName = linkName;
            if (app != null && absoluteLink) {
                String relativeModuleUri = linkName.substring(0, hashIndex);
                portName = linkName.substring(hashIndex + 1);
                targetBundle = app.getRelativeBundle(bundleDescriptor, relativeModuleUri);
            }
            if (targetBundle != null) {
                LinkedList<BundleDescriptor> bundles = new LinkedList<BundleDescriptor>();
                bundles.addFirst(targetBundle);
                if (app != null && !absoluteLink) {
                    bundles.addAll(app.getBundleDescriptors());
                }
                for (BundleDescriptor next : bundles) {
                    port = next.getWebServiceEndpointByName(portName);
                    if (port == null) continue;
                    this.setPortComponentLink(port);
                    break;
                }
            }
        }
        return port;
    }

    public WebServiceEndpoint getPortComponentLink() {
        return this.portComponentLink;
    }

    public void setPortComponentLink(WebServiceEndpoint newPort) {
        if (newPort != null) {
            BundleDescriptor bundleDescriptor = this.getBundleDescriptor();
            BundleDescriptor targetBundleDescriptor = newPort.getBundleDescriptor();
            String linkName = newPort.getEndpointName();
            if (bundleDescriptor != targetBundleDescriptor) {
                Application app = bundleDescriptor.getApplication();
                String relativeUri = app.getRelativeUri(bundleDescriptor, targetBundleDescriptor);
                linkName = relativeUri + "#" + linkName;
            }
            this.portComponentLinkName = linkName;
        }
        this.portComponentLink = newPort;
    }

    private BundleDescriptor getBundleDescriptor() {
        return this.serviceRef.getBundleDescriptor();
    }

    public boolean hasWsdlPort() {
        return this.wsdlPort != null;
    }

    public void setWsdlPort(QName port) {
        this.wsdlPort = port;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    public Set getStubProperties() {
        return this.stubProperties;
    }

    public boolean hasStubProperty(String name) {
        return this.getStubPropertyValue(name) != null;
    }

    public String getStubPropertyValue(String name) {
        String value = null;
        for (NameValuePairDescriptor next : this.stubProperties) {
            if (!next.getName().equals(name)) continue;
            value = next.getValue();
            break;
        }
        return value;
    }

    public NameValuePairDescriptor getStubPropertyByName(String name) {
        NameValuePairDescriptor prop = null;
        for (NameValuePairDescriptor next : this.stubProperties) {
            if (!next.getName().equals(name)) continue;
            prop = next;
            break;
        }
        return prop;
    }

    public void addStubProperty(NameValuePairDescriptor property) {
        NameValuePairDescriptor prop = this.getStubPropertyByName(property.getName());
        if (prop != null) {
            prop.setValue(property.getValue());
        } else {
            this.stubProperties.add(property);
        }
    }

    public void removeStubProperty(NameValuePairDescriptor property) {
        NameValuePairDescriptor prop = this.getStubPropertyByName(property.getName());
        if (prop != null) {
            this.stubProperties.remove((Object)property);
        }
    }

    public void addStubProperty(String name, String value) {
        NameValuePairDescriptor nvPair = new NameValuePairDescriptor();
        nvPair.setName(name);
        nvPair.setValue(value);
        this.addStubProperty(nvPair);
    }

    public Set getCallProperties() {
        return this.callProperties;
    }

    public boolean hasCallProperty(String name) {
        return this.getCallPropertyByName(name) != null;
    }

    public NameValuePairDescriptor getCallPropertyByName(String name) {
        NameValuePairDescriptor prop = null;
        for (NameValuePairDescriptor next : this.callProperties) {
            if (!next.getName().equals(name)) continue;
            prop = next;
            break;
        }
        return prop;
    }

    public void addCallProperty(NameValuePairDescriptor property) {
        NameValuePairDescriptor prop = this.getCallPropertyByName(property.getName());
        if (prop != null) {
            prop.setValue(property.getValue());
        } else {
            this.callProperties.add(property);
        }
    }

    public void removeCallProperty(NameValuePairDescriptor property) {
        NameValuePairDescriptor prop = this.getCallPropertyByName(property.getName());
        if (prop != null) {
            this.callProperties.remove((Object)property);
        }
    }

    public boolean hasTargetEndpointAddress() {
        return this.targetEndpointAddress != null;
    }

    public void setTargetEndpointAddress(String address) {
        this.targetEndpointAddress = address;
    }

    public String getTargetEndpointAddress() {
        return this.targetEndpointAddress;
    }

    public void setMtomEnabled(String value) {
        this.mtomEnabled = value;
    }

    public String getMtomEnabled() {
        return this.mtomEnabled;
    }
}

