/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ServerDirs {
    private final String serverName;
    private final File serverDir;
    private final File parentDir;
    private final File agentDir;
    private final File grandParentDir;
    private final File configDir;
    private final File domainXml;
    private final File pidFile;
    private final boolean valid;
    private final String localPassword;
    private final File localPasswordFile;
    private final File dasPropertiesFile;
    static final LocalStringsImpl strings = new LocalStringsImpl(ServerDirs.class);

    public ServerDirs() {
        this.serverName = null;
        this.serverDir = null;
        this.agentDir = null;
        this.parentDir = null;
        this.grandParentDir = null;
        this.configDir = null;
        this.domainXml = null;
        this.pidFile = null;
        this.valid = false;
        this.localPassword = null;
        this.localPasswordFile = null;
        this.dasPropertiesFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerDirs(File leaf) throws IOException {
        if (leaf == null) {
            throw new IllegalArgumentException(strings.get("ServerDirs.nullArg", "ServerDirs.ServerDirs()"));
        }
        if (!leaf.isDirectory()) {
            throw new IOException(strings.get("ServerDirs.badDir", leaf));
        }
        this.serverDir = SmartFile.sanitize(leaf);
        this.serverName = this.serverDir.getName();
        this.parentDir = this.serverDir.getParentFile();
        if (this.parentDir == null || !this.parentDir.isDirectory()) {
            throw new IOException(strings.get("ServerDirs.badParentDir", this.serverDir));
        }
        this.grandParentDir = this.parentDir.getParentFile();
        this.configDir = new File(this.serverDir, "config");
        this.domainXml = new File(this.configDir, "domain.xml");
        this.pidFile = new File(this.configDir, "pid");
        this.localPasswordFile = new File(this.configDir, "local-password");
        String localPasswordBuffer = null;
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(this.localPasswordFile));
            localPasswordBuffer = r.readLine();
        }
        catch (Exception exception) {
        }
        finally {
            this.localPassword = localPasswordBuffer;
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.agentDir = new File(this.parentDir, "agent");
        this.dasPropertiesFile = new File(this.parentDir, "agent/config/das.properties");
        this.valid = true;
    }

    public final String getServerName() {
        if (!this.valid) {
            return null;
        }
        return this.serverName;
    }

    public final String deletePidFile() {
        if (!this.valid) {
            return "Internal Error: ServerDirs is in an invalid state";
        }
        if (!this.pidFile.isFile()) {
            return null;
        }
        String message = "pid file " + this.pidFile + " exists, removing it.";
        if (!this.pidFile.delete()) {
            return message + "  Couldn't remove pid file";
        }
        return message;
    }

    public ServerDirs refresh() throws IOException {
        return new ServerDirs(this.serverDir);
    }

    public final File getServerDir() {
        if (!this.valid) {
            return null;
        }
        return this.serverDir;
    }

    public final File getAgentDir() {
        if (!this.valid) {
            return null;
        }
        return this.agentDir;
    }

    public final File getServerParentDir() {
        if (!this.valid) {
            return null;
        }
        return this.parentDir;
    }

    public final File getServerGrandParentDir() {
        if (!this.valid) {
            return null;
        }
        return this.grandParentDir;
    }

    public final File getDomainXml() {
        if (!this.valid) {
            return null;
        }
        return this.domainXml;
    }

    public final File getConfigDir() {
        if (!this.valid) {
            return null;
        }
        return this.configDir;
    }

    public final File getPidFile() {
        if (!this.valid) {
            return null;
        }
        return this.pidFile;
    }

    public final File getDasPropertiesFile() {
        return this.dasPropertiesFile;
    }

    public String getLocalPassword() {
        return this.localPassword;
    }

    public final File getLocalPasswordFile() {
        if (!this.valid) {
            return null;
        }
        return this.localPasswordFile;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return ObjectAnalyzer.toString(this);
    }
}

