/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;

public class ScheduleHandlers {
    private static final String[] DAYS_OF_WEEK = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] MONTHS = new String[]{"", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] DAYS_OF_MONTH = new String[33];
    private static final Map<String, String[]> values = new HashMap<String, String[]>();
    private static final String DAY_OF_WEEK = "dayOfWeek";
    private static final String DAY_OF_MONTH = "dayOfMonth";
    private static final String MONTH = "month";

    public static void getScheduleData(HandlerContext handlerCtx) {
        String scheduleName = (String)handlerCtx.getInputValue("scheduleName");
        String dayOfWeek = "*";
        String dayOfMonth = "*";
        String month = "*";
        if (scheduleName != null) {
            String endPoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/server-config/schedules/schedule/" + scheduleName;
            Map attribs = RestUtil.getAttributesMap(endPoint);
            dayOfWeek = (String)attribs.get(DAY_OF_WEEK);
            dayOfMonth = (String)attribs.get(DAY_OF_MONTH);
            month = (String)attribs.get(MONTH);
        }
        Map dayOfWeekMap = ScheduleHandlers.getDataMap(dayOfWeek, DAY_OF_WEEK);
        Map dayOfMonthMap = ScheduleHandlers.getDataMap(dayOfMonth, DAY_OF_MONTH);
        Map monthMap = ScheduleHandlers.getDataMap(month, MONTH);
        handlerCtx.setOutputValue(DAY_OF_WEEK, (Object)dayOfWeekMap);
        handlerCtx.setOutputValue(DAY_OF_MONTH, (Object)dayOfMonthMap);
        handlerCtx.setOutputValue(MONTH, (Object)monthMap);
    }

    private static Map getDataMap(String data, String type) {
        List dataList = GuiUtil.parseStringList(data, ",");
        String[] dataValues = values.get(type);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (String dataItem : dataList) {
            if (dataItem.equals("*")) {
                dataMap.put(dataItem, dataItem);
                continue;
            }
            try {
                int i = Integer.parseInt(dataItem);
                if (i < 0 || i >= dataValues.length) continue;
                dataMap.put(dataValues[i], String.valueOf(i));
            }
            catch (NumberFormatException e) {
                for (int i = 0; i < dataValues.length; ++i) {
                    if (!dataValues[i].equalsIgnoreCase(dataItem)) continue;
                    dataMap.put(dataItem, String.valueOf(i));
                }
            }
        }
        return dataMap;
    }

    public static void convertScheduleToString(HandlerContext handlerCtx) {
        Map map = (Map)handlerCtx.getInputValue("map");
        String delimiter = (String)handlerCtx.getInputValue("delimiter");
        String type = (String)handlerCtx.getInputValue("type");
        if (delimiter == null) {
            delimiter = ",";
        }
        String str = "";
        String[] data = values.get(type);
        for (Map.Entry e : map.entrySet()) {
            Object o = e.getValue();
            if (o == null) continue;
            if (((String)e.getKey()).equals("*")) {
                str = "*";
                break;
            }
            try {
                int val = Integer.parseInt(o.toString());
                if (val < 0 || val >= data.length) continue;
                if (str.length() > 0) {
                    str = str + ",";
                }
                str = str + data[val];
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.convertScheduleToString") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) continue;
                ex.printStackTrace();
            }
        }
        if (str.length() == 0) {
            str = "*";
        }
        handlerCtx.setOutputValue("str", (Object)str);
    }

    public static void sortMonths(HandlerContext handlerContext) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yy");
        ArrayList<Date> dateList = new ArrayList<Date>();
        String months = (String)handlerContext.getInputValue("months");
        List monthsList = GuiUtil.parseStringList(months, ",");
        for (String month : monthsList) {
            if (month.equals("*")) continue;
            try {
                Date date1 = formatter.parse("01-" + month + "-00");
                dateList.add(date1);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.sortMonths") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) continue;
                ex.printStackTrace();
            }
        }
        Collections.sort(dateList);
        handlerContext.setOutputValue("sortedList", dateList);
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            ScheduleHandlers.DAYS_OF_MONTH[i] = String.valueOf(i);
        }
        ScheduleHandlers.DAYS_OF_MONTH[i] = "last";
        values.put(DAY_OF_WEEK, DAYS_OF_WEEK);
        values.put(MONTH, MONTHS);
        values.put(DAY_OF_MONTH, DAYS_OF_MONTH);
    }
}

