/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.gadget;

import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import com.sun.jsftemplating.util.FileUtil;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.JSONUtil;
import org.glassfish.admingui.connector.GadgetModule;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

public class GadgetHandlers {
    public static void getGadgetModule(HandlerContext handlerCtx) {
        String gadgetName = (String)handlerCtx.getInputValue("name");
        URL url = null;
        try {
            if (!gadgetName.contains("://")) {
                url = FileUtil.searchForFile((String)gadgetName, null);
            }
            if (url == null) {
                url = new URL(gadgetName);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot creaqte URL from '" + gadgetName + "'!", ex);
        }
        GadgetModule module = GadgetHandlers.getGadgetModule(url);
        handlerCtx.setOutputValue("module", (Object)module);
    }

    public static GadgetModule getGadgetModule(URL url) {
        if (url == null) {
            return null;
        }
        ConfigParser parser = new ConfigParser(GuiUtil.getHabitat());
        Object id = null;
        DomDocument doc = parser.parse(url);
        GadgetModule module = (GadgetModule)doc.getRoot().get();
        return module;
    }

    public static Object invokeHandler(HandlerContext handlerCtx) {
        String handlerName = (String)handlerCtx.getInputValue("handler");
        HandlerDefinition handlerDef = LayoutDefinitionManager.getGlobalHandlerDefinition((String)handlerName);
        if (handlerDef == null) {
            throw new IllegalArgumentException("Handler '" + handlerName + "' not found!");
        }
        Handler oldHandler = handlerCtx.getHandler();
        Handler handler = new Handler(handlerDef);
        ArrayList<String> outputNames = new ArrayList<String>();
        String args = (String)handlerCtx.getInputValue("args");
        StringTokenizer tok = new StringTokenizer(args, ",");
        Object val = null;
        while (tok.hasMoreTokens()) {
            String nvp = tok.nextToken();
            int colon = nvp.indexOf(58);
            if (colon == -1) {
                throw new IllegalArgumentException("Handler I/O name:value must be separated by a ':'!");
            }
            String name = nvp.substring(0, colon).trim();
            String value = nvp.substring(colon + 1).trim();
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalArgumentException("Unable to decode value, this is not normal!", ex);
            }
            if (handlerDef.getInputDef(name) != null) {
                Object t;
                val = value.startsWith("{") && value.endsWith("}") ? (t = GadgetHandlers.parseString(value.substring(1, value.length() - 1))) : value;
                handler.setInputValue(name, val);
                continue;
            }
            handler.setOutputMapping(name, val.toString(), "el");
            outputNames.add(name);
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>(1);
        handlers.add(handler);
        Object result = handlerCtx.getLayoutElement().dispatchHandlers(handlerCtx, handlers);
        HashMap<String, Object> outputValues = new HashMap<String, Object>();
        for (String outName : outputNames) {
            outputValues.put(outName, handler.getOutputValue(handlerCtx, outName));
        }
        handlerCtx.setHandler(oldHandler);
        Integer depth = (Integer)handlerCtx.getInputValue("depth");
        if (depth == null) {
            depth = 10;
        }
        handlerCtx.setOutputValue("values", (Object)JSONUtil.javaToJSON(outputValues, depth));
        return result;
    }

    public static Object parseString(String test) {
        String[] strs;
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (String str : strs = test.split(",")) {
            str = str.trim();
            int end = str.length();
            int index = str.indexOf("=");
            newMap.put(str.substring(0, index), str.substring(index + 1, end));
        }
        return newMap;
    }
}

