/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.DomToXMLEventWriter;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLEventWriterRecord
extends MarshalRecord {
    private Map<String, String> prefixMapping;
    private NamespaceResolver namespaceResolver;
    private XMLEventWriter xmlEventWriter;
    private XMLEventFactory xmlEventFactory;
    private DomToXMLEventWriter domToXMLEventWriter;
    private boolean isStartElementOpen = false;
    private List attributes;
    private List namespaceDeclarations;
    private XPathFragment xPathFragment;

    public XMLEventWriterRecord(XMLEventWriter xmlEventWriter) {
        this.xmlEventWriter = xmlEventWriter;
        this.xmlEventFactory = XMLEventFactory.newInstance();
        this.domToXMLEventWriter = new DomToXMLEventWriter(this.xmlEventFactory);
    }

    public XMLEventWriter getXMLEventWriter() {
        return this.xmlEventWriter;
    }

    public void setXMLEventWriter(XMLEventWriter anXMLEventWriter) {
        this.xmlEventWriter = anXMLEventWriter;
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        Attribute event;
        String namespaceURI = xPathFragment.getNamespaceURI();
        if (namespaceURI == null) {
            event = this.xmlEventFactory.createAttribute(xPathFragment.getLocalName(), value);
        } else {
            String prefix = this.getPrefixForFragment(xPathFragment);
            if (prefix == null) {
                event = this.xmlEventFactory.createAttribute(null, namespaceURI, xPathFragment.getLocalName(), value);
            } else {
                if (this.xmlEventWriter.getNamespaceContext().getNamespaceURI(prefix) == null || !this.xmlEventWriter.getNamespaceContext().getNamespaceURI(prefix).equals(namespaceURI)) {
                    event = this.xmlEventFactory.createNamespace(prefix, namespaceURI);
                    try {
                        this.xmlEventWriter.setPrefix(prefix, namespaceURI);
                    }
                    catch (XMLStreamException e) {
                        throw XMLMarshalException.marshalException(e);
                    }
                }
                event = this.xmlEventFactory.createAttribute(prefix, namespaceURI, xPathFragment.getLocalName(), value);
            }
        }
        if (event.isNamespace()) {
            if (this.namespaceDeclarations == null) {
                this.namespaceDeclarations = new ArrayList();
            }
            this.namespaceDeclarations.add(event);
        } else {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(event);
        }
    }

    @Override
    public void attribute(String namespaceURI, String localName, String name, String value) {
        Attribute event;
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            try {
                if ("xmlns".equals(localName)) {
                    event = this.xmlEventFactory.createNamespace(value);
                    this.xmlEventWriter.setDefaultNamespace(value);
                }
                event = this.xmlEventFactory.createNamespace(localName, value);
                this.xmlEventWriter.setPrefix(localName, value);
            }
            catch (XMLStreamException e) {
                throw XMLMarshalException.marshalException(e);
            }
        } else if (namespaceURI == null || namespaceURI.length() == 0) {
            event = this.xmlEventFactory.createAttribute(localName, value);
        } else {
            int index = name.indexOf(58);
            if (index == -1) {
                event = this.xmlEventFactory.createAttribute("", namespaceURI, localName, value);
            } else {
                String prefix = name.substring(0, index);
                event = this.xmlEventFactory.createAttribute(prefix, namespaceURI, localName, value);
            }
        }
        if (event.isNamespace()) {
            if (this.namespaceDeclarations == null) {
                this.namespaceDeclarations = new ArrayList();
            }
            this.namespaceDeclarations.add(event);
        } else {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(event);
        }
    }

    private void openAndCloseStartElement() {
        try {
            String namespaceURI = this.xPathFragment.getNamespaceURI();
            if (namespaceURI == null) {
                Iterator attributesIterator = null;
                if (this.attributes != null) {
                    attributesIterator = this.attributes.iterator();
                }
                Iterator namespaceDeclarationsIterator = null;
                if (this.namespaceDeclarations != null) {
                    namespaceDeclarationsIterator = this.namespaceDeclarations.iterator();
                }
                this.xmlEventWriter.add(this.xmlEventFactory.createStartElement("", "", this.xPathFragment.getLocalName(), attributesIterator, namespaceDeclarationsIterator));
                String defaultNamespace = this.xmlEventWriter.getNamespaceContext().getNamespaceURI("");
                if (defaultNamespace != null && defaultNamespace.length() > 0) {
                    this.xmlEventWriter.setDefaultNamespace("");
                    this.xmlEventWriter.add(this.xmlEventFactory.createNamespace(""));
                }
            } else {
                String prefix = this.getPrefixForFragment(this.xPathFragment);
                if (prefix == null) {
                    prefix = "";
                }
                Iterator attributesIterator = null;
                if (this.attributes != null) {
                    attributesIterator = this.attributes.iterator();
                }
                Iterator namespaceDeclarationsIterator = null;
                if (this.namespaceDeclarations != null) {
                    namespaceDeclarationsIterator = this.namespaceDeclarations.iterator();
                }
                this.xmlEventWriter.add(this.xmlEventFactory.createStartElement(prefix, namespaceURI, this.xPathFragment.getLocalName(), attributesIterator, namespaceDeclarationsIterator));
            }
        }
        catch (XMLStreamException ex) {
            throw XMLMarshalException.marshalException(ex);
        }
    }

    @Override
    public void cdata(String value) {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            for (String part : MarshalRecord.splitCData(value)) {
                this.xmlEventWriter.add(this.xmlEventFactory.createCData(part));
            }
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void characters(String value) {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            this.xmlEventWriter.add(this.xmlEventFactory.createCharacters(value));
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void closeStartElement() {
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
        }
        this.isStartElementOpen = true;
        this.xPathFragment = xPathFragment;
        this.attributes = null;
        this.namespaceDeclarations = null;
        if (xPathFragment.isGeneratedPrefix()) {
            this.namespaceDeclaration(xPathFragment.getPrefix(), xPathFragment.getNamespaceURI());
        }
        this.writePrefixMappings();
    }

    @Override
    public void element(XPathFragment frag) {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            String namespaceURI = frag.getNamespaceURI();
            String localName = frag.getLocalName();
            String prefix = this.getPrefixForFragment(this.xPathFragment);
            if (prefix == null) {
                prefix = "";
            }
            this.xmlEventWriter.add(this.xmlEventFactory.createStartElement(prefix, namespaceURI, localName));
            this.xmlEventWriter.add(this.xmlEventFactory.createEndElement(prefix, namespaceURI, localName));
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void endDocument() {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            this.xmlEventWriter.add(this.xmlEventFactory.createEndDocument());
            this.xmlEventWriter.flush();
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void endElement(XPathFragment pathFragment, NamespaceResolver namespaceResolver) {
        String prefix;
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        if ((prefix = this.getPrefixForFragment(pathFragment)) == null) {
            prefix = "";
        }
        try {
            this.xmlEventWriter.add(this.xmlEventFactory.createEndElement(prefix, this.xPathFragment.getNamespaceURI(), pathFragment.getLocalName()));
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void node(Node node, NamespaceResolver resolver, String uri, String name) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            if (node.getNodeType() == 9) {
                node = ((Document)node).getDocumentElement();
            }
            this.domToXMLEventWriter.writeToEventWriter(node, uri, name, this.xmlEventWriter);
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void startDocument(String encoding, String version) {
        try {
            this.xmlEventWriter.add(this.xmlEventFactory.createStartDocument(encoding, version, false));
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceUri) {
        if (this.prefixMapping == null) {
            this.prefixMapping = new HashMap<String, String>();
        }
        this.prefixMapping.put(prefix, namespaceUri);
    }

    private void writePrefixMappings() {
        if (this.namespaceResolver != null) {
            String defaultNamespace = this.namespaceResolver.getDefaultNamespaceURI();
            if (defaultNamespace != null) {
                Namespace namespace = this.xmlEventFactory.createNamespace("", defaultNamespace);
                if (this.namespaceDeclarations == null) {
                    this.namespaceDeclarations = new ArrayList();
                }
                this.namespaceDeclarations.add(namespace);
            }
            if (this.namespaceResolver.hasPrefixesToNamespaces()) {
                for (Map.Entry<String, String> entry : this.namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                    Namespace namespace = this.xmlEventFactory.createNamespace(entry.getKey(), entry.getValue());
                    if (this.namespaceDeclarations == null) {
                        this.namespaceDeclarations = new ArrayList();
                    }
                    this.namespaceDeclarations.add(namespace);
                }
            }
            this.namespaceResolver = null;
        }
        if (this.prefixMapping != null) {
            for (Map.Entry<String, String> entry : this.prefixMapping.entrySet()) {
                Namespace namespace = this.xmlEventFactory.createNamespace(entry.getKey(), entry.getValue());
                if (this.namespaceDeclarations == null) {
                    this.namespaceDeclarations = new ArrayList();
                }
                this.namespaceDeclarations.add(namespace);
            }
            this.prefixMapping = null;
        }
    }

    @Override
    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }
}

