/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.AdminAuthorizedMBeanServer;
import org.glassfish.admin.mbeanserver.BootAMX;
import org.glassfish.admin.mbeanserver.BootAMXListener;
import org.glassfish.admin.mbeanserver.ConnectorStarter;
import org.glassfish.admin.mbeanserver.RMIConnectorStarter;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.Globals;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(mode=0, value=20)
public final class JMXStartupService
implements PostConstruct {
    private static final Logger JMX_LOGGER = Util.JMX_LOGGER;
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    private Domain mDomain;
    @Inject
    @Named(value="default-instance-name")
    private AdminService mAdminService;
    @Inject
    private ServiceLocator mHabitat;
    @Inject
    Events mEvents;
    static ServiceLocator habitat = Globals.getDefaultHabitat();
    @Inject
    private ServerEnvironment serverEnv;
    private volatile JMXConnectorStatus jmxConnectorstatus = JMXConnectorStatus.STOPPED;
    private Object lock = new Object();
    private volatile BootAMX mBootAMX;
    private volatile JMXConnectorsStarterThread mConnectorsStarterThread;
    @LogMessageInfo(message="JMXStartupService and JMXConnectors have been shut down.", level="INFO")
    private static final String JMX_STARTUPSERVICE_SHUTDOWN = "NCLS-JMX-00001";
    @LogMessageInfo(message="JMXStartupService: Stopped JMXConnectorServer: {0}", level="INFO")
    private static final String JMX_STARTUPSERVICE_STOPPED_JMX_CONNECTOR = "NCLS-JMX-00002";
    @LogMessageInfo(message="MBean Registration Exception thrown {0}", level="SEVERE", cause="JMX Connector Server MBean could not be unregistered.", action="Take appropriate action based on the exception message.")
    private static final String JMX_MBEAN_REG_EXCEPTION = "NCLS-JMX-00003";
    @LogMessageInfo(message="Instance Not Found Exception thrown {0}", level="SEVERE", cause="JMX Connector Server MBean instance not found.", action="Take appropriate action based on the exception message.")
    private static final String JMX_INSTANCE_NOT_FOUND_EXCEPTION = "NCLS-JMX-00004";
    @LogMessageInfo(message="JMXStartupService has started JMXConnector on JMXService URL {0}", level="INFO")
    private static final String JMX_STARTED_SERVICE = "NCLS-JMX-00005";
    @LogMessageInfo(message="JMXStartupService has disabled JMXConnector {0}", level="INFO")
    private static final String JMX_STARTED_SERVICE_DISABLED = "NCLS-JMX-00006";
    @LogMessageInfo(message="Cannot start JMX connector {0} due to exception {1}", level="WARNING")
    private static final String JMX_CANNOT_START_CONNECTOR = "NCLS-JMX-00007";
    public static final String JMX_CONNECTOR_SERVER_PREFIX = "jmxremote:type=jmx-connector-server";

    private static void debug(String s) {
        System.out.println("### " + s);
    }

    public JMXStartupService() {
        this.mMBeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilJMXConnectorStarted() {
        Object object = this.lock;
        synchronized (object) {
            while (this.jmxConnectorstatus != JMXConnectorStatus.STARTED) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void postConstruct() {
        this.mBootAMX = BootAMX.create(this.mHabitat, this.mMBeanServer);
        List configuredConnectors = this.mAdminService.getJmxConnector();
        boolean autoStart = false;
        this.mConnectorsStarterThread = new JMXConnectorsStarterThread(AdminAuthorizedMBeanServer.newInstance(this.mMBeanServer, this.serverEnv.isInstance(), this.mBootAMX), configuredConnectors, this.mBootAMX, true, this);
        this.mConnectorsStarterThread.start();
        this.mEvents.register((EventListener)new ShutdownListener());
    }

    private synchronized void shutdown() {
        JMX_LOGGER.fine("JMXStartupService: shutting down AMX and JMX");
        if (this.mBootAMX != null) {
            this.mBootAMX.shutdown();
        }
        this.mBootAMX = null;
        if (this.mConnectorsStarterThread != null) {
            this.mConnectorsStarterThread.shutdown();
        }
        this.mConnectorsStarterThread = null;
        if (MBeanServerFactory.findMBeanServer(null).size() > 0) {
            MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
            MBeanServerFactory.releaseMBeanServer(server);
        }
        JMX_LOGGER.log(Level.INFO, JMX_STARTUPSERVICE_SHUTDOWN);
    }

    public static final Set<ObjectName> getJMXConnectorServers(MBeanServer server) {
        try {
            ObjectName queryPattern = new ObjectName("jmxremote:type=jmx-connector-server,*");
            return server.queryNames(queryPattern, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JMXServiceURL[] getJMXServiceURLs(MBeanServer server) {
        Set<ObjectName> objectNames = JMXStartupService.getJMXConnectorServers(server);
        ArrayList<JMXServiceURL> urls = new ArrayList<JMXServiceURL>();
        for (ObjectName objectName : objectNames) {
            try {
                urls.add((JMXServiceURL)server.getAttribute(objectName, "Address"));
            }
            catch (JMException e) {
                e.printStackTrace();
            }
        }
        return urls.toArray(new JMXServiceURL[urls.size()]);
    }

    private static final class JMXConnectorsStarterThread
    extends Thread {
        private final List<JmxConnector> mConfiguredConnectors;
        private final MBeanServer mMBeanServer;
        private final BootAMX mAMXBooterNew;
        private final boolean mNeedBootListeners;
        ConnectorStarter starter;
        ObjectName connObjectName;
        JMXStartupService service;
        private final List<JMXConnectorServer> mConnectorServers = new ArrayList<JMXConnectorServer>();

        public JMXConnectorsStarterThread(MBeanServer mbs, List<JmxConnector> configuredConnectors, BootAMX amxBooter, boolean needBootListeners, JMXStartupService service) {
            this.mMBeanServer = mbs;
            this.mConfiguredConnectors = configuredConnectors;
            this.mAMXBooterNew = amxBooter;
            this.mNeedBootListeners = needBootListeners;
            this.service = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            if (this.starter != null && this.starter instanceof RMIConnectorStarter) {
                ((RMIConnectorStarter)this.starter).stopAndUnexport();
            }
            try {
                if (this.connObjectName != null) {
                    this.mMBeanServer.unregisterMBean(this.connObjectName);
                    this.connObjectName = null;
                }
            }
            catch (MBeanRegistrationException ex) {
                JMX_LOGGER.log(Level.SEVERE, JMXStartupService.JMX_MBEAN_REG_EXCEPTION, ex);
            }
            catch (InstanceNotFoundException ex) {
                JMX_LOGGER.log(Level.SEVERE, JMXStartupService.JMX_INSTANCE_NOT_FOUND_EXCEPTION, ex);
            }
            Object object = this.service.lock;
            synchronized (object) {
                for (JMXConnectorServer connector : this.mConnectorServers) {
                    try {
                        JMXServiceURL address = connector.getAddress();
                        connector.stop();
                        JMX_LOGGER.log(Level.INFO, JMXStartupService.JMX_STARTUPSERVICE_STOPPED_JMX_CONNECTOR, address);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.service.jmxConnectorstatus = JMXConnectorStatus.STOPPED;
            }
            this.mConnectorServers.clear();
        }

        private static String toString(JmxConnector c) {
            return "JmxConnector config: { name = " + c.getName() + ", Protocol = " + c.getProtocol() + ", Address = " + c.getAddress() + ", Port = " + c.getPort() + ", AcceptAll = " + c.getAcceptAll() + ", AuthRealmName = " + c.getAuthRealmName() + ", SecurityEnabled = " + c.getSecurityEnabled() + "}";
        }

        private JMXConnectorServer startConnector(JmxConnector connConfig) throws IOException {
            BootAMXListener listener;
            JMX_LOGGER.log(Level.FINE, "Starting JMXConnector: {0}", JMXConnectorsStarterThread.toString(connConfig));
            String protocol = connConfig.getProtocol();
            String address = connConfig.getAddress();
            int port = Integer.parseInt(connConfig.getPort());
            boolean securityEnabled = Boolean.parseBoolean(connConfig.getSecurityEnabled());
            Ssl ssl = connConfig.getSsl();
            JMXConnectorServer server = null;
            BootAMXListener bootAMXListener = listener = this.mNeedBootListeners ? new BootAMXListener(this.mAMXBooterNew) : null;
            if (!protocol.equals("rmi_jrmp")) {
                throw new IllegalArgumentException("JMXStartupService.startConnector(): Unknown protocol: " + protocol);
            }
            this.starter = new RMIConnectorStarter(this.mMBeanServer, address, port, protocol, securityEnabled, habitat, listener, ssl);
            server = ((RMIConnectorStarter)this.starter).start();
            if (listener != null) {
                listener.setServer(server);
            }
            JMXServiceURL url = server.getAddress();
            JMX_LOGGER.log(Level.INFO, JMXStartupService.JMX_STARTED_SERVICE, url);
            try {
                this.connObjectName = new ObjectName("jmxremote:type=jmx-connector-server,protocol=" + protocol + ",name=" + connConfig.getName());
                this.mMBeanServer.registerMBean(server, this.connObjectName).getObjectName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.service.lock;
            synchronized (object) {
                for (JmxConnector c : this.mConfiguredConnectors) {
                    if (!Boolean.parseBoolean(c.getEnabled())) {
                        JMX_LOGGER.log(Level.INFO, JMXStartupService.JMX_STARTED_SERVICE_DISABLED, c.getName());
                        continue;
                    }
                    try {
                        JMXConnectorServer server = this.startConnector(c);
                        this.mConnectorServers.add(server);
                    }
                    catch (Throwable t) {
                        JMX_LOGGER.log(Level.WARNING, JMXStartupService.JMX_CANNOT_START_CONNECTOR, new Object[]{JMXConnectorsStarterThread.toString(c), t});
                        t.printStackTrace();
                    }
                }
                this.service.jmxConnectorstatus = JMXConnectorStatus.STARTED;
                this.service.lock.notifyAll();
            }
        }
    }

    private static final class BootAMXThread
    extends Thread {
        private final BootAMX mBooter;

        public BootAMXThread(BootAMX booter) {
            this.mBooter = booter;
        }

        @Override
        public void run() {
            this.mBooter.bootAMX();
        }
    }

    private final class ShutdownListener
    implements EventListener {
        private ShutdownListener() {
        }

        public void event(EventListener.Event event) {
            if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
                JMXStartupService.this.shutdown();
            }
        }
    }

    public static enum JMXConnectorStatus {
        STOPPED,
        STARTED;

    }
}

