/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class LocalStringsImpl {
    private ResourceBundle bundle;
    private String propsName = "LocalStrings";
    private static final String thisPackage = "com.elf.util";
    private static final ResourceBundle.Control rbcontrol = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);

    public LocalStringsImpl() {
        this.setBundle();
    }

    public LocalStringsImpl(Class clazz) {
        this.setBundle(clazz);
    }

    public LocalStringsImpl(String packageName, String propsName) {
        this.propsName = propsName;
        int len = packageName.length();
        if (packageName.charAt(len - 1) != '.') {
            packageName = packageName + '.';
        }
        this.setBundle(packageName);
    }

    public String get(String indexString) {
        try {
            return this.getBundle().getString(indexString);
        }
        catch (Exception e) {
            return indexString;
        }
    }

    public String get(String indexString, Object ... objects) {
        indexString = this.get(indexString);
        try {
            MessageFormat mf = new MessageFormat(indexString);
            return mf.format(objects);
        }
        catch (Exception e) {
            return indexString;
        }
    }

    public String getString(String indexString, String defaultValue) {
        try {
            return this.getBundle().getString(indexString);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getInt(String indexString, int defaultValue) {
        try {
            String s = this.getBundle().getString(indexString);
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String indexString, boolean defaultValue) {
        try {
            return Boolean.valueOf(this.getBundle().getString(indexString));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private ResourceBundle getBundle() {
        return this.bundle;
    }

    private void setBundle() {
        try {
            StackTraceElement[] items = Thread.currentThread().getStackTrace();
            int lastMeOnStack = -1;
            for (int i = 0; i < items.length; ++i) {
                StackTraceElement item = items[i];
                if (!item.getClassName().startsWith(thisPackage)) continue;
                lastMeOnStack = i;
            }
            String className = items[lastMeOnStack + 1].getClassName();
            this.setBundle(className);
        }
        catch (Exception e) {
            this.bundle = null;
        }
    }

    private void setBundle(Class clazz) {
        try {
            String className = clazz.getName();
            this.setBundle(className);
            if (this.bundle == null) {
                String props = className.substring(0, className.lastIndexOf(46)) + "." + this.propsName;
                this.bundle = ResourceBundle.getBundle(props, Locale.getDefault(), clazz.getClassLoader(), rbcontrol);
            }
        }
        catch (Exception e) {
            this.bundle = null;
        }
    }

    private void setBundle(String className) {
        try {
            String props = className.substring(0, className.lastIndexOf(46)) + "." + this.propsName;
            this.bundle = ResourceBundle.getBundle(props, rbcontrol);
        }
        catch (Exception e) {
            this.bundle = null;
        }
    }
}

