/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.GeneratorException;
import org.glassfish.admin.rest.generator.ResourcesGeneratorBase;
import org.glassfish.admin.rest.generator.TextClassWriter;
import org.glassfish.hk2.api.ServiceLocator;

public class TextResourcesGenerator
extends ResourcesGeneratorBase {
    private File generationDir;

    public TextResourcesGenerator(String outputDir, ServiceLocator habitat) {
        super(habitat);
        this.generationDir = new File(outputDir);
        if (!this.generationDir.mkdirs()) {
            throw new RuntimeException("Unable to create output directory: " + outputDir);
        }
    }

    @Override
    public ClassWriter getClassWriter(String className, String baseClassName, String resourcePath) {
        TextClassWriter writer = null;
        try {
            writer = new TextClassWriter(this.habitat, this.generationDir, className, baseClassName, resourcePath);
        }
        catch (IOException e) {
            RestLogging.restLogger.log(Level.SEVERE, e.getMessage());
            throw new GeneratorException(e);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String endGeneration() {
        File file = new File(this.generationDir + "/codegeneration.properties");
        BufferedWriter out = null;
        try {
            if (file.createNewFile()) {
                FileWriter fstream = new FileWriter(file);
                out = new BufferedWriter(fstream);
                out.write("generation_date=" + new Date() + "\n");
            } else {
                RestLogging.restLogger.log(Level.SEVERE, "NCLS-REST-00013", "codegeneration.properties");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    RestLogging.restLogger.log(Level.SEVERE, null, ex);
                }
            }
        }
        return "Code Generation done at : " + this.generationDir;
    }

    @Override
    protected boolean alreadyGenerated(String className) {
        return false;
    }
}

