/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.auth.login.PasswordLoginModule;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;

public class FileLoginModule
extends PasswordLoginModule {
    @Override
    protected void authenticate() throws LoginException {
        if (!(this._currentRealm instanceof FileRealm)) {
            String msg = sm.getString("filelm.badrealm");
            throw new LoginException(msg);
        }
        FileRealm fileRealm = (FileRealm)this._currentRealm;
        String[] grpList = fileRealm.authenticate(this._username, this.getPasswordChar());
        if (grpList == null) {
            String msg = sm.getString("filelm.faillogin", (Object)this._username);
            throw new LoginException(msg);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "File login succeeded for: " + this._username);
        }
        this.commitAuthentication(this._username, this.getPasswordChar(), this._currentRealm, grpList);
    }
}

