/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.zip;

import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ZipWriter {
    private String dirName = null;
    private OutputStream userStream;
    private File userOutFile;
    private ZipOutputStream zipStream;
    private byte[] buffer = new byte[16384];
    private ZipItem[] items = null;

    public ZipWriter(String zipFilename, String dirName) throws ZipFileException {
        this.init(zipFilename, dirName);
        this.createItemList(null);
    }

    public ZipWriter(String zipFilename, String dirName, ZipItem[] theItems) throws ZipFileException {
        this.items = theItems;
        this.init(zipFilename, dirName);
    }

    public ZipWriter(String zipFilename, String dirName, String[] fileList) throws ZipFileException {
        this.init(zipFilename, dirName);
        this.createItemList(fileList);
    }

    public ZipWriter(OutputStream outStream, String dirName, String[] fileList) throws ZipFileException {
        this.init(outStream, dirName);
        this.createItemList(fileList);
    }

    public void excludeDirs(String[] dirs) {
        if (dirs == null || dirs.length <= 0) {
            return;
        }
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].endsWith("/")) continue;
            int n = i;
            dirs[n] = dirs[n] + "/";
        }
        ArrayList<ZipItem> list = new ArrayList<ZipItem>(this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            boolean exclude = false;
            for (int j = 0; j < dirs.length; ++j) {
                if (!this.items[i].name.startsWith(dirs[j])) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            list.add(this.items[i]);
        }
        if (list.size() != this.items.length) {
            this.items = new ZipItem[list.size()];
            this.items = list.toArray(this.items);
        }
    }

    public void excludeDirsAnywhere(String[] dirs) {
        if (dirs == null || dirs.length <= 0) {
            return;
        }
        for (int i = 0; i < dirs.length; ++i) {
            if (!dirs[i].startsWith("/")) {
                dirs[i] = "/" + dirs[i];
            }
            if (dirs[i].endsWith("/")) continue;
            int n = i;
            dirs[n] = dirs[n] + "/";
        }
        ArrayList<ZipItem> list = new ArrayList<ZipItem>(this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            boolean exclude = false;
            String item = "/" + this.items[i].name;
            for (int j = 0; j < dirs.length; ++j) {
                if (item.indexOf(dirs[j]) < 0) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            list.add(this.items[i]);
        }
        if (list.size() != this.items.length) {
            this.items = new ZipItem[list.size()];
            this.items = list.toArray(this.items);
        }
    }

    private void init(String outFileName, String dirName) throws ZipFileException {
        try {
            this.init((OutputStream)null, dirName);
            this.userOutFile = new File(outFileName);
        }
        catch (Exception e) {
            throw new ZipFileException(e);
        }
    }

    private void close() {
        try {
            if (this.zipStream != null) {
                this.zipStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.zipStream = null;
    }

    private void init(OutputStream outStream, String dirName) throws ZipFileException {
        try {
            this.userStream = outStream;
            if (dirName == null) {
                throw new IllegalArgumentException("null dirName");
            }
            File f = new File(dirName);
            if (!f.exists()) {
                throw new ZipFileException("directory (" + dirName + ") doesn't exist");
            }
            if (!f.isDirectory()) {
                throw new ZipFileException(dirName + " is not a directory");
            }
            try {
                dirName = f.getCanonicalPath();
            }
            catch (IOException e) {
                dirName = f.getAbsolutePath();
            }
            dirName = dirName.replace('\\', '/');
            if (!dirName.endsWith("/")) {
                dirName = dirName + "/";
            }
            this.dirName = dirName;
        }
        catch (ZipFileException zfe) {
            throw zfe;
        }
        catch (Throwable t) {
            throw new ZipFileException(t);
        }
    }

    public void safeWrite() throws ZipFileException {
        try {
            this.setupZipStream();
            for (int i = 0; i < this.items.length; ++i) {
                try {
                    this.addEntry(this.items[i]);
                    continue;
                }
                catch (ZipException zipException) {
                    // empty catch block
                }
            }
        }
        catch (ZipFileException z) {
            throw z;
        }
        catch (Exception e) {
            throw new ZipFileException(e);
        }
        finally {
            this.close();
        }
    }

    public void write() throws ZipFileException {
        try {
            this.setupZipStream();
            for (int i = 0; i < this.items.length; ++i) {
                this.addEntry(this.items[i]);
            }
        }
        catch (ZipFileException z) {
            throw z;
        }
        catch (Exception e) {
            throw new ZipFileException(e);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(ZipItem item) throws ZipFileException, IOException {
        int totalBytes = 0;
        ZipEntry ze = new ZipEntry(item.name);
        this.zipStream.putNextEntry(ze);
        if (!item.name.endsWith("/")) {
            FileInputStream in = new FileInputStream(item.file);
            try {
                int numBytes = in.read(this.buffer);
                while (numBytes > 0) {
                    this.zipStream.write(this.buffer, 0, numBytes);
                    totalBytes += numBytes;
                    numBytes = in.read(this.buffer);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.zipStream.closeEntry();
        Logger.getAnonymousLogger().finer("Wrote " + item.name + " to Zip File.  Wrote " + totalBytes + " bytes.");
    }

    private void createItemList(String[] files) throws ZipFileException {
        try {
            if (files == null) {
                FileListerRelative lister = new FileListerRelative(new File(this.dirName));
                files = lister.getFiles();
            }
            if (files.length <= 0) {
                throw new ZipFileException("No files to add!");
            }
            this.items = new ZipItem[files.length];
            for (int i = 0; i < files.length; ++i) {
                File f = new File(this.dirName + files[i]);
                this.items[i] = new ZipItem(f, files[i].replace('\\', '/'));
                if (!f.isDirectory()) continue;
                this.items[i].name = this.items[i].name + "/";
            }
        }
        catch (Throwable t) {
            throw new ZipFileException(t);
        }
    }

    String getDirName() {
        return this.dirName;
    }

    private static void usage() {
        System.out.println("usage: java com.elf.util.zip.ZipWriter zip-filename directory-name");
    }

    public static void main(String[] args) {
        if (args == null || args.length != 2) {
            ZipWriter.usage();
            return;
        }
        try {
            ZipWriter zw = new ZipWriter(args[0], args[1]);
            zw.write();
        }
        catch (ZipFileException zipFileException) {
            // empty catch block
        }
    }

    private void setupZipStream() throws FileNotFoundException {
        this.zipStream = this.userStream != null ? new ZipOutputStream(this.userStream) : new ZipOutputStream(new FileOutputStream(this.userOutFile));
    }
}

